/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class ReflectJavaClassifierType
extends ReflectJavaType
implements JavaClassifierType {
    private final Type reflectType;
    private final JavaClassifier classifier;

    public ReflectJavaClassifierType(Type type) {
        JavaClassifier javaClassifier;
        Type type2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        this.reflectType = type;
        ReflectJavaClassifierType reflectJavaClassifierType = this;
        ReflectJavaClassifierType reflectJavaClassifierType2 = this;
        boolean bl = false;
        Type type3 = type2 = reflectJavaClassifierType.getReflectType();
        if (type3 instanceof Class) {
            javaClassifier = new ReflectJavaClass((Class)type2);
        } else if (type3 instanceof TypeVariable) {
            javaClassifier = new ReflectJavaTypeParameter((TypeVariable)type2);
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type2).getRawType();
            Intrinsics.checkNotNull((Object)type4);
            javaClassifier = new ReflectJavaClass((Class)type4);
        } else {
            throw new IllegalStateException("Not a classifier type (" + type2.getClass() + "): " + type2);
        }
        JavaClassifier javaClassifier2 = javaClassifier;
        reflectJavaClassifierType2.classifier = javaClassifier2;
    }

    @Override
    public Type getReflectType() {
        return this.reflectType;
    }

    @Override
    public JavaClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public String getClassifierQualifiedName() {
        throw new UnsupportedOperationException("Type not found: " + this.getReflectType());
    }

    @Override
    public String getPresentableText() {
        return this.getReflectType().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRaw() {
        Type type = this.getReflectType();
        boolean bl = false;
        if (!(type instanceof Class)) return false;
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)type).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
        if (((Object[])typeVariableArray).length != 0) return true;
        return false;
    }

    @Override
    public List<JavaType> getTypeArguments() {
        Iterable iterable = ReflectClassUtilKt.getParameterizedTypeArguments(this.getReflectType());
        ReflectJavaType.Factory factory = ReflectJavaType.Factory;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Type type = (Type)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(factory.create(type));
        }
        return (List)collection;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    public JavaAnnotation findAnnotation(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }
}

