/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMember;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;

public final class ReflectJavaMethod
extends ReflectJavaMember
implements JavaMethod {
    private final Method member;

    public ReflectJavaMethod(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"");
        this.member = method;
    }

    @Override
    public Method getMember() {
        return this.member;
    }

    @Override
    public List<JavaValueParameter> getValueParameters() {
        Type[] typeArray = this.getMember().getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        Annotation[][] annotationArray = this.getMember().getParameterAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
        return this.getValueParameters(typeArray, annotationArray, this.getMember().isVarArgs());
    }

    @Override
    public ReflectJavaType getReturnType() {
        Type type = this.getMember().getGenericReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"");
        return ReflectJavaType.Factory.create(type);
    }

    @Override
    public JavaAnnotationArgument getAnnotationParameterDefaultValue() {
        ReflectJavaAnnotationArgument reflectJavaAnnotationArgument;
        Object object = this.getMember().getDefaultValue();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            reflectJavaAnnotationArgument = ReflectJavaAnnotationArgument.Factory.create(object2, null);
        } else {
            reflectJavaAnnotationArgument = null;
        }
        return reflectJavaAnnotationArgument;
    }

    public List<ReflectJavaTypeParameter> getTypeParameters() {
        TypeVariable<Method>[] typeVariableArray = this.getMember().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
        Object[] objectArray = typeVariableArray;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList(objectArray.length);
        boolean bl2 = false;
        for (Object object : objectArray2) {
            TypeVariable typeVariable = (TypeVariable)object;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new ReflectJavaTypeParameter(typeVariable));
        }
        return (List)collection;
    }

    @Override
    public boolean getHasAnnotationParameterDefaultValue() {
        return this.getAnnotationParameterDefaultValue() != null;
    }
}

