/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Arrays;
import java.util.Set;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public interface JavaClassFinder {
    public JavaClass findClass(Request var1);

    public JavaPackage findPackage(FqName var1, boolean var2);

    public Set<String> knownClassNamesInPackage(FqName var1);

    public static final class Request {
        private final ClassId classId;
        private final byte[] previouslyFoundClassFileContent;
        private final JavaClass outerClass;

        public Request(ClassId classId, byte[] byArray, JavaClass javaClass) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            this.classId = classId;
            this.previouslyFoundClassFileContent = byArray;
            this.outerClass = javaClass;
        }

        public /* synthetic */ Request(ClassId classId, byte[] byArray, JavaClass javaClass, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                byArray = null;
            }
            if ((n & 4) != 0) {
                javaClass = null;
            }
            this(classId, byArray, javaClass);
        }

        public final ClassId getClassId() {
            return this.classId;
        }

        public String toString() {
            return "Request(classId=" + this.classId + ", previouslyFoundClassFileContent=" + Arrays.toString(this.previouslyFoundClassFileContent) + ", outerClass=" + this.outerClass + ')';
        }

        public int hashCode() {
            int n = this.classId.hashCode();
            n = n * 31 + (this.previouslyFoundClassFileContent == null ? 0 : Arrays.hashCode(this.previouslyFoundClassFileContent));
            n = n * 31 + (this.outerClass == null ? 0 : this.outerClass.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Request)) {
                return false;
            }
            Request request = (Request)object;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)request.classId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previouslyFoundClassFileContent, (Object)request.previouslyFoundClassFileContent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outerClass, (Object)request.outerClass);
        }
    }
}

