/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class DeserializedDescriptorResolver {
    public static final Companion Companion = new Companion(null);
    public DeserializationComponents components;
    private static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = SetsKt.setOf((Object)((Object)KotlinClassHeader.Kind.CLASS));
    private static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
    private static final JvmMetadataVersion KOTLIN_1_1_EAP_METADATA_VERSION;
    private static final JvmMetadataVersion KOTLIN_1_3_M1_METADATA_VERSION;
    private static final JvmMetadataVersion KOTLIN_1_3_RC_METADATA_VERSION;

    public final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    public final void setComponents(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        this.components = deserializationComponents;
    }

    private final JvmMetadataVersion getOwnMetadataVersion() {
        return DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.getComponents().getConfiguration());
    }

    public final void setComponents(DeserializationComponentsForJava deserializationComponentsForJava) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponentsForJava, (String)"");
        this.setComponents(deserializationComponentsForJava.getComponents());
    }

    private final boolean getSkipMetadataVersionCheck() {
        return this.getComponents().getConfiguration().getSkipMetadataVersionCheck();
    }

    public final ClassDescriptor resolveClass(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        ClassData classData = this.readClassData$descriptors_jvm(kotlinJvmBinaryClass);
        if (classData == null) {
            return null;
        }
        ClassData classData2 = classData;
        return this.getComponents().getClassDeserializer().deserializeClass(kotlinJvmBinaryClass.getClassId(), classData2);
    }

    public final ClassData readClassData$descriptors_jvm(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Pair<JvmNameResolver, ProtoBuf.Class> pair;
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        String[] stringArray = this.readData(kotlinJvmBinaryClass, KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        String[] stringArray3 = kotlinJvmBinaryClass.getClassHeader().getStrings();
        if (stringArray3 == null) {
            return null;
        }
        String[] stringArray4 = stringArray3;
        Object object = this;
        boolean bl = false;
        try {
            try {
                boolean bl2 = false;
                pair = JvmProtoBufUtil.readClassDataFrom(stringArray2, stringArray4);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalStateException("Could not read data from " + kotlinJvmBinaryClass.getLocation(), invalidProtocolBufferException);
            }
        }
        catch (Throwable throwable) {
            if (((DeserializedDescriptorResolver)object).getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(((DeserializedDescriptorResolver)object).getOwnMetadataVersion())) {
                throw throwable;
            }
            pair = null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair2 = pair;
        if (pair2 == null) {
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair3 = pair2;
        JvmNameResolver jvmNameResolver = (JvmNameResolver)pair3.component1();
        object = (ProtoBuf.Class)pair3.component2();
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass, this.getIncompatibility(kotlinJvmBinaryClass), this.isPreReleaseInvisible(kotlinJvmBinaryClass), this.getAbiStability(kotlinJvmBinaryClass));
        return new ClassData(jvmNameResolver, (ProtoBuf.Class)object, kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), kotlinJvmBinarySourceElement);
    }

    public final MemberScope createKotlinPackagePartScope(PackageFragmentDescriptor packageFragmentDescriptor, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Pair<JvmNameResolver, ProtoBuf.Package> pair;
        Intrinsics.checkNotNullParameter((Object)packageFragmentDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        String[] stringArray = this.readData(kotlinJvmBinaryClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        String[] stringArray3 = kotlinJvmBinaryClass.getClassHeader().getStrings();
        if (stringArray3 == null) {
            return null;
        }
        String[] stringArray4 = stringArray3;
        Object object = this;
        boolean bl = false;
        try {
            try {
                boolean bl2 = false;
                pair = JvmProtoBufUtil.readPackageDataFrom(stringArray2, stringArray4);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw new IllegalStateException("Could not read data from " + kotlinJvmBinaryClass.getLocation(), invalidProtocolBufferException);
            }
        }
        catch (Throwable throwable) {
            if (((DeserializedDescriptorResolver)object).getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(((DeserializedDescriptorResolver)object).getOwnMetadataVersion())) {
                throw throwable;
            }
            pair = null;
        }
        Pair<JvmNameResolver, ProtoBuf.Package> pair2 = pair;
        if (pair2 == null) {
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Package> pair3 = pair2;
        JvmNameResolver jvmNameResolver = (JvmNameResolver)pair3.component1();
        object = (ProtoBuf.Package)pair3.component2();
        JvmPackagePartSource jvmPackagePartSource = new JvmPackagePartSource(kotlinJvmBinaryClass, (ProtoBuf.Package)object, jvmNameResolver, this.getIncompatibility(kotlinJvmBinaryClass), this.isPreReleaseInvisible(kotlinJvmBinaryClass), this.getAbiStability(kotlinJvmBinaryClass));
        return new DeserializedPackageMemberScope(packageFragmentDescriptor, (ProtoBuf.Package)object, jvmNameResolver, kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), jvmPackagePartSource, this.getComponents(), "scope for " + jvmPackagePartSource + " in " + packageFragmentDescriptor, DeserializedDescriptorResolver$$Lambda$0.INSTANCE);
    }

    private final IncompatibleVersionErrorData<JvmMetadataVersion> getIncompatibility(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        if (this.getSkipMetadataVersionCheck() || kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isCompatible(this.getOwnMetadataVersion())) {
            return null;
        }
        return new IncompatibleVersionErrorData<JvmMetadataVersion>(kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), JvmMetadataVersion.INSTANCE, this.getOwnMetadataVersion(), this.getOwnMetadataVersion().lastSupportedVersionWithThisLanguageVersion(kotlinJvmBinaryClass.getClassHeader().getMetadataVersion().isStrictSemantics()), kotlinJvmBinaryClass.getLocation(), kotlinJvmBinaryClass.getClassId());
    }

    private final boolean isPreReleaseInvisible(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        return this.getComponents().getConfiguration().getReportErrorsOnPreReleaseDependencies() && (kotlinJvmBinaryClass.getClassHeader().isPreRelease() || Intrinsics.areEqual((Object)kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (Object)KOTLIN_1_1_EAP_METADATA_VERSION)) || this.isCompiledWith13M1(kotlinJvmBinaryClass);
    }

    private final boolean isCompiledWith13M1(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        return !this.getComponents().getConfiguration().getSkipPrereleaseCheck() && kotlinJvmBinaryClass.getClassHeader().isPreRelease() && Intrinsics.areEqual((Object)kotlinJvmBinaryClass.getClassHeader().getMetadataVersion(), (Object)KOTLIN_1_3_M1_METADATA_VERSION);
    }

    private final DeserializedContainerAbiStability getAbiStability(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        return this.getComponents().getConfiguration().getAllowUnstableDependencies() ? DeserializedContainerAbiStability.STABLE : (kotlinJvmBinaryClass.getClassHeader().isUnstableJvmIrBinary() ? DeserializedContainerAbiStability.UNSTABLE : DeserializedContainerAbiStability.STABLE);
    }

    private final String[] readData(KotlinJvmBinaryClass kotlinJvmBinaryClass, Set<? extends KotlinClassHeader.Kind> set) {
        Object object;
        KotlinClassHeader kotlinClassHeader = kotlinJvmBinaryClass.getClassHeader();
        String[] stringArray = kotlinClassHeader.getData();
        if (stringArray == null) {
            stringArray = kotlinClassHeader.getIncompatibleData();
        }
        if (stringArray != null) {
            String[] stringArray2;
            String[] stringArray3 = stringArray2 = stringArray;
            boolean bl = false;
            object = set.contains((Object)kotlinClassHeader.getKind()) ? stringArray2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final Collection createKotlinPackagePartScope$lambda$2() {
        return CollectionsKt.emptyList();
    }

    static {
        Object[] objectArray = new KotlinClassHeader.Kind[]{KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART};
        KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf((Object[])objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)2;
        KOTLIN_1_1_EAP_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)11;
        KOTLIN_1_3_M1_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)13;
        KOTLIN_1_3_RC_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
    }

    static /* synthetic */ Collection accessor$DeserializedDescriptorResolver$lambda0() {
        return DeserializedDescriptorResolver.createKotlinPackagePartScope$lambda$2();
    }

    public static final class Companion {
        private Companion() {
        }

        public final JvmMetadataVersion getKOTLIN_1_3_RC_METADATA_VERSION$descriptors_jvm() {
            return KOTLIN_1_3_RC_METADATA_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

