/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    public JvmType boxType(JvmType jvmType) {
        JvmType jvmType2;
        Intrinsics.checkNotNullParameter((Object)jvmType, (String)"");
        if (jvmType instanceof JvmType.Primitive && ((JvmType.Primitive)jvmType).getJvmPrimitiveType() != null) {
            String string = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)jvmType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            jvmType2 = this.createObjectType(string);
        } else {
            jvmType2 = jvmType;
        }
        return jvmType2;
    }

    @Override
    public JvmType createFromString(String string) {
        JvmType jvmType;
        JvmPrimitiveType jvmPrimitiveType;
        int n;
        boolean bl;
        char c;
        block8: {
            JvmPrimitiveType jvmPrimitiveType2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            char c2 = c = ((CharSequence)string).length() > 0 ? (char)'\u0001' : '\u0000';
            if (_Assertions.ENABLED && c == '\u0000') {
                boolean bl2 = false;
                String string2 = "empty string as JvmType";
                throw new AssertionError((Object)string2);
            }
            c = string.charAt(0);
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            bl = false;
            int n2 = jvmPrimitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                JvmPrimitiveType jvmPrimitiveType3;
                JvmPrimitiveType jvmPrimitiveType4 = jvmPrimitiveType3 = jvmPrimitiveTypeArray[n];
                boolean bl3 = false;
                if (!(jvmPrimitiveType4.getDesc().charAt(0) == c)) continue;
                jvmPrimitiveType2 = jvmPrimitiveType3;
                break block8;
            }
            jvmPrimitiveType2 = jvmPrimitiveType = null;
        }
        if (jvmPrimitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType5 = jvmPrimitiveType;
            n = 0;
            return new JvmType.Primitive(jvmPrimitiveType5);
        }
        switch (c) {
            case 'V': {
                jvmType = new JvmType.Primitive(null);
                break;
            }
            case '[': {
                String string3 = string.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                jvmType = new JvmType.Array(this.createFromString(string3));
                break;
            }
            default: {
                boolean bl4;
                boolean bl5 = bl4 = c == 'L' && StringsKt.endsWith$default((CharSequence)string, (char)';', (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl4) {
                    bl = false;
                    String string4 = "Type that is not primitive nor array should be Object, but '" + string + "' was found";
                    throw new AssertionError((Object)string4);
                }
                String string5 = string.substring(1, string.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                jvmType = new JvmType.Object(string5);
            }
        }
        return jvmType;
    }

    @Override
    public JvmType createPrimitiveType(PrimitiveType primitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                jvmType = JvmType.Companion.getBOOLEAN$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 8: {
                jvmType = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jvmType;
    }

    @Override
    public JvmType.Object createObjectType(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new JvmType.Object(string);
    }

    @Override
    public String toString(JvmType jvmType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jvmType, (String)"");
        JvmType jvmType2 = jvmType;
        if (jvmType2 instanceof JvmType.Array) {
            object = '[' + this.toString(((JvmType.Array)jvmType).getElementType());
        } else if (jvmType2 instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)jvmType).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType2 instanceof JvmType.Object) {
            object = 'L' + ((JvmType.Object)jvmType).getInternalName() + ';';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

