/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;

public final class MemberSignature {
    public static final Companion Companion = new Companion(null);
    private final String signature;

    private MemberSignature(String string) {
        this.signature = string;
    }

    public final String getSignature() {
        return this.signature;
    }

    public String toString() {
        return "MemberSignature(signature=" + this.signature + ')';
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MemberSignature)) {
            return false;
        }
        MemberSignature memberSignature = (MemberSignature)object;
        return Intrinsics.areEqual((Object)this.signature, (Object)memberSignature.signature);
    }

    public /* synthetic */ MemberSignature(String string, DefaultConstructorMarker defaultConstructorMarker) {
        this(string);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final MemberSignature fromMethod(NameResolver nameResolver, JvmProtoBuf.JvmMethodSignature jvmMethodSignature) {
            Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
            Intrinsics.checkNotNullParameter((Object)jvmMethodSignature, (String)"");
            return this.fromMethodNameAndDesc(nameResolver.getString(jvmMethodSignature.getName()), nameResolver.getString(jvmMethodSignature.getDesc()));
        }

        @JvmStatic
        public final MemberSignature fromMethodNameAndDesc(String string, String string2) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"");
            return new MemberSignature(string + string2, null);
        }

        @JvmStatic
        public final MemberSignature fromFieldNameAndDesc(String string, String string2) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"");
            return new MemberSignature(string + '#' + string2, null);
        }

        @JvmStatic
        public final MemberSignature fromJvmMemberSignature(JvmMemberSignature jvmMemberSignature) {
            MemberSignature memberSignature;
            Intrinsics.checkNotNullParameter((Object)jvmMemberSignature, (String)"");
            JvmMemberSignature jvmMemberSignature2 = jvmMemberSignature;
            if (jvmMemberSignature2 instanceof JvmMemberSignature.Method) {
                memberSignature = this.fromMethodNameAndDesc(((JvmMemberSignature.Method)jvmMemberSignature).getName(), ((JvmMemberSignature.Method)jvmMemberSignature).getDesc());
            } else if (jvmMemberSignature2 instanceof JvmMemberSignature.Field) {
                memberSignature = this.fromFieldNameAndDesc(((JvmMemberSignature.Field)jvmMemberSignature).getName(), ((JvmMemberSignature.Field)jvmMemberSignature).getDesc());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return memberSignature;
        }

        @JvmStatic
        public final MemberSignature fromMethodSignatureAndParameterIndex(MemberSignature memberSignature, int n) {
            Intrinsics.checkNotNullParameter((Object)memberSignature, (String)"");
            return new MemberSignature(memberSignature.getSignature() + '@' + n, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

