/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DescriptorBasedTypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureBuildingUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class MethodSignatureMappingKt {
    public static final String computeJvmDescriptor(FunctionDescriptor functionDescriptor, boolean bl, boolean bl2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        if (bl2) {
            String string;
            if (functionDescriptor instanceof ConstructorDescriptor) {
                string = "<init>";
            } else {
                String string2 = functionDescriptor.getName().asString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            }
            stringBuilder2.append(string);
        }
        stringBuilder2.append("(");
        ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor != null) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            boolean bl4 = false;
            KotlinType kotlinType = receiverParameterDescriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            MethodSignatureMappingKt.appendErasedType(stringBuilder2, kotlinType);
        }
        for (ValueParameterDescriptor valueParameterDescriptor : functionDescriptor.getValueParameters()) {
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            MethodSignatureMappingKt.appendErasedType(stringBuilder2, kotlinType);
        }
        stringBuilder2.append(")");
        if (bl) {
            if (DescriptorBasedTypeSignatureMappingKt.hasVoidReturnType(functionDescriptor)) {
                stringBuilder2.append("V");
            } else {
                KotlinType kotlinType = functionDescriptor.getReturnType();
                Intrinsics.checkNotNull((Object)kotlinType);
                MethodSignatureMappingKt.appendErasedType(stringBuilder2, kotlinType);
            }
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl, bl2);
    }

    public static final boolean forceSingleValueParameterBoxing(CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((FunctionDescriptor)callableDescriptor).getName().asString(), (Object)"remove") || ((FunctionDescriptor)callableDescriptor).getValueParameters().size() != 1 || SpecialBuiltinMembers.isFromJavaOrBuiltins((CallableMemberDescriptor)callableDescriptor)) {
            return false;
        }
        List<ValueParameterDescriptor> list = ((FunctionDescriptor)callableDescriptor).getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        KotlinType kotlinType = ((ValueParameterDescriptor)CollectionsKt.single(list)).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        JvmType jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
        JvmType.Primitive primitive = jvmType instanceof JvmType.Primitive ? (JvmType.Primitive)jvmType : null;
        if ((primitive != null ? primitive.getJvmPrimitiveType() : null) != JvmPrimitiveType.INT) {
            return false;
        }
        FunctionDescriptor functionDescriptor = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)callableDescriptor);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<ValueParameterDescriptor> list2 = functionDescriptor2.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"");
        KotlinType kotlinType2 = ((ValueParameterDescriptor)CollectionsKt.single(list2)).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType2);
        DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor), (Object)StandardNames.FqNames.mutableCollection.toUnsafe()) && jvmType instanceof JvmType.Object && Intrinsics.areEqual((Object)((JvmType.Object)jvmType).getInternalName(), (Object)"java/lang/Object");
    }

    public static final String computeJvmSignature(CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        boolean bl = false;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        boolean bl2 = false;
        if (DescriptorUtils.isLocal(callableDescriptor)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getName().isSpecial()) {
            return null;
        }
        declarationDescriptor = callableDescriptor.getOriginal();
        SimpleFunctionDescriptor simpleFunctionDescriptor = declarationDescriptor instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)declarationDescriptor : null;
        if (simpleFunctionDescriptor == null) {
            return null;
        }
        return MethodSignatureBuildingUtilsKt.signature(signatureBuildingComponents, classDescriptor2, MethodSignatureMappingKt.computeJvmDescriptor$default(simpleFunctionDescriptor, false, false, 3, null));
    }

    public static final String getInternalName(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameSafe(classDescriptor).toUnsafe());
        if (classId != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            String string = JvmClassName.internalNameByClassId(classId2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return string;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName$default(classDescriptor, null, 2, null);
    }

    private static final void appendErasedType(StringBuilder stringBuilder, KotlinType kotlinType) {
        stringBuilder.append(MethodSignatureMappingKt.mapToJvmType(kotlinType));
    }

    public static final JvmType mapToJvmType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return (JvmType)DescriptorBasedTypeSignatureMappingKt.mapType$default(kotlinType, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

