/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;

public class Flags {
    public static final BooleanFlagField SUSPEND_TYPE = FlagField.booleanFirst();
    public static final BooleanFlagField DEFINITELY_NOT_NULL_TYPE = FlagField.booleanAfter(SUSPEND_TYPE);
    public static final BooleanFlagField HAS_ANNOTATIONS = FlagField.booleanFirst();
    public static final FlagField<ProtoBuf.Visibility> VISIBILITY = FlagField.after((FlagField)HAS_ANNOTATIONS, (Internal.EnumLite[])ProtoBuf.Visibility.values());
    public static final FlagField<ProtoBuf.Modality> MODALITY = FlagField.after(VISIBILITY, (Internal.EnumLite[])ProtoBuf.Modality.values());
    public static final FlagField<ProtoBuf.Class.Kind> CLASS_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.Class.Kind.values());
    public static final BooleanFlagField IS_INNER = FlagField.booleanAfter(CLASS_KIND);
    public static final BooleanFlagField IS_DATA = FlagField.booleanAfter(IS_INNER);
    public static final BooleanFlagField IS_EXTERNAL_CLASS = FlagField.booleanAfter(IS_DATA);
    public static final BooleanFlagField IS_EXPECT_CLASS = FlagField.booleanAfter(IS_EXTERNAL_CLASS);
    public static final BooleanFlagField IS_VALUE_CLASS = FlagField.booleanAfter(IS_EXPECT_CLASS);
    public static final BooleanFlagField IS_FUN_INTERFACE = FlagField.booleanAfter(IS_VALUE_CLASS);
    public static final BooleanFlagField HAS_ENUM_ENTRIES = FlagField.booleanAfter(IS_FUN_INTERFACE);
    public static final BooleanFlagField IS_SECONDARY = FlagField.booleanAfter(VISIBILITY);
    public static final BooleanFlagField IS_CONSTRUCTOR_WITH_NON_STABLE_PARAMETER_NAMES = FlagField.booleanAfter(IS_SECONDARY);
    public static final FlagField<ProtoBuf.MemberKind> MEMBER_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.MemberKind.values());
    public static final BooleanFlagField IS_OPERATOR = FlagField.booleanAfter(MEMBER_KIND);
    public static final BooleanFlagField IS_INFIX = FlagField.booleanAfter(IS_OPERATOR);
    public static final BooleanFlagField IS_INLINE = FlagField.booleanAfter(IS_INFIX);
    public static final BooleanFlagField IS_TAILREC = FlagField.booleanAfter(IS_INLINE);
    public static final BooleanFlagField IS_EXTERNAL_FUNCTION = FlagField.booleanAfter(IS_TAILREC);
    public static final BooleanFlagField IS_SUSPEND = FlagField.booleanAfter(IS_EXTERNAL_FUNCTION);
    public static final BooleanFlagField IS_EXPECT_FUNCTION = FlagField.booleanAfter(IS_SUSPEND);
    public static final BooleanFlagField IS_FUNCTION_WITH_NON_STABLE_PARAMETER_NAMES = FlagField.booleanAfter(IS_EXPECT_FUNCTION);
    public static final BooleanFlagField IS_VAR = FlagField.booleanAfter(MEMBER_KIND);
    public static final BooleanFlagField HAS_GETTER = FlagField.booleanAfter(IS_VAR);
    public static final BooleanFlagField HAS_SETTER = FlagField.booleanAfter(HAS_GETTER);
    public static final BooleanFlagField IS_CONST = FlagField.booleanAfter(HAS_SETTER);
    public static final BooleanFlagField IS_LATEINIT = FlagField.booleanAfter(IS_CONST);
    public static final BooleanFlagField HAS_CONSTANT = FlagField.booleanAfter(IS_LATEINIT);
    public static final BooleanFlagField IS_EXTERNAL_PROPERTY = FlagField.booleanAfter(HAS_CONSTANT);
    public static final BooleanFlagField IS_DELEGATED = FlagField.booleanAfter(IS_EXTERNAL_PROPERTY);
    public static final BooleanFlagField IS_EXPECT_PROPERTY = FlagField.booleanAfter(IS_DELEGATED);
    public static final BooleanFlagField DECLARES_DEFAULT_VALUE = FlagField.booleanAfter(HAS_ANNOTATIONS);
    public static final BooleanFlagField IS_CROSSINLINE = FlagField.booleanAfter(DECLARES_DEFAULT_VALUE);
    public static final BooleanFlagField IS_NOINLINE = FlagField.booleanAfter(IS_CROSSINLINE);
    public static final BooleanFlagField IS_NOT_DEFAULT = FlagField.booleanAfter(MODALITY);
    public static final BooleanFlagField IS_EXTERNAL_ACCESSOR = FlagField.booleanAfter(IS_NOT_DEFAULT);
    public static final BooleanFlagField IS_INLINE_ACCESSOR = FlagField.booleanAfter(IS_EXTERNAL_ACCESSOR);
    public static final BooleanFlagField IS_NEGATED = FlagField.booleanFirst();
    public static final BooleanFlagField IS_NULL_CHECK_PREDICATE = FlagField.booleanAfter(IS_NEGATED);
    public static final BooleanFlagField IS_UNSIGNED = FlagField.booleanFirst();

    public static int getAccessorFlags(boolean bl, ProtoBuf.Visibility visibility, ProtoBuf.Modality modality, boolean bl2, boolean bl3, boolean bl4) {
        if (visibility == null) {
            Flags.$$$reportNull$$$0(10);
        }
        if (modality == null) {
            Flags.$$$reportNull$$$0(11);
        }
        return HAS_ANNOTATIONS.toFlags(bl) | MODALITY.toFlags(modality) | VISIBILITY.toFlags(visibility) | IS_NOT_DEFAULT.toFlags(bl2) | IS_EXTERNAL_ACCESSOR.toFlags(bl3) | IS_INLINE_ACCESSOR.toFlags(bl4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberKind";
                break;
            }
        }
        objectArray2[1] = "kotlin/reflect/jvm/internal/impl/metadata/deserialization/Flags";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassFlags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructorFlags";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionFlags";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyFlags";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessorFlags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EnumLiteFlagField<E extends Internal.EnumLite>
    extends FlagField<E> {
        private final E[] values;

        public EnumLiteFlagField(int n, E[] EArray) {
            super(n, EnumLiteFlagField.bitWidth(EArray));
            this.values = EArray;
        }

        private static <E> int bitWidth(E[] EArray) {
            int n;
            if (EArray == null) {
                EnumLiteFlagField.$$$reportNull$$$0(0);
            }
            if ((n = EArray.length - 1) == 0) {
                return 1;
            }
            for (int i = 31; i >= 0; --i) {
                if ((n & 1 << i) == 0) continue;
                return i + 1;
            }
            throw new IllegalStateException("Empty enum: " + EArray.getClass());
        }

        @Override
        public E get(int n) {
            int n2 = (1 << this.bitWidth) - 1;
            int n3 = n2 << this.offset;
            int n4 = (n & n3) >> this.offset;
            for (E e : this.values) {
                if (e.getNumber() != n4) continue;
                return e;
            }
            return null;
        }

        @Override
        public int toFlags(E e) {
            return e.getNumber() << this.offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntries", "kotlin/reflect/jvm/internal/impl/metadata/deserialization/Flags$EnumLiteFlagField", "bitWidth"));
        }
    }

    public static class BooleanFlagField
    extends FlagField<Boolean> {
        public BooleanFlagField(int n) {
            super(n, 1);
        }

        @Override
        public Boolean get(int n) {
            Boolean bl = (n & 1 << this.offset) != 0;
            if (bl == null) {
                BooleanFlagField.$$$reportNull$$$0(0);
            }
            return bl;
        }

        @Override
        public int toFlags(Boolean bl) {
            return bl != false ? 1 << this.offset : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/metadata/deserialization/Flags$BooleanFlagField", "get"));
        }
    }

    public static abstract class FlagField<E> {
        public final int offset;
        public final int bitWidth;

        public static <E extends Internal.EnumLite> FlagField<E> after(FlagField<?> flagField, E[] EArray) {
            int n = flagField.offset + flagField.bitWidth;
            return new EnumLiteFlagField(n, EArray);
        }

        public static BooleanFlagField booleanFirst() {
            return new BooleanFlagField(0);
        }

        public static BooleanFlagField booleanAfter(FlagField<?> flagField) {
            int n = flagField.offset + flagField.bitWidth;
            return new BooleanFlagField(n);
        }

        private FlagField(int n, int n2) {
            this.offset = n;
            this.bitWidth = n2;
        }

        public abstract E get(int var1);

        public abstract int toFlags(E var1);
    }
}

