/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.util.Arrays;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;

public final class JvmMetadataVersion
extends BinaryVersion {
    public static final Companion Companion = new Companion(null);
    private final boolean isStrictSemantics;
    public static final JvmMetadataVersion INSTANCE;
    public static final JvmMetadataVersion INSTANCE_NEXT;
    public static final JvmMetadataVersion INVALID_VERSION;

    public JvmMetadataVersion(int[] nArray, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        super(Arrays.copyOf(nArray, nArray.length));
        this.isStrictSemantics = bl;
    }

    public final boolean isStrictSemantics() {
        return this.isStrictSemantics;
    }

    public JvmMetadataVersion(int ... nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this(nArray, false);
    }

    public final JvmMetadataVersion lastSupportedVersionWithThisLanguageVersion(boolean bl) {
        JvmMetadataVersion jvmMetadataVersion = bl ? INSTANCE : INSTANCE_NEXT;
        return jvmMetadataVersion.newerThan(this) ? jvmMetadataVersion : this;
    }

    public final boolean isCompatible(JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        if (this.getMajor() == 2 && this.getMinor() == 0 && INSTANCE.getMajor() == 1 && INSTANCE.getMinor() == 8) {
            return true;
        }
        JvmMetadataVersion jvmMetadataVersion2 = jvmMetadataVersion.lastSupportedVersionWithThisLanguageVersion(this.isStrictSemantics);
        return this.isCompatibleInternal(jvmMetadataVersion2);
    }

    private final boolean isCompatibleInternal(JvmMetadataVersion jvmMetadataVersion) {
        if (this.getMajor() == 1 && this.getMinor() == 0) {
            return false;
        }
        if (this.getMajor() == 0) {
            return false;
        }
        return !this.newerThan(jvmMetadataVersion);
    }

    public final JvmMetadataVersion next() {
        JvmMetadataVersion jvmMetadataVersion;
        if (this.getMajor() == 1 && this.getMinor() == 9) {
            int[] nArray = new int[]{2, 0, 0};
            JvmMetadataVersion jvmMetadataVersion2 = new JvmMetadataVersion(nArray);
            jvmMetadataVersion = jvmMetadataVersion2;
        } else {
            int[] nArray = new int[]{this.getMajor(), this.getMinor() + 1, 0};
            JvmMetadataVersion jvmMetadataVersion3 = new JvmMetadataVersion(nArray);
            jvmMetadataVersion = jvmMetadataVersion3;
        }
        return jvmMetadataVersion;
    }

    private final boolean newerThan(JvmMetadataVersion jvmMetadataVersion) {
        return this.getMajor() > jvmMetadataVersion.getMajor() ? true : (this.getMajor() < jvmMetadataVersion.getMajor() ? false : this.getMinor() > jvmMetadataVersion.getMinor());
    }

    static {
        int[] nArray = new int[]{2, 1, 0};
        INSTANCE = new JvmMetadataVersion(nArray);
        INSTANCE_NEXT = INSTANCE.next();
        INVALID_VERSION = new JvmMetadataVersion(new int[0]);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

