/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmFlags;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;

public final class JvmProtoBufUtil {
    public static final JvmProtoBufUtil INSTANCE;
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;

    private JvmProtoBufUtil() {
    }

    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return JvmProtoBufUtil.readClassDataFrom(byArray, stringArray2);
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(byte[] byArray, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new Pair((Object)INSTANCE.readNameResolver(byteArrayInputStream, stringArray), (Object)ProtoBuf.Class.parseFrom(byteArrayInputStream, EXTENSION_REGISTRY));
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, stringArray2);
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(byte[] byArray, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new Pair((Object)INSTANCE.readNameResolver(byteArrayInputStream, stringArray), (Object)ProtoBuf.Package.parseFrom(byteArrayInputStream, EXTENSION_REGISTRY));
    }

    @JvmStatic
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray2, (String)"");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BitEncoding.decodeBytes(stringArray));
        return new Pair((Object)INSTANCE.readNameResolver(byteArrayInputStream, stringArray2), (Object)ProtoBuf.Function.parseFrom(byteArrayInputStream, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(InputStream inputStream, String[] stringArray) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(inputStream, EXTENSION_REGISTRY);
        Intrinsics.checkNotNullExpressionValue((Object)stringTableTypes, (String)"");
        return new JvmNameResolver(stringTableTypes, stringArray);
    }

    public final JvmMemberSignature.Method getJvmMethodSignature(ProtoBuf.Function function, NameResolver nameResolver, TypeTable typeTable) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)function, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = function;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n2 = n = jvmMethodSignature != null && jvmMethodSignature.hasName() ? jvmMethodSignature.getName() : function.getName();
        if (jvmMethodSignature != null && jvmMethodSignature.hasDesc()) {
            string = nameResolver.getString(jvmMethodSignature.getDesc());
        } else {
            Collection collection = CollectionsKt.listOfNotNull((Object)ProtoTypeTableUtilKt.receiverType(function, typeTable));
            List<ProtoBuf.ValueParameter> list = function.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Iterable iterable = list;
            Collection collection2 = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object object : iterable2) {
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)object;
                Collection collection3 = iterable3;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)valueParameter);
                collection3.add(ProtoTypeTableUtilKt.type(valueParameter, typeTable));
            }
            List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)iterable3));
            Object object = list2;
            boolean bl4 = false;
            iterable3 = object;
            Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl5 = false;
            for (ProtoBuf.ValueParameter valueParameter : iterable3) {
                ProtoBuf.Type type = (ProtoBuf.Type)((Object)valueParameter);
                collection2 = collection4;
                boolean bl6 = false;
                String string2 = INSTANCE.mapTypeDefault(type, nameResolver);
                if (string2 == null) {
                    return null;
                }
                collection2.add(string2);
            }
            iterable = (List)collection4;
            String string3 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(function, typeTable), nameResolver);
            if (string3 == null) {
                return null;
            }
            object = string3;
            string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)"", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null) + (String)object;
        }
        String string4 = string;
        return new JvmMemberSignature.Method(nameResolver.getString(n), string4);
    }

    public final JvmMemberSignature.Method getJvmConstructorSignature(ProtoBuf.Constructor constructor, NameResolver nameResolver, TypeTable typeTable) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = constructor;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        String string3 = string2 = jvmMethodSignature != null && jvmMethodSignature.hasName() ? nameResolver.getString(jvmMethodSignature.getName()) : "<init>";
        if (jvmMethodSignature != null && jvmMethodSignature.hasDesc()) {
            string = nameResolver.getString(jvmMethodSignature.getDesc());
        } else {
            List<ProtoBuf.ValueParameter> list = constructor.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)valueParameter);
                String string4 = INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type(valueParameter, typeTable), nameResolver);
                if (string4 == null) {
                    return null;
                }
                collection2.add(string4);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"", (CharSequence)"(", (CharSequence)")V", (int)0, null, null, (int)56, null);
        }
        String string5 = string;
        return new JvmMemberSignature.Method(string2, string5);
    }

    public final JvmMemberSignature.Field getJvmFieldSignature(ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl) {
        String string;
        int n;
        JvmProtoBuf.JvmFieldSignature jvmFieldSignature;
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        GeneratedMessageLite.ExtendableMessage extendableMessage = property;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature2 = jvmPropertySignature;
        JvmProtoBuf.JvmFieldSignature jvmFieldSignature2 = jvmFieldSignature = jvmPropertySignature2.hasField() ? jvmPropertySignature2.getField() : null;
        if (jvmFieldSignature == null && bl) {
            return null;
        }
        int n2 = n = jvmFieldSignature != null && jvmFieldSignature.hasName() ? jvmFieldSignature.getName() : property.getName();
        if (jvmFieldSignature != null && jvmFieldSignature.hasDesc()) {
            string = nameResolver.getString(jvmFieldSignature.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(property, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String string2 = string;
        return new JvmMemberSignature.Field(nameResolver.getString(n), string2);
    }

    public static /* synthetic */ JvmMemberSignature.Field getJvmFieldSignature$default(JvmProtoBufUtil jvmProtoBufUtil, ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return jvmProtoBufUtil.getJvmFieldSignature(property, nameResolver, typeTable, bl);
    }

    private final String mapTypeDefault(ProtoBuf.Type type, NameResolver nameResolver) {
        return type.hasClassName() ? ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(type.getClassName())) : null;
    }

    @JvmStatic
    public static final boolean isMovedFromInterfaceCompanion(ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_MOVED_FROM_INTERFACE_COMPANION();
        Integer n = property.getExtension(JvmProtoBuf.flags);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"");
        Boolean bl = booleanFlagField.get(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        return bl;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        INSTANCE = new JvmProtoBufUtil();
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
        boolean bl = false;
        JvmProtoBuf.registerAllExtensions(extensionRegistryLite2);
        ExtensionRegistryLite extensionRegistryLite3 = extensionRegistryLite;
        Intrinsics.checkNotNullExpressionValue((Object)extensionRegistryLite3, (String)"");
        EXTENSION_REGISTRY = extensionRegistryLite3;
    }
}

