/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import kotlin.text.StringsKt;

public final class RenderingUtilsKt {
    public static final String render(Name name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        if (RenderingUtilsKt.shouldBeEscaped(name)) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '`';
            String string2 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2;
            string = stringBuilder.append(c + string3).append('`').toString();
        } else {
            String string4 = name.asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name name) {
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        if (KeywordStringsGenerated.KEYWORDS.contains(string2)) return true;
        CharSequence charSequence = string2;
        boolean bl = false;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = c = charSequence.charAt(i);
            boolean bl2 = false;
            if (!Character.isLetterOrDigit(c2) && c2 != '_') {
                return true;
            }
            boolean bl3 = false;
            if (!bl3) continue;
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        if (((CharSequence)string2).length() == 0) {
            return true;
        }
        boolean bl5 = false;
        if (bl5) return true;
        if (Character.isJavaIdentifierStart(string2.codePointAt(0))) return false;
        return true;
    }

    public static final String render(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return RenderingUtilsKt.renderFqName(fqNameUnsafe.pathSegments());
    }

    public static final String renderFqName(List<Name> list) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(list, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name name : list) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(RenderingUtilsKt.render(name));
        }
        return stringBuilder.toString();
    }

    public static final String replacePrefixesInTypeRepresentations(String string, String string2, String string3, String string4, String string5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"");
        if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)string3, (String)string4, (boolean)false, (int)2, null)) {
            String string6 = string.substring(string2.length());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
            String string7 = string6;
            String string8 = string3.substring(string4.length());
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"");
            String string9 = string8;
            String string10 = string5 + string7;
            if (Intrinsics.areEqual((Object)string7, (Object)string9)) {
                return string10;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(string7, string9)) {
                return string10 + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return Intrinsics.areEqual((Object)string, (Object)StringsKt.replace$default((String)string2, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)string2, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(string + '?'), (Object)string2) || Intrinsics.areEqual((Object)('(' + string + ")?"), (Object)string2);
    }
}

