/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Comparator;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorNonRoot;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public class MemberComparator
implements Comparator<DeclarationDescriptor> {
    public static final MemberComparator INSTANCE = new MemberComparator();
    private static final DescriptorRenderer RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)new Function1<DescriptorRendererOptions, Unit>(){

        public Unit invoke(DescriptorRendererOptions descriptorRendererOptions) {
            descriptorRendererOptions.setWithDefinedIn(false);
            descriptorRendererOptions.setVerbose(true);
            descriptorRendererOptions.setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy.UNLESS_EMPTY);
            descriptorRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
            return Unit.INSTANCE;
        }
    });

    private MemberComparator() {
    }

    @Override
    public int compare(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        int n;
        Object object;
        Object object2;
        DeclarationDescriptorNonRoot declarationDescriptorNonRoot;
        Integer n2 = NameAndTypeMemberComparator.compareInternal(declarationDescriptor, declarationDescriptor2);
        if (n2 != null) {
            return n2;
        }
        if (declarationDescriptor instanceof TypeAliasDescriptor && declarationDescriptor2 instanceof TypeAliasDescriptor) {
            String string;
            declarationDescriptorNonRoot = (TypeAliasDescriptor)declarationDescriptor;
            object2 = (TypeAliasDescriptor)declarationDescriptor2;
            object = RENDERER.renderType(declarationDescriptorNonRoot.getUnderlyingType());
            int n3 = ((String)object).compareTo(string = RENDERER.renderType(object2.getUnderlyingType()));
            if (n3 != 0) {
                return n3;
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && declarationDescriptor2 instanceof CallableDescriptor) {
            int n4;
            Object object3;
            Object object4;
            int n5;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            int n6;
            declarationDescriptorNonRoot = (CallableDescriptor)declarationDescriptor;
            object2 = (CallableDescriptor)declarationDescriptor2;
            object = declarationDescriptorNonRoot.getExtensionReceiverParameter();
            ReceiverParameterDescriptor receiverParameterDescriptor = object2.getExtensionReceiverParameter();
            assert (object != null == (receiverParameterDescriptor != null));
            if (object != null && (n6 = ((String)(object8 = RENDERER.renderType(object.getType()))).compareTo((String)(object7 = RENDERER.renderType(receiverParameterDescriptor.getType())))) != 0) {
                return n6;
            }
            object8 = declarationDescriptorNonRoot.getValueParameters();
            object7 = object2.getValueParameters();
            for (n6 = 0; n6 < Math.min(object8.size(), object7.size()); ++n6) {
                object6 = RENDERER.renderType(((ValueParameterDescriptor)object8.get(n6)).getType());
                n5 = ((String)object6).compareTo((String)(object5 = RENDERER.renderType(((ValueParameterDescriptor)object7.get(n6)).getType())));
                if (n5 == 0) continue;
                return n5;
            }
            n6 = object8.size() - object7.size();
            if (n6 != 0) {
                return n6;
            }
            object6 = declarationDescriptorNonRoot.getTypeParameters();
            object5 = object2.getTypeParameters();
            for (n5 = 0; n5 < Math.min(object6.size(), object5.size()); ++n5) {
                object4 = ((TypeParameterDescriptor)object6.get(n5)).getUpperBounds();
                object3 = ((TypeParameterDescriptor)object5.get(n5)).getUpperBounds();
                n4 = object4.size() - object3.size();
                if (n4 != 0) {
                    return n4;
                }
                for (int i = 0; i < object4.size(); ++i) {
                    String string;
                    String string2 = RENDERER.renderType((KotlinType)object4.get(i));
                    int n7 = string2.compareTo(string = RENDERER.renderType((KotlinType)object3.get(i)));
                    if (n7 == 0) continue;
                    return n7;
                }
            }
            n5 = object6.size() - object5.size();
            if (n5 != 0) {
                return n5;
            }
            if (declarationDescriptorNonRoot instanceof CallableMemberDescriptor && object2 instanceof CallableMemberDescriptor) {
                object4 = ((CallableMemberDescriptor)declarationDescriptorNonRoot).getKind();
                object3 = ((CallableMemberDescriptor)object2).getKind();
                n4 = ((Enum)object4).ordinal() - ((Enum)object3).ordinal();
                if (n4 != 0) {
                    return n4;
                }
            }
        } else if (declarationDescriptor instanceof ClassDescriptor && declarationDescriptor2 instanceof ClassDescriptor) {
            declarationDescriptorNonRoot = (ClassDescriptor)declarationDescriptor;
            object2 = (ClassDescriptor)declarationDescriptor2;
            if (declarationDescriptorNonRoot.getKind().ordinal() != object2.getKind().ordinal()) {
                return declarationDescriptorNonRoot.getKind().ordinal() - object2.getKind().ordinal();
            }
            if (declarationDescriptorNonRoot.isCompanionObject() != object2.isCompanionObject()) {
                return declarationDescriptorNonRoot.isCompanionObject() ? 1 : -1;
            }
        } else {
            throw new AssertionError((Object)String.format("Unsupported pair of descriptors:\n'%s' Class: %s\n%s' Class: %s", declarationDescriptor, declarationDescriptor.getClass(), declarationDescriptor2, declarationDescriptor2.getClass()));
        }
        if ((n = RENDERER.render(declarationDescriptor).compareTo(RENDERER.render(declarationDescriptor2))) != 0) {
            return n;
        }
        object2 = DescriptorUtils.getContainingModule(declarationDescriptor).getName();
        object = DescriptorUtils.getContainingModule(declarationDescriptor2).getName();
        return ((Name)object2).compareTo((Name)object);
    }

    public static class NameAndTypeMemberComparator
    implements Comparator<DeclarationDescriptor> {
        public static final NameAndTypeMemberComparator INSTANCE = new NameAndTypeMemberComparator();

        private NameAndTypeMemberComparator() {
        }

        private static int getDeclarationPriority(DeclarationDescriptor declarationDescriptor) {
            if (DescriptorUtils.isEnumEntry(declarationDescriptor)) {
                return 8;
            }
            if (declarationDescriptor instanceof ConstructorDescriptor) {
                return 7;
            }
            if (declarationDescriptor instanceof PropertyDescriptor) {
                if (((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter() == null) {
                    return 6;
                }
                return 5;
            }
            if (declarationDescriptor instanceof FunctionDescriptor) {
                if (((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter() == null) {
                    return 4;
                }
                return 3;
            }
            if (declarationDescriptor instanceof ClassDescriptor) {
                return 2;
            }
            if (declarationDescriptor instanceof TypeAliasDescriptor) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
            Integer n = NameAndTypeMemberComparator.compareInternal(declarationDescriptor, declarationDescriptor2);
            return n != null ? n : 0;
        }

        private static Integer compareInternal(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
            int n = NameAndTypeMemberComparator.getDeclarationPriority(declarationDescriptor2) - NameAndTypeMemberComparator.getDeclarationPriority(declarationDescriptor);
            if (n != 0) {
                return n;
            }
            if (DescriptorUtils.isEnumEntry(declarationDescriptor) && DescriptorUtils.isEnumEntry(declarationDescriptor2)) {
                return 0;
            }
            int n2 = declarationDescriptor.getName().compareTo(declarationDescriptor2.getName());
            if (n2 != 0) {
                return n2;
            }
            return null;
        }
    }
}

