/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class KClassValue
extends ConstantValue<Value> {
    public static final Companion Companion = new Companion(null);

    public KClassValue(Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        super(value);
    }

    public KClassValue(ClassLiteralValue classLiteralValue) {
        Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
        this(new Value.NormalClass(classLiteralValue));
    }

    public KClassValue(ClassId classId, int n) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        this(new ClassLiteralValue(classId, n));
    }

    @Override
    public KotlinType getType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        ClassDescriptor classDescriptor = moduleDescriptor.getBuiltIns().getKClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        return KotlinTypeFactory.simpleNotNullType(typeAttributes, classDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(this.getArgumentType(moduleDescriptor))));
    }

    public final KotlinType getArgumentType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Value value = (Value)this.getValue();
        if (value instanceof Value.LocalClass) {
            return ((Value.LocalClass)this.getValue()).getType();
        }
        if (value instanceof Value.NormalClass) {
            ClassLiteralValue classLiteralValue = ((Value.NormalClass)this.getValue()).getValue();
            ClassId classId = classLiteralValue.component1();
            int n = classLiteralValue.component2();
            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
            if (classDescriptor == null) {
                String[] stringArray = new String[]{classId.toString(), String.valueOf(n)};
                return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_KCLASS_CONSTANT_VALUE, stringArray);
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            KotlinType kotlinType = null;
            SimpleType simpleType = classDescriptor2.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            kotlinType = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                boolean bl = false;
                kotlinType = moduleDescriptor.getBuiltIns().getArrayType(Variance.INVARIANT, kotlinType);
            }
            return kotlinType;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final class Companion {
        private Companion() {
        }

        public final ConstantValue<?> create(KotlinType kotlinType) {
            ConstantValue constantValue;
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
            if (KotlinTypeKt.isError(kotlinType)) {
                return null;
            }
            KotlinType kotlinType2 = kotlinType;
            int n = 0;
            while (KotlinBuiltIns.isArray(kotlinType2)) {
                kotlinType2 = ((TypeProjection)CollectionsKt.single(kotlinType2.getArguments())).getType();
                ++n;
            }
            ClassifierDescriptor classifierDescriptor = kotlinType2.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof ClassDescriptor) {
                ClassId classId = DescriptorUtilsKt.getClassId(classifierDescriptor);
                if (classId == null) {
                    return new KClassValue(new Value.LocalClass(kotlinType));
                }
                ClassId classId2 = classId;
                constantValue = new KClassValue(classId2, n);
            } else {
                constantValue = classifierDescriptor instanceof TypeParameterDescriptor ? (ConstantValue)new KClassValue(ClassId.Companion.topLevel(StandardNames.FqNames.any.toSafe()), 0) : null;
            }
            return constantValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static abstract class Value {
        private Value() {
        }

        public /* synthetic */ Value(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public static final class LocalClass
        extends Value {
            private final KotlinType type;

            public LocalClass(KotlinType kotlinType) {
                Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
                super(null);
                this.type = kotlinType;
            }

            public final KotlinType getType() {
                return this.type;
            }

            public String toString() {
                return "LocalClass(type=" + this.type + ')';
            }

            public int hashCode() {
                return this.type.hashCode();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof LocalClass)) {
                    return false;
                }
                LocalClass localClass = (LocalClass)object;
                return Intrinsics.areEqual((Object)this.type, (Object)localClass.type);
            }
        }

        public static final class NormalClass
        extends Value {
            private final ClassLiteralValue value;

            public NormalClass(ClassLiteralValue classLiteralValue) {
                Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
                super(null);
                this.value = classLiteralValue;
            }

            public final ClassLiteralValue getValue() {
                return this.value;
            }

            public final ClassId getClassId() {
                return this.value.getClassId();
            }

            public final int getArrayDimensions() {
                return this.value.getArrayNestedness();
            }

            public String toString() {
                return "NormalClass(value=" + this.value + ')';
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof NormalClass)) {
                    return false;
                }
                NormalClass normalClass = (NormalClass)object;
                return Intrinsics.areEqual((Object)this.value, (Object)normalClass.value);
            }
        }
    }
}

