/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class UShortValue
extends UnsignedValueConstant<Short> {
    public UShortValue(short s) {
        super(s);
    }

    @Override
    public KotlinType getType(ModuleDescriptor moduleDescriptor) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, StandardNames.FqNames.uShort);
        if (annotated != null && (annotated = annotated.getDefaultType()) != null) {
            kotlinType = (KotlinType)annotated;
        } else {
            String[] stringArray = new String[]{"UShort"};
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.NOT_FOUND_UNSIGNED_TYPE, stringArray);
        }
        return kotlinType;
    }

    @Override
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUShort()";
    }
}

