/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;

public final class DescriptorKindFilter {
    public static final Companion Companion;
    private final List<DescriptorKindExclude> excludes;
    private final int kindMask;
    private static int nextMaskValue;
    private static final int NON_SINGLETON_CLASSIFIERS_MASK;
    private static final int SINGLETON_CLASSIFIERS_MASK;
    private static final int TYPE_ALIASES_MASK;
    private static final int PACKAGES_MASK;
    private static final int FUNCTIONS_MASK;
    private static final int VARIABLES_MASK;
    private static final int ALL_KINDS_MASK;
    private static final int CLASSIFIERS_MASK;
    private static final int VALUES_MASK;
    private static final int CALLABLES_MASK;
    public static final DescriptorKindFilter ALL;
    public static final DescriptorKindFilter CALLABLES;
    public static final DescriptorKindFilter NON_SINGLETON_CLASSIFIERS;
    public static final DescriptorKindFilter SINGLETON_CLASSIFIERS;
    public static final DescriptorKindFilter TYPE_ALIASES;
    public static final DescriptorKindFilter CLASSIFIERS;
    public static final DescriptorKindFilter PACKAGES;
    public static final DescriptorKindFilter FUNCTIONS;
    public static final DescriptorKindFilter VARIABLES;
    public static final DescriptorKindFilter VALUES;
    private static final List<Companion.MaskToName> DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
    private static final List<Companion.MaskToName> DEBUG_MASK_BIT_NAMES;

    public DescriptorKindFilter(int n, List<? extends DescriptorKindExclude> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.excludes = list;
        int n2 = 0;
        n2 = n;
        Iterable iterable = this.excludes;
        boolean bl = false;
        for (Object t : iterable) {
            DescriptorKindExclude descriptorKindExclude = (DescriptorKindExclude)t;
            boolean bl2 = false;
            n2 &= ~descriptorKindExclude.getFullyExcludedDescriptorKinds();
        }
        this.kindMask = n2;
    }

    public /* synthetic */ DescriptorKindFilter(int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(n, list);
    }

    public final List<DescriptorKindExclude> getExcludes() {
        return this.excludes;
    }

    public final int getKindMask() {
        return this.kindMask;
    }

    public final boolean acceptsKinds(int n) {
        return (this.kindMask & n) != 0;
    }

    public final DescriptorKindFilter restrictedToKindsOrNull(int n) {
        int n2 = this.kindMask & n;
        if (n2 == 0) {
            return null;
        }
        return new DescriptorKindFilter(n2, this.excludes);
    }

    public String toString() {
        Object v0;
        boolean bl;
        Iterable iterable;
        block3: {
            iterable = DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
            bl = false;
            for (Object object : iterable) {
                Companion.MaskToName maskToName = (Companion.MaskToName)object;
                boolean bl2 = false;
                if (!(maskToName.getMask() == this.kindMask)) continue;
                v0 = object;
                break block3;
            }
            v0 = null;
        }
        Companion.MaskToName maskToName = v0;
        String string = maskToName != null ? maskToName.getName() : null;
        String string2 = string;
        if (string2 == null) {
            Object object;
            iterable = DEBUG_MASK_BIT_NAMES;
            bl = false;
            Iterable iterable2 = iterable;
            object = new ArrayList();
            boolean bl3 = false;
            Object object2 = iterable2;
            boolean bl4 = false;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                String string3;
                Object t;
                Object t2 = t = iterator2.next();
                boolean bl5 = false;
                Companion.MaskToName maskToName2 = (Companion.MaskToName)t2;
                boolean bl6 = false;
                if ((this.acceptsKinds(maskToName2.getMask()) ? maskToName2.getName() : null) == null) continue;
                string3 = string3;
                boolean bl7 = false;
                object.add((String)string3);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)object), (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null);
        }
        String string4 = string2;
        return "DescriptorKindFilter(" + string4 + ", " + this.excludes + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        DescriptorKindFilter cfr_ignored_0 = (DescriptorKindFilter)object;
        if (!Intrinsics.areEqual(this.excludes, ((DescriptorKindFilter)object).excludes)) {
            return false;
        }
        return this.kindMask == ((DescriptorKindFilter)object).kindMask;
    }

    public int hashCode() {
        int n = ((Object)this.excludes).hashCode();
        n = 31 * n + this.kindMask;
        return n;
    }

    static {
        boolean bl;
        Companion.MaskToName maskToName;
        boolean bl2;
        Object object5;
        Companion = new Companion(null);
        nextMaskValue = 1;
        NON_SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        TYPE_ALIASES_MASK = DescriptorKindFilter.Companion.nextMask();
        PACKAGES_MASK = DescriptorKindFilter.Companion.nextMask();
        FUNCTIONS_MASK = DescriptorKindFilter.Companion.nextMask();
        VARIABLES_MASK = DescriptorKindFilter.Companion.nextMask();
        ALL_KINDS_MASK = DescriptorKindFilter.Companion.nextMask() - 1;
        CLASSIFIERS_MASK = NON_SINGLETON_CLASSIFIERS_MASK | SINGLETON_CLASSIFIERS_MASK | TYPE_ALIASES_MASK;
        VALUES_MASK = SINGLETON_CLASSIFIERS_MASK | FUNCTIONS_MASK | VARIABLES_MASK;
        CALLABLES_MASK = FUNCTIONS_MASK | VARIABLES_MASK;
        ALL = new DescriptorKindFilter(ALL_KINDS_MASK, null, 2, null);
        CALLABLES = new DescriptorKindFilter(CALLABLES_MASK, null, 2, null);
        NON_SINGLETON_CLASSIFIERS = new DescriptorKindFilter(NON_SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        SINGLETON_CLASSIFIERS = new DescriptorKindFilter(SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        TYPE_ALIASES = new DescriptorKindFilter(TYPE_ALIASES_MASK, null, 2, null);
        CLASSIFIERS = new DescriptorKindFilter(CLASSIFIERS_MASK, null, 2, null);
        PACKAGES = new DescriptorKindFilter(PACKAGES_MASK, null, 2, null);
        FUNCTIONS = new DescriptorKindFilter(FUNCTIONS_MASK, null, 2, null);
        VARIABLES = new DescriptorKindFilter(VARIABLES_MASK, null, 2, null);
        VALUES = new DescriptorKindFilter(VALUES_MASK, null, 2, null);
        Object object2 = Companion;
        boolean bl3 = false;
        Field[] fieldArray = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
        Object object3 = fieldArray;
        boolean bl4 = false;
        Object[] objectArray = object3;
        Object object4 = new ArrayList();
        boolean bl5 = false;
        for (Object object5 : objectArray) {
            Field field = (Field)object5;
            boolean bl6 = false;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            object4.add(object5);
        }
        object2 = (List)object4;
        bl3 = false;
        object3 = object2;
        Collection collection = new ArrayList();
        boolean bl7 = false;
        object4 = object3;
        bl5 = false;
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            Companion.MaskToName maskToName2;
            DescriptorKindFilter descriptorKindFilter;
            Object t = iterator2.next();
            object5 = t;
            boolean bl8 = false;
            Field field = (Field)object5;
            bl2 = false;
            Object object6 = field.get(null);
            DescriptorKindFilter descriptorKindFilter2 = descriptorKindFilter = object6 instanceof DescriptorKindFilter ? (DescriptorKindFilter)object6 : null;
            if (descriptorKindFilter != null) {
                int n = descriptorKindFilter.kindMask;
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                maskToName2 = new Companion.MaskToName(n, string);
            } else {
                maskToName2 = null;
            }
            if (maskToName2 == null) continue;
            maskToName = maskToName2;
            bl = false;
            collection.add(maskToName);
        }
        DEBUG_PREDEFINED_FILTERS_MASK_NAMES = (List)collection;
        object2 = Companion;
        bl3 = false;
        Field[] fieldArray2 = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"");
        object3 = fieldArray2;
        boolean bl9 = false;
        Object object7 = object3;
        object4 = new ArrayList();
        bl5 = false;
        for (Object object5 : object7) {
            Field field = (Field)object5;
            boolean bl10 = false;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            object4.add(object5);
        }
        object2 = (List)object4;
        bl3 = false;
        object3 = object2;
        Collection collection2 = new ArrayList();
        boolean bl11 = false;
        object4 = object3.iterator();
        while (object4.hasNext()) {
            Object e = object4.next();
            Field field = (Field)e;
            int n = 0;
            if (!Intrinsics.areEqual(field.getType(), Integer.TYPE)) continue;
            collection2.add(e);
        }
        object2 = (List)collection2;
        bl3 = false;
        object3 = object2;
        collection2 = new ArrayList();
        bl11 = false;
        object4 = object3;
        bl5 = false;
        Iterator iterator3 = object4.iterator();
        while (iterator3.hasNext()) {
            Companion.MaskToName maskToName3;
            boolean bl12;
            Object t = iterator3.next();
            object5 = t;
            boolean bl13 = false;
            Field field = (Field)object5;
            bl2 = false;
            Object object8 = field.get(null);
            Intrinsics.checkNotNull((Object)object8);
            int n = (Integer)object8;
            boolean bl14 = bl12 = n == (n & -n);
            if (bl12) {
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                maskToName3 = new Companion.MaskToName(n, string);
            } else {
                maskToName3 = null;
            }
            if (maskToName3 == null) continue;
            maskToName = maskToName3;
            bl = false;
            collection2.add(maskToName);
        }
        DEBUG_MASK_BIT_NAMES = (List)collection2;
    }

    public static final class Companion {
        private Companion() {
        }

        private final int nextMask() {
            int n;
            int n2 = n = nextMaskValue;
            boolean bl = false;
            nextMaskValue = nextMaskValue << 1;
            return n;
        }

        public final int getNON_SINGLETON_CLASSIFIERS_MASK() {
            return NON_SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getSINGLETON_CLASSIFIERS_MASK() {
            return SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getTYPE_ALIASES_MASK() {
            return TYPE_ALIASES_MASK;
        }

        public final int getPACKAGES_MASK() {
            return PACKAGES_MASK;
        }

        public final int getFUNCTIONS_MASK() {
            return FUNCTIONS_MASK;
        }

        public final int getVARIABLES_MASK() {
            return VARIABLES_MASK;
        }

        public final int getALL_KINDS_MASK() {
            return ALL_KINDS_MASK;
        }

        public final int getCLASSIFIERS_MASK() {
            return CLASSIFIERS_MASK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        private static final class MaskToName {
            private final int mask;
            private final String name;

            public MaskToName(int n, String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                this.mask = n;
                this.name = string;
            }

            public final int getMask() {
                return this.mask;
            }

            public final String getName() {
                return this.name;
            }
        }
    }
}

