/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoEnumFlags;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.SuspendFunctionTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializerKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotations;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionForAbsentTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributeTranslator;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class TypeDeserializer {
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;
    private final String containerPresentableName;
    private final Function1<Integer, ClassifierDescriptor> classifierDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;

    public TypeDeserializer(DeserializationContext deserializationContext, TypeDeserializer typeDeserializer, List<ProtoBuf.TypeParameter> list, String string, String string2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)deserializationContext, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.c = deserializationContext;
        this.parent = typeDeserializer;
        this.debugName = string;
        this.containerPresentableName = string2;
        TypeDeserializer typeDeserializer2 = this;
        this.classifierDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(new TypeDeserializer$$Lambda$0(typeDeserializer2));
        typeDeserializer2 = this;
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(new TypeDeserializer$$Lambda$1(typeDeserializer2));
        TypeDeserializer typeDeserializer3 = this;
        if (list.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Iterator iterator2 = ((Iterable)list).iterator();
            int n = 0;
            TypeDeserializer typeDeserializer4 = typeDeserializer3;
            while (iterator2.hasNext()) {
                int n2 = n++;
                ProtoBuf.TypeParameter typeParameter = (ProtoBuf.TypeParameter)iterator2.next();
                ((Map)linkedHashMap).put(typeParameter.getId(), new DeserializedTypeParameterDescriptor(this.c, typeParameter, n2));
            }
            typeDeserializer3 = typeDeserializer4;
            map = linkedHashMap;
        }
        typeDeserializer3.typeParameterDescriptors = map;
    }

    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    public final KotlinType type(ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        if (type.hasFlexibleTypeCapabilitiesId()) {
            String string = this.c.getNameResolver().getString(type.getFlexibleTypeCapabilitiesId());
            SimpleType simpleType = TypeDeserializer.simpleType$default(this, type, false, 2, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(type, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type2);
            SimpleType simpleType2 = TypeDeserializer.simpleType$default(this, type2, false, 2, null);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(type, string, simpleType, simpleType2);
        }
        return this.simpleType(type, true);
    }

    private final TypeAttributes toAttributes(List<? extends TypeAttributeTranslator> list, Annotations annotations, TypeConstructor typeConstructor2, DeclarationDescriptor declarationDescriptor) {
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            TypeAttributeTranslator typeAttributeTranslator = (TypeAttributeTranslator)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(typeAttributeTranslator.toAttributes(annotations, typeConstructor2, declarationDescriptor));
        }
        List list2 = CollectionsKt.flatten((Iterable)((List)collection));
        return TypeAttributes.Companion.create(list2);
    }

    public final SimpleType simpleType(ProtoBuf.Type type, boolean bl) {
        Object object;
        Object object2;
        block15: {
            SimpleType simpleType;
            block14: {
                Object object3;
                SimpleType simpleType2;
                Intrinsics.checkNotNullParameter((Object)type, (String)"");
                SimpleType simpleType3 = simpleType2 = type.hasClassName() ? this.computeLocalClassifierReplacementType(type.getClassName()) : (type.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(type.getTypeAliasName()) : null);
                if (simpleType3 != null) {
                    return simpleType3;
                }
                TypeConstructor typeConstructor2 = this.typeConstructor(type);
                if (ErrorUtils.isError(typeConstructor2.getDeclarationDescriptor())) {
                    String[] stringArray = new String[]{typeConstructor2.toString()};
                    return ErrorUtils.INSTANCE.createErrorType(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, typeConstructor2, stringArray);
                }
                ProtoBuf.Type type2 = type;
                TypeDeserializer typeDeserializer = this;
                DeserializedAnnotations deserializedAnnotations = new DeserializedAnnotations(this.c.getStorageManager(), new TypeDeserializer$$Lambda$2(typeDeserializer, type2));
                TypeAttributes typeAttributes = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), deserializedAnnotations, typeConstructor2, this.c.getContainingDeclaration());
                Object object4 = TypeDeserializer.simpleType$collectAllArguments(type, this);
                boolean bl2 = false;
                object2 = object4;
                Object object5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
                boolean bl3 = false;
                int n = 0;
                Object object6 = object2.iterator();
                while (object6.hasNext()) {
                    int n2;
                    Object t = object6.next();
                    if ((n2 = n++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)t;
                    int n3 = n2;
                    Collection collection = object5;
                    boolean bl4 = false;
                    List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"");
                    collection.add(this.typeArgument((TypeParameterDescriptor)CollectionsKt.getOrNull(list, (int)n3), argument));
                }
                List list = CollectionsKt.toList((Iterable)((List)object5));
                object4 = typeConstructor2.getDeclarationDescriptor();
                if (bl && object4 instanceof TypeAliasDescriptor) {
                    KotlinTypeFactory kotlinTypeFactory = KotlinTypeFactory.INSTANCE;
                    n = 0;
                    object2 = KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)object4, list);
                    object5 = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), Annotations.Companion.create(CollectionsKt.plus((Iterable)deserializedAnnotations, (Iterable)((KotlinType)object2).getAnnotations())), typeConstructor2, this.c.getContainingDeclaration());
                    object3 = ((SimpleType)object2).makeNullableAsSpecified(KotlinTypeKt.isNullable((KotlinType)object2) || type.getNullable()).replaceAttributes((TypeAttributes)object5);
                } else if (Flags.SUSPEND_TYPE.get(type.getFlags()).booleanValue()) {
                    object3 = this.createSuspendFunctionType(typeAttributes, typeConstructor2, list, type.getNullable());
                } else {
                    object5 = KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor2, list, type.getNullable(), null, 16, null);
                    bl3 = false;
                    if (Flags.DEFINITELY_NOT_NULL_TYPE.get(type.getFlags()).booleanValue()) {
                        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, (UnwrappedType)object5, true, false, 4, null);
                        if (definitelyNotNullType == null) {
                            throw new IllegalStateException(("null DefinitelyNotNullType for '" + object5 + '\'').toString());
                        }
                        object3 = definitelyNotNullType;
                    } else {
                        object3 = object5;
                    }
                }
                simpleType = object3;
                object = ProtoTypeTableUtilKt.abbreviatedType(type, this.c.getTypeTable());
                if (object == null) break block14;
                object6 = object;
                boolean bl5 = false;
                SimpleType simpleType4 = SpecialTypesKt.withAbbreviation(simpleType, this.simpleType((ProtoBuf.Type)object6, false));
                object = simpleType4;
                if (simpleType4 != null) break block15;
            }
            object = simpleType;
        }
        object2 = object;
        return object2;
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return typeDeserializer.simpleType(type, bl);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type type) {
        ClassifierDescriptor classifierDescriptor;
        if (type.hasClassName()) {
            classifierDescriptor = (ClassifierDescriptor)this.classifierDescriptors.invoke((Object)type.getClassName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, type, type.getClassName());
            }
        } else if (type.hasTypeParameter()) {
            TypeParameterDescriptor typeParameterDescriptor = this.loadTypeParameter(type.getTypeParameter());
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{String.valueOf(type.getTypeParameter()), this.containerPresentableName};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (type.hasTypeParameterName()) {
            Object v2;
            String string;
            block13: {
                string = this.c.getNameResolver().getString(type.getTypeParameterName());
                Iterable iterable = this.getOwnTypeParameters();
                for (Object t : iterable) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)typeParameterDescriptor.getName().asString(), (Object)string)) continue;
                    v2 = t;
                    break block13;
                }
                v2 = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = v2;
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{string, this.c.getContainingDeclaration().toString()};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER_BY_NAME, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (type.hasTypeAliasName()) {
            classifierDescriptor = (ClassifierDescriptor)this.typeAliasDescriptors.invoke((Object)type.getTypeAliasName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, type, type.getTypeAliasName());
            }
        } else {
            return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.UNKNOWN_TYPE, new String[0]);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        TypeConstructor typeConstructor2 = classifierDescriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return typeConstructor2;
    }

    private final SimpleType createSuspendFunctionType(TypeAttributes typeAttributes, TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl) {
        SimpleType simpleType;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (typeConstructor2.getParameters().size() - list.size()) {
            case 0: {
                simpleType3 = this.createSuspendFunctionTypeForBasicCase(typeAttributes, typeConstructor2, list, bl);
                break;
            }
            case 1: {
                int n = list.size() - 1;
                if (n >= 0) {
                    TypeConstructor typeConstructor3 = typeConstructor2.getBuiltIns().getSuspendFunction(n).getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstructor3, (String)"");
                    simpleType3 = KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor3, list, bl, null, 16, null);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (simpleType = simpleType3)) == null) {
            simpleType2 = ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.INCONSISTENT_SUSPEND_FUNCTION, list, typeConstructor2, new String[0]);
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(TypeAttributes typeAttributes, TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl) {
        SimpleType simpleType = KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor2, list, bl, null, 16, null);
        return !FunctionTypesKt.isFunctionType(simpleType) ? null : this.transformRuntimeFunctionTypeToSuspendFunction(simpleType);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType kotlinType) {
        FqName fqName;
        Object object = (TypeProjection)CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType));
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object object2 = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)object2).getConstructor().getDeclarationDescriptor();
        FqName fqName2 = fqName = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
        if (((KotlinType)object2).getArguments().size() != 1 || !Intrinsics.areEqual((Object)fqName, (Object)StandardNames.CONTINUATION_INTERFACE_FQ_NAME) && !Intrinsics.areEqual((Object)fqName, (Object)TypeDeserializerKt.access$getEXPERIMENTAL_CONTINUATION_FQ_NAME$p())) {
            return (SimpleType)kotlinType;
        }
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.single(((KotlinType)object2).getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        KotlinType kotlinType3 = kotlinType2;
        DeclarationDescriptor declarationDescriptor = this.c.getContainingDeclaration();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null), (Object)SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(kotlinType, kotlinType3);
        }
        return this.createSimpleSuspendFunctionType(kotlinType, kotlinType3);
    }

    private final SimpleType createSimpleSuspendFunctionType(KotlinType kotlinType, KotlinType kotlinType2) {
        Collection<KotlinType> collection;
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType), (int)1);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType);
        KotlinType kotlinType3 = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType);
        Annotations annotations = kotlinType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(kotlinType);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            TypeProjection typeProjection = (TypeProjection)t;
            collection = collection2;
            boolean bl3 = false;
            collection.add(typeProjection.getType());
        }
        collection = (List)collection2;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations, kotlinType3, list, (List<? extends KotlinType>)collection, null, kotlinType2, true).makeNullableAsSpecified(kotlinType.isMarkedNullable());
    }

    private final TypeParameterDescriptor loadTypeParameter(int n) {
        TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptors.get(n);
        if (typeParameterDescriptor == null) {
            TypeDeserializer typeDeserializer = this.parent;
            typeParameterDescriptor = typeDeserializer != null ? typeDeserializer.loadTypeParameter(n) : null;
        }
        return typeParameterDescriptor;
    }

    private final ClassifierDescriptor computeClassifierDescriptor(int n) {
        ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), n);
        if (classId.isLocal()) {
            return this.c.getComponents().deserializeClass(classId);
        }
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), classId);
    }

    private final SimpleType computeLocalClassifierReplacementType(int n) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), n).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int n) {
        ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), n);
        if (classId.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), classId);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor typeParameterDescriptor, ProtoBuf.Type.Argument argument) {
        if (argument.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return typeParameterDescriptor == null ? (TypeProjection)new StarProjectionForAbsentTypeParameter(this.c.getComponents().getModuleDescriptor().getBuiltIns()) : (TypeProjection)new StarProjectionImpl(typeParameterDescriptor);
        }
        ProtoBuf.Type.Argument.Projection projection = argument.getProjection();
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.type(argument, this.c.getTypeTable());
        if (type == null) {
            String[] stringArray = new String[]{argument.toString()};
            return new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.NO_RECORDED_TYPE, stringArray));
        }
        ProtoBuf.Type type2 = type;
        return new TypeProjectionImpl(variance, this.type(type2));
    }

    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    private static final ClassifierDescriptor classifierDescriptors$lambda$0(TypeDeserializer typeDeserializer, int n) {
        return typeDeserializer.computeClassifierDescriptor(n);
    }

    private static final ClassifierDescriptor typeAliasDescriptors$lambda$1(TypeDeserializer typeDeserializer, int n) {
        return typeDeserializer.computeTypeAliasDescriptor(n);
    }

    private static final List simpleType$lambda$3(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return typeDeserializer.c.getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(type, typeDeserializer.c.getNameResolver());
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type type, TypeDeserializer typeDeserializer) {
        List<ProtoBuf.Type.Argument> list = type.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Collection collection = list;
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType(type, typeDeserializer.c.getTypeTable());
        List list2 = type2 != null ? TypeDeserializer.simpleType$collectAllArguments(type2, typeDeserializer) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private static final ProtoBuf.Type typeConstructor$notFoundClass$lambda$8(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return ProtoTypeTableUtilKt.outerType(type, typeDeserializer.c.getTypeTable());
    }

    private static final int typeConstructor$notFoundClass$lambda$9(ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return type.getArgumentCount();
    }

    private static final ClassDescriptor typeConstructor$notFoundClass(TypeDeserializer typeDeserializer, ProtoBuf.Type type, int n) {
        ClassId classId = NameResolverUtilKt.getClassId(typeDeserializer.c.getNameResolver(), n);
        TypeDeserializer typeDeserializer2 = typeDeserializer;
        List list = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)type, (Function1)new TypeDeserializer$$Lambda$3(typeDeserializer2)), (Function1)TypeDeserializer$$Lambda$4.INSTANCE));
        int n2 = SequencesKt.count((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)((Function1)typeConstructor.notFoundClass.classNestingLevel.1.INSTANCE)));
        while (list.size() < n2) {
            list.add(0);
        }
        return typeDeserializer.c.getComponents().getNotFoundClasses().getClass(classId, list);
    }

    static /* synthetic */ ClassifierDescriptor accessor$TypeDeserializer$lambda0(TypeDeserializer typeDeserializer, int n) {
        return TypeDeserializer.classifierDescriptors$lambda$0(typeDeserializer, n);
    }

    static /* synthetic */ ClassifierDescriptor accessor$TypeDeserializer$lambda1(TypeDeserializer typeDeserializer, int n) {
        return TypeDeserializer.typeAliasDescriptors$lambda$1(typeDeserializer, n);
    }

    static /* synthetic */ List accessor$TypeDeserializer$lambda2(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return TypeDeserializer.simpleType$lambda$3(typeDeserializer, type);
    }

    static /* synthetic */ ProtoBuf.Type accessor$TypeDeserializer$lambda3(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return TypeDeserializer.typeConstructor$notFoundClass$lambda$8(typeDeserializer, type);
    }

    static /* synthetic */ int accessor$TypeDeserializer$lambda4(ProtoBuf.Type type) {
        return TypeDeserializer.typeConstructor$notFoundClass$lambda$9(type);
    }
}

