/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public final class AbstractNullabilityChecker {
    public static final AbstractNullabilityChecker INSTANCE = new AbstractNullabilityChecker();

    private AbstractNullabilityChecker() {
    }

    public final boolean isPossibleSubtype(TypeCheckerState typeCheckerState, RigidTypeMarker rigidTypeMarker, RigidTypeMarker rigidTypeMarker2) {
        Intrinsics.checkNotNullParameter((Object)typeCheckerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)rigidTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)rigidTypeMarker2, (String)"");
        return this.runIsPossibleSubtype(typeCheckerState, rigidTypeMarker, rigidTypeMarker2);
    }

    private final boolean runIsPossibleSubtype(TypeCheckerState typeCheckerState, RigidTypeMarker rigidTypeMarker, RigidTypeMarker rigidTypeMarker2) {
        TypeSystemContext typeSystemContext = typeCheckerState.getTypeSystemContext();
        boolean bl = false;
        if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
            boolean bl2;
            boolean bl3 = bl2 = typeSystemContext.isSingleClassifierType(rigidTypeMarker) || typeSystemContext.isIntersection(typeSystemContext.typeConstructor(rigidTypeMarker)) || typeCheckerState.isAllowedTypeVariable(rigidTypeMarker);
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Not singleClassifierType and not intersection subType: " + rigidTypeMarker;
                throw new AssertionError((Object)string);
            }
            boolean bl5 = bl2 = typeSystemContext.isSingleClassifierType(rigidTypeMarker2) || typeCheckerState.isAllowedTypeVariable(rigidTypeMarker2);
            if (_Assertions.ENABLED && !bl2) {
                boolean bl6 = false;
                String string = "Not singleClassifierType superType: " + rigidTypeMarker2;
                throw new AssertionError((Object)string);
            }
        }
        if (typeSystemContext.isMarkedNullable(rigidTypeMarker2)) {
            return true;
        }
        if (typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker) || typeSystemContext.isNotNullTypeParameter(rigidTypeMarker)) {
            return true;
        }
        if (rigidTypeMarker instanceof CapturedTypeMarker && typeSystemContext.isProjectionNotNull((CapturedTypeMarker)rigidTypeMarker)) {
            return true;
        }
        if (INSTANCE.hasNotNullSupertype(typeCheckerState, rigidTypeMarker, TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if (typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker2)) {
            return false;
        }
        if (INSTANCE.hasNotNullSupertype(typeCheckerState, rigidTypeMarker2, TypeCheckerState.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if (typeSystemContext.isClassType(rigidTypeMarker)) {
            return false;
        }
        return INSTANCE.hasPathByNotMarkedNullableNodes(typeCheckerState, rigidTypeMarker, typeSystemContext.typeConstructor(rigidTypeMarker2));
    }

    public final boolean hasNotNullSupertype(TypeCheckerState typeCheckerState, RigidTypeMarker rigidTypeMarker, TypeCheckerState.SupertypesPolicy supertypesPolicy) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)typeCheckerState, (String)"");
            Intrinsics.checkNotNullParameter((Object)rigidTypeMarker, (String)"");
            Intrinsics.checkNotNullParameter((Object)supertypesPolicy, (String)"");
            TypeSystemContext typeSystemContext = typeCheckerState.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState typeCheckerState2 = typeCheckerState;
            boolean bl3 = false;
            RigidTypeMarker rigidTypeMarker2 = rigidTypeMarker;
            boolean bl4 = false;
            if (typeSystemContext.isClassType(rigidTypeMarker2) && !typeSystemContext.isMarkedNullable(rigidTypeMarker2) || typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker2)) {
                bl = true;
            } else {
                typeCheckerState2.initialize();
                ArrayDeque<RigidTypeMarker> arrayDeque = typeCheckerState2.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<RigidTypeMarker> arrayDeque2 = arrayDeque;
                Set<RigidTypeMarker> set = typeCheckerState2.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<RigidTypeMarker> set2 = set;
                arrayDeque2.push(rigidTypeMarker);
                while (!((Collection)arrayDeque2).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy supertypesPolicy2;
                    Object object;
                    RigidTypeMarker rigidTypeMarker3 = arrayDeque2.pop();
                    Intrinsics.checkNotNull((Object)rigidTypeMarker3);
                    if (!set2.add(rigidTypeMarker3)) continue;
                    rigidTypeMarker2 = rigidTypeMarker3;
                    bl4 = false;
                    Object object2 = object = typeSystemContext.isMarkedNullable(rigidTypeMarker2) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual((Object)object2, (Object)TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? object : null) == null) continue;
                    supertypesPolicy2 = supertypesPolicy2;
                    object2 = typeCheckerState2.getTypeSystemContext();
                    bl5 = false;
                    Collection<KotlinTypeMarker> collection = object2.supertypes(object2.typeConstructor(rigidTypeMarker3));
                    object = collection.iterator();
                    while (object.hasNext()) {
                        RigidTypeMarker rigidTypeMarker4;
                        object2 = (KotlinTypeMarker)object.next();
                        rigidTypeMarker2 = rigidTypeMarker4 = supertypesPolicy2.transformType(typeCheckerState2, (KotlinTypeMarker)object2);
                        bl4 = false;
                        if (typeSystemContext.isClassType(rigidTypeMarker2) && !typeSystemContext.isMarkedNullable(rigidTypeMarker2) || typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker2)) {
                            typeCheckerState2.clear();
                            bl = true;
                            break block5;
                        }
                        arrayDeque2.add(rigidTypeMarker4);
                    }
                }
                typeCheckerState2.clear();
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasPathByNotMarkedNullableNodes(TypeCheckerState typeCheckerState, RigidTypeMarker rigidTypeMarker, TypeConstructorMarker typeConstructorMarker) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)typeCheckerState, (String)"");
            Intrinsics.checkNotNullParameter((Object)rigidTypeMarker, (String)"");
            Intrinsics.checkNotNullParameter((Object)typeConstructorMarker, (String)"");
            TypeSystemContext typeSystemContext = typeCheckerState.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState typeCheckerState2 = typeCheckerState;
            boolean bl3 = false;
            RigidTypeMarker rigidTypeMarker2 = rigidTypeMarker;
            boolean bl4 = false;
            if (INSTANCE.isApplicableAsEndNode(typeCheckerState, rigidTypeMarker2, typeConstructorMarker)) {
                bl = true;
            } else {
                typeCheckerState2.initialize();
                ArrayDeque<RigidTypeMarker> arrayDeque = typeCheckerState2.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<RigidTypeMarker> arrayDeque2 = arrayDeque;
                Set<RigidTypeMarker> set = typeCheckerState2.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<RigidTypeMarker> set2 = set;
                arrayDeque2.push(rigidTypeMarker);
                while (!((Collection)arrayDeque2).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy supertypesPolicy;
                    Object object;
                    RigidTypeMarker rigidTypeMarker3 = arrayDeque2.pop();
                    Intrinsics.checkNotNull((Object)rigidTypeMarker3);
                    if (!set2.add(rigidTypeMarker3)) continue;
                    rigidTypeMarker2 = rigidTypeMarker3;
                    bl4 = false;
                    Object object2 = object = typeSystemContext.isMarkedNullable(rigidTypeMarker2) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual((Object)object2, (Object)TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? object : null) == null) continue;
                    supertypesPolicy = supertypesPolicy;
                    object2 = typeCheckerState2.getTypeSystemContext();
                    bl5 = false;
                    Collection<KotlinTypeMarker> collection = object2.supertypes(object2.typeConstructor(rigidTypeMarker3));
                    object = collection.iterator();
                    while (object.hasNext()) {
                        RigidTypeMarker rigidTypeMarker4;
                        object2 = (KotlinTypeMarker)object.next();
                        rigidTypeMarker2 = rigidTypeMarker4 = supertypesPolicy.transformType(typeCheckerState2, (KotlinTypeMarker)object2);
                        bl4 = false;
                        if (INSTANCE.isApplicableAsEndNode(typeCheckerState, rigidTypeMarker2, typeConstructorMarker)) {
                            typeCheckerState2.clear();
                            bl = true;
                            break block5;
                        }
                        arrayDeque2.add(rigidTypeMarker4);
                    }
                }
                typeCheckerState2.clear();
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isApplicableAsEndNode(TypeCheckerState typeCheckerState, RigidTypeMarker rigidTypeMarker, TypeConstructorMarker typeConstructorMarker) {
        TypeSystemContext typeSystemContext = typeCheckerState.getTypeSystemContext();
        boolean bl = false;
        if (typeSystemContext.isNothing(rigidTypeMarker)) {
            return true;
        }
        if (typeSystemContext.isMarkedNullable(rigidTypeMarker)) {
            return false;
        }
        if (typeCheckerState.isStubTypeEqualsToAnything() && typeSystemContext.isStubType(rigidTypeMarker)) {
            return true;
        }
        return typeSystemContext.areEqualTypeConstructors(typeSystemContext.typeConstructor(rigidTypeMarker), typeConstructorMarker);
    }
}

