/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public final class AbstractStrictEqualityTypeChecker {
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return this.strictEqualTypesInternal(typeSystemContext, kotlinTypeMarker, kotlinTypeMarker2);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        if (kotlinTypeMarker == kotlinTypeMarker2) {
            return true;
        }
        RigidTypeMarker rigidTypeMarker = typeSystemContext.asRigidType(kotlinTypeMarker);
        RigidTypeMarker rigidTypeMarker2 = typeSystemContext.asRigidType(kotlinTypeMarker2);
        if (rigidTypeMarker != null && rigidTypeMarker2 != null) {
            return this.strictEqualRigidTypes(typeSystemContext, rigidTypeMarker, rigidTypeMarker2);
        }
        FlexibleTypeMarker flexibleTypeMarker = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        FlexibleTypeMarker flexibleTypeMarker2 = typeSystemContext.asFlexibleType(kotlinTypeMarker2);
        if (flexibleTypeMarker != null && flexibleTypeMarker2 != null) {
            return this.strictEqualRigidTypes(typeSystemContext, typeSystemContext.lowerBound(flexibleTypeMarker), typeSystemContext.lowerBound(flexibleTypeMarker2)) && this.strictEqualRigidTypes(typeSystemContext, typeSystemContext.upperBound(flexibleTypeMarker), typeSystemContext.upperBound(flexibleTypeMarker2));
        }
        return false;
    }

    private final boolean strictEqualRigidTypes(TypeSystemContext typeSystemContext, RigidTypeMarker rigidTypeMarker, RigidTypeMarker rigidTypeMarker2) {
        if (typeSystemContext.argumentsCount(rigidTypeMarker) != typeSystemContext.argumentsCount(rigidTypeMarker2) || typeSystemContext.isMarkedNullable(rigidTypeMarker) != typeSystemContext.isMarkedNullable(rigidTypeMarker2) || typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker) != typeSystemContext.isDefinitelyNotNullType(rigidTypeMarker2) || !typeSystemContext.areEqualTypeConstructors(typeSystemContext.typeConstructor(rigidTypeMarker), typeSystemContext.typeConstructor(rigidTypeMarker2))) {
            return false;
        }
        if (typeSystemContext.identicalArguments(rigidTypeMarker, rigidTypeMarker2)) {
            return true;
        }
        int n = typeSystemContext.argumentsCount(rigidTypeMarker);
        for (int i = 0; i < n; ++i) {
            TypeArgumentMarker typeArgumentMarker = typeSystemContext.getArgument(rigidTypeMarker, i);
            TypeArgumentMarker typeArgumentMarker2 = typeSystemContext.getArgument(rigidTypeMarker2, i);
            if (typeSystemContext.isStarProjection(typeArgumentMarker) != typeSystemContext.isStarProjection(typeArgumentMarker2)) {
                return false;
            }
            if (typeSystemContext.isStarProjection(typeArgumentMarker)) continue;
            if (typeSystemContext.getVariance(typeArgumentMarker) != typeSystemContext.getVariance(typeArgumentMarker2)) {
                return false;
            }
            KotlinTypeMarker kotlinTypeMarker = typeSystemContext.getType(typeArgumentMarker);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker);
            KotlinTypeMarker kotlinTypeMarker2 = typeSystemContext.getType(typeArgumentMarker2);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker2);
            if (this.strictEqualTypesInternal(typeSystemContext, kotlinTypeMarker, kotlinTypeMarker2)) continue;
            return false;
        }
        return true;
    }
}

