/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;

public final class FlexibleTypesKt {
    public static final boolean isFlexible(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType.unwrap() instanceof FlexibleType;
    }

    public static final FlexibleType asFlexibleType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (FlexibleType)unwrappedType;
    }

    public static final SimpleType lowerIfFlexible(KotlinType kotlinType) {
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType = ((FlexibleType)unwrappedType).getLowerBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType = (SimpleType)unwrappedType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType;
    }

    public static final SimpleType upperIfFlexible(KotlinType kotlinType) {
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        UnwrappedType unwrappedType = kotlinType.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType = ((FlexibleType)unwrappedType).getUpperBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType = (SimpleType)unwrappedType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType;
    }
}

