/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AnnotationsTypeAttributeKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicType;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class TypeAliasExpander {
    public static final Companion Companion = new Companion(null);
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);

    public TypeAliasExpander(TypeAliasExpansionReportStrategy typeAliasExpansionReportStrategy, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansionReportStrategy, (String)"");
        this.reportStrategy = typeAliasExpansionReportStrategy;
        this.shouldCheckBounds = bl;
    }

    public final SimpleType expand(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return this.expandRecursively(typeAliasExpansion, typeAttributes, false, 0, true);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes, boolean bl, int n, boolean bl2) {
        boolean bl3;
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.INVARIANT, typeAliasExpansion.getDescriptor().getUnderlyingType());
        TypeProjection typeProjection = this.expandTypeProjection(typeProjectionImpl, typeAliasExpansion, null, n);
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        SimpleType simpleType = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(simpleType)) {
            return simpleType;
        }
        boolean bl4 = bl3 = typeProjection.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)typeProjection.getProjectionKind()) + ", should be invariant";
            throw new AssertionError((Object)string);
        }
        this.checkRepeatedAnnotations(simpleType.getAnnotations(), AnnotationsTypeAttributeKt.getAnnotations(typeAttributes));
        SimpleType simpleType2 = this.combineAttributes(simpleType, typeAttributes);
        boolean bl6 = false;
        SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded(simpleType2, bl);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"");
        SimpleType simpleType4 = simpleType3;
        return bl2 ? SpecialTypesKt.withAbbreviation(simpleType4, this.createAbbreviation(typeAliasExpansion, typeAttributes, bl)) : simpleType4;
    }

    private final SimpleType createAbbreviation(TypeAliasExpansion typeAliasExpansion, TypeAttributes typeAttributes, boolean bl) {
        TypeConstructor typeConstructor2 = typeAliasExpansion.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(typeAttributes, typeConstructor2, typeAliasExpansion.getArguments(), bl, MemberScope.Empty.INSTANCE);
    }

    private final TypeProjection expandTypeProjection(TypeProjection typeProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int n) {
        Variance variance;
        Object object;
        Variance variance2;
        Variance variance3;
        TypeAliasExpander.Companion.assertRecursionDepth(n, typeAliasExpansion.getDescriptor());
        if (typeProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor2);
            TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"");
            return typeProjection2;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        TypeProjection typeProjection3 = typeAliasExpansion.getReplacement(kotlinType2.getConstructor());
        if (typeProjection3 == null) {
            return this.expandNonArgumentTypeProjection(typeProjection, typeAliasExpansion, n);
        }
        TypeProjection typeProjection4 = typeProjection3;
        if (typeProjection4.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor3);
            TypeProjection typeProjection5 = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection5, (String)"");
            return typeProjection5;
        }
        UnwrappedType unwrappedType = typeProjection4.getType().unwrap();
        TypeAliasExpander typeAliasExpander = this;
        boolean bl = false;
        Variance variance4 = typeProjection4.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance4), (String)"");
        Variance variance5 = variance4;
        Variance variance6 = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance6), (String)"");
        Variance variance7 = variance6;
        if (variance7 == variance5) {
            variance3 = variance5;
        } else if (variance7 == Variance.INVARIANT) {
            variance3 = variance5;
        } else if (variance5 == Variance.INVARIANT) {
            variance3 = variance7;
        } else {
            typeAliasExpander.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, unwrappedType);
            variance3 = variance2 = variance5;
        }
        if ((object = typeParameterDescriptor) == null || (object = object.getVariance()) == null) {
            object = Variance.INVARIANT;
        }
        Object object2 = object;
        if (object2 == variance2) {
            variance = variance2;
        } else if (object2 == Variance.INVARIANT) {
            variance = variance2;
        } else if (variance2 == Variance.INVARIANT) {
            variance = Variance.INVARIANT;
        } else {
            typeAliasExpander.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, unwrappedType);
            variance = variance2;
        }
        Variance variance8 = variance;
        this.checkRepeatedAnnotations(kotlinType2.getAnnotations(), unwrappedType.getAnnotations());
        UnwrappedType unwrappedType2 = unwrappedType instanceof DynamicType ? (UnwrappedType)this.combineAttributes((DynamicType)unwrappedType, kotlinType2.getAttributes()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(unwrappedType), kotlinType2);
        return new TypeProjectionImpl(variance8, unwrappedType2);
    }

    private final DynamicType combineAttributes(DynamicType dynamicType, TypeAttributes typeAttributes) {
        return dynamicType.replaceAttributes(this.createdCombinedAttributes(dynamicType, typeAttributes));
    }

    private final SimpleType combineAttributes(SimpleType simpleType, TypeAttributes typeAttributes) {
        return KotlinTypeKt.isError(simpleType) ? simpleType : TypeSubstitutionKt.replace$default(simpleType, null, this.createdCombinedAttributes(simpleType, typeAttributes), 1, null);
    }

    private final TypeAttributes createdCombinedAttributes(KotlinType kotlinType, TypeAttributes typeAttributes) {
        if (KotlinTypeKt.isError(kotlinType)) {
            return kotlinType.getAttributes();
        }
        return typeAttributes.add(kotlinType.getAttributes());
    }

    private final void checkRepeatedAnnotations(Annotations annotations, Annotations annotations2) {
        Iterable iterable = annotations;
        Object object2 = new HashSet();
        boolean bl = false;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)t;
            Collection collection = object2;
            boolean bl2 = false;
            collection.add(annotationDescriptor.getFqName());
        }
        HashSet hashSet = (HashSet)object2;
        for (Object object2 : annotations2) {
            if (!hashSet.contains(object2.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation((AnnotationDescriptor)object2);
        }
    }

    private final SimpleType combineNullability(SimpleType simpleType, KotlinType kotlinType) {
        SimpleType simpleType2 = TypeUtils.makeNullableIfNeeded(simpleType, kotlinType.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        return simpleType2;
    }

    private final SimpleType combineNullabilityAndAnnotations(SimpleType simpleType, KotlinType kotlinType) {
        return this.combineAttributes(this.combineNullability(simpleType, kotlinType), kotlinType.getAttributes());
    }

    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection typeProjection, TypeAliasExpansion typeAliasExpansion, int n) {
        TypeProjection typeProjection2;
        boolean bl;
        UnwrappedType unwrappedType = typeProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(unwrappedType)) {
            return typeProjection;
        }
        SimpleType simpleType = TypeSubstitutionKt.asSimpleType(unwrappedType);
        if (KotlinTypeKt.isError(simpleType) || !TypeUtilsKt.requiresTypeAliasExpansion(simpleType)) {
            return typeProjection;
        }
        TypeConstructor typeConstructor2 = simpleType.getConstructor();
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl2 = bl = typeConstructor2.getParameters().size() == simpleType.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Unexpected malformed type: " + simpleType;
            throw new AssertionError((Object)string);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            typeProjection2 = typeProjection;
        } else if (classifierDescriptor2 instanceof TypeAliasDescriptor) {
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)classifierDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)classifierDescriptor);
                String[] stringArray = new String[]{((TypeAliasDescriptor)classifierDescriptor).getName().toString()};
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, stringArray));
            }
            Object object = simpleType.getArguments();
            boolean bl4 = false;
            Object object2 = object;
            Object object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl5 = false;
            int n2 = 0;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                int n3;
                Object t = iterator2.next();
                if ((n3 = n2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeProjection typeProjection3 = (TypeProjection)t;
                int n4 = n3;
                Collection collection = object3;
                boolean bl6 = false;
                collection.add(this.expandTypeProjection(typeProjection3, typeAliasExpansion, typeConstructor2.getParameters().get(n4), n + 1));
            }
            List list = (List)object3;
            object = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)classifierDescriptor, list);
            SimpleType simpleType2 = this.expandRecursively((TypeAliasExpansion)object, simpleType.getAttributes(), simpleType.isMarkedNullable(), n + 1, false);
            object2 = this.substituteArguments(simpleType, typeAliasExpansion, n);
            object3 = DynamicTypesKt.isDynamic(simpleType2) ? simpleType2 : SpecialTypesKt.withAbbreviation(simpleType2, (SimpleType)object2);
            typeProjection2 = new TypeProjectionImpl(typeProjection.getProjectionKind(), (KotlinType)object3);
        } else {
            SimpleType simpleType3 = this.substituteArguments(simpleType, typeAliasExpansion, n);
            this.checkTypeArgumentsSubstitution(simpleType, simpleType3);
            typeProjection2 = new TypeProjectionImpl(typeProjection.getProjectionKind(), simpleType3);
        }
        return typeProjection2;
    }

    private final SimpleType substituteArguments(SimpleType simpleType, TypeAliasExpansion typeAliasExpansion, int n) {
        TypeConstructor typeConstructor2 = simpleType.getConstructor();
        Iterable iterable = simpleType.getArguments();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        int n2 = 0;
        for (Object t : iterable2) {
            int n3;
            if ((n3 = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)t;
            int n4 = n3;
            Collection collection2 = collection;
            boolean bl3 = false;
            TypeProjection typeProjection2 = this.expandTypeProjection(typeProjection, typeAliasExpansion, typeConstructor2.getParameters().get(n4), n + 1);
            collection2.add(typeProjection2.isStarProjection() ? typeProjection2 : (TypeProjection)new TypeProjectionImpl(typeProjection2.getProjectionKind(), TypeUtils.makeNullableIfNeeded(typeProjection2.getType(), typeProjection.getType().isMarkedNullable())));
        }
        List list = (List)collection;
        return TypeSubstitutionKt.replace$default(simpleType, list, null, 2, null);
    }

    private final void checkTypeArgumentsSubstitution(KotlinType kotlinType, KotlinType kotlinType2) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(kotlinType2);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        Iterable iterable = kotlinType2.getArguments();
        boolean bl = false;
        int n = 0;
        for (Object t : iterable) {
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)t;
            int n3 = n2;
            boolean bl2 = false;
            if (typeProjection.isStarProjection()) continue;
            KotlinType kotlinType3 = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType3)) continue;
            TypeProjection typeProjection2 = kotlinType.getArguments().get(n3);
            TypeParameterDescriptor typeParameterDescriptor = kotlinType.getConstructor().getParameters().get(n3);
            if (!this.shouldCheckBounds) continue;
            KotlinType kotlinType4 = typeProjection2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"");
            KotlinType kotlinType5 = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType5, (String)"");
            Intrinsics.checkNotNull((Object)typeParameterDescriptor);
            this.reportStrategy.boundsViolationInSubstitution(typeSubstitutor3, kotlinType4, kotlinType5, typeParameterDescriptor);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        private final void assertRecursionDepth(int n, TypeAliasDescriptor typeAliasDescriptor) {
            if (n > 100) {
                throw new AssertionError((Object)("Too deep recursion while expanding type alias " + typeAliasDescriptor.getName()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

