/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class ErrorUtils {
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    private static final ErrorClassDescriptor errorClass;
    private static final KotlinType errorTypeForLoopInSupertypes;
    private static final KotlinType errorPropertyType;
    private static final PropertyDescriptor errorProperty;
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorScopeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return ErrorUtils.createErrorScope(errorScopeKind, false, Arrays.copyOf(stringArray, stringArray.length));
    }

    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, boolean bl, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorScopeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return bl ? (ErrorScope)new ThrowingScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length)) : new ErrorScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length));
    }

    @JvmStatic
    public static final ErrorType createErrorType(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return INSTANCE.createErrorTypeWithArguments(errorTypeKind, (List<? extends TypeProjection>)CollectionsKt.emptyList(), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorType(ErrorTypeKind errorTypeKind, TypeConstructor typeConstructor2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.createErrorTypeWithArguments(errorTypeKind, (List<? extends TypeProjection>)CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.createErrorTypeWithArguments(errorTypeKind, list, this.createErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length)), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, TypeConstructor typeConstructor2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        String[] stringArray2 = new String[]{typeConstructor2.toString()};
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray2), errorTypeKind, list, false, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorTypeConstructor createErrorTypeConstructor(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return new ErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isError(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) return false;
        if (INSTANCE.isErrorClass(declarationDescriptor)) return true;
        if (INSTANCE.isErrorClass(declarationDescriptor.getContainingDeclaration())) return true;
        if (declarationDescriptor != errorModule) return false;
        return true;
    }

    private final boolean isErrorClass(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(KotlinType kotlinType) {
        if (kotlinType == null) {
            return false;
        }
        TypeConstructor typeConstructor2 = kotlinType.getConstructor();
        return typeConstructor2 instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)typeConstructor2).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    public final String unresolvedTypeAsItIs(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        boolean bl = TypeUtilsKt.isUnresolvedType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeConstructor typeConstructor2 = kotlinType.getConstructor();
        Intrinsics.checkNotNull((Object)typeConstructor2);
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{"unknown class"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        Name name = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf((Object)errorProperty);
    }
}

