/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.AbstractArrayMapOwner;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapImpl;
import kotlin.reflect.jvm.internal.impl.util.EmptyArrayMap;
import kotlin.reflect.jvm.internal.impl.util.OneElementArrayMap;

public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"");
        this.arrayMap = arrayMap;
    }

    @Override
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull((Object)emptyArrayMap);
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(String string, T t) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = this.getTypeRegistry().getId(string);
        switch (this.arrayMap.getSize()) {
            case 0: {
                ArrayMap<T> arrayMap = this.arrayMap;
                if (!(arrayMap instanceof EmptyArrayMap)) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(arrayMap, 0, "EmptyArrayMap"));
                }
                this.arrayMap = new OneElementArrayMap<T>(t, n);
                return;
            }
            case 1: {
                OneElementArrayMap oneElementArrayMap;
                ArrayMap<T> arrayMap = this.arrayMap;
                try {
                    Intrinsics.checkNotNull(arrayMap);
                    oneElementArrayMap = (OneElementArrayMap)arrayMap;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(arrayMap, 1, "OneElementArrayMap"), classCastException);
                }
                OneElementArrayMap oneElementArrayMap2 = oneElementArrayMap;
                if (oneElementArrayMap2.getIndex() == n) {
                    this.arrayMap = new OneElementArrayMap<T>(t, n);
                    return;
                }
                this.arrayMap = new ArrayMapImpl();
                this.arrayMap.set(oneElementArrayMap2.getIndex(), oneElementArrayMap2.getValue());
            }
        }
        this.arrayMap.set(n, t);
    }

    private final String buildDiagnosticMessage(ArrayMap<T> arrayMap, int n, String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        stringBuilder3.append("Race condition happened, the size of ArrayMap is " + n + " but it isn't an `" + string + '`').append('\n');
        stringBuilder3.append("Type: " + arrayMap.getClass()).append('\n');
        StringBuilder stringBuilder4 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Map<String, Integer> map = this.getTypeRegistry().allValuesThreadUnsafeForRendering();
        stringBuilder4.append("[").append('\n');
        Iterable iterable = arrayMap;
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl4 = false;
        int n2 = 0;
        for (Object t : iterable2) {
            Object v0;
            Collection collection2;
            int n3;
            Object t2;
            block3: {
                int n4;
                if ((n4 = n2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                t2 = t;
                n3 = n4;
                collection2 = collection;
                boolean bl5 = false;
                Iterable iterable3 = map.entrySet();
                boolean bl6 = false;
                for (Object t3 : iterable3) {
                    Map.Entry entry = (Map.Entry)t3;
                    boolean bl7 = false;
                    if (!(((Number)entry.getValue()).intValue() == n3)) continue;
                    v0 = t3;
                    break block3;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            collection2.add(stringBuilder4.append("  " + entry + '[' + n3 + "]: " + t2).append('\n'));
        }
        List cfr_ignored_0 = (List)collection;
        stringBuilder4.append("]").append('\n');
        String string2 = stringBuilder.toString();
        stringBuilder3.append("Content: " + string2).append('\n');
        return stringBuilder2.toString();
    }
}

