/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;

public final class OneElementArrayMap<T>
extends ArrayMap<T> {
    private final T value;
    private final int index;

    public OneElementArrayMap(T t, int n) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        super(null);
        this.value = t;
        this.index = n;
    }

    public final T getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public void set(int n, T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        throw new IllegalStateException();
    }

    @Override
    public T get(int n) {
        return n == this.index ? (T)this.value : null;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private boolean notVisited;
            final /* synthetic */ OneElementArrayMap<T> this$0;
            {
                this.this$0 = oneElementArrayMap;
                this.notVisited = true;
            }

            public boolean hasNext() {
                return this.notVisited;
            }

            public T next() {
                if (this.notVisited) {
                    this.notVisited = false;
                    return this.this$0.getValue();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }
}

