/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.util.NullableArrayMapAccessor;
import kotlin.reflect.jvm.internal.impl.util.TypeRegistry$$Lambda$0;

public abstract class TypeRegistry<K, V> {
    private final ConcurrentHashMap<String, Integer> idPerType = new ConcurrentHashMap();
    private final AtomicInteger idCounter = new AtomicInteger(0);

    public final <T extends V, KK extends K> NullableArrayMapAccessor<K, V, T> generateNullableAccessor(KClass<KK> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        return new NullableArrayMapAccessor(this.getId(kClass));
    }

    public final <T extends K> int getId(KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        String string = kClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return this.getId(string);
    }

    public final int getId(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        TypeRegistry typeRegistry = this;
        return this.customComputeIfAbsent(this.idPerType, string, new TypeRegistry$$Lambda$0(typeRegistry));
    }

    public abstract int customComputeIfAbsent(ConcurrentHashMap<String, Integer> var1, String var2, Function1<? super String, Integer> var3);

    public final Map<String, Integer> allValuesThreadUnsafeForRendering() {
        return this.idPerType;
    }

    protected final Collection<Integer> getIndices() {
        Collection<Integer> collection = this.idPerType.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        return collection;
    }

    private static final int getId$lambda$0(TypeRegistry typeRegistry, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return typeRegistry.idCounter.getAndIncrement();
    }

    static /* synthetic */ int accessor$TypeRegistry$lambda0(TypeRegistry typeRegistry, String string) {
        return TypeRegistry.getId$lambda$0(typeRegistry, string);
    }
}

