/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.collections.AbstractMutableSet;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;

public final class SmartSet<T>
extends AbstractMutableSet<T> {
    public static final Companion Companion = new Companion(null);
    private Object data;
    private int size;

    private SmartSet() {
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size() == 0) {
            iterator2 = Collections.emptySet().iterator();
        } else if (this.size() == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            iterator2 = new ArrayIterator<Object>((Object[])object);
        } else {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            iterator2 = TypeIntrinsics.asMutableSet((Object)object).iterator();
        }
        return iterator2;
    }

    public boolean add(T t) {
        Object[] objectArray;
        if (this.size() == 0) {
            this.data = t;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual((Object)this.data, t)) {
                return false;
            }
            objectArray = new Object[]{this.data, t};
            this.data = objectArray;
        } else if (this.size() < 5) {
            Object[] objectArray2;
            SmartSet smartSet;
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            objectArray = (Object[])object;
            if (ArraysKt.contains((Object[])objectArray, t)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size() == 4) {
                Object[] objectArray3;
                Object[] objectArray4 = objectArray3 = SetsKt.linkedSetOf((Object[])Arrays.copyOf(objectArray, objectArray.length));
                SmartSet smartSet3 = smartSet2;
                boolean bl = false;
                objectArray4.add(t);
                smartSet = smartSet3;
                objectArray2 = objectArray3;
            } else {
                Object[] objectArray5;
                Object[] objectArray6 = Arrays.copyOf(objectArray, this.size() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray6, (String)"");
                Object[] objectArray7 = objectArray5 = objectArray6;
                SmartSet smartSet4 = smartSet2;
                boolean bl = false;
                objectArray7[objectArray7.length - 1] = t;
                smartSet = smartSet4;
                objectArray2 = objectArray5;
            }
            smartSet.data = objectArray2;
        } else {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            objectArray = TypeIntrinsics.asMutableSet((Object)object);
            if (!objectArray.add(t)) {
                return false;
            }
        }
        int n = this.size();
        this.setSize(n + 1);
        return true;
    }

    public void clear() {
        this.data = null;
        this.setSize(0);
    }

    public boolean contains(Object object) {
        boolean bl;
        if (this.size() == 0) {
            bl = false;
        } else if (this.size() == 1) {
            bl = Intrinsics.areEqual((Object)this.data, (Object)object);
        } else if (this.size() < 5) {
            Object object2 = this.data;
            Intrinsics.checkNotNull((Object)object2);
            bl = ArraysKt.contains((Object[])((Object[])object2), (Object)object);
        } else {
            Object object3 = this.data;
            Intrinsics.checkNotNull((Object)object3);
            bl = ((Set)object3).contains(object);
        }
        return bl;
    }

    @JvmStatic
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final Iterator<T> arrayIterator;

        public ArrayIterator(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            this.arrayIterator = ArrayIteratorKt.iterator((Object[])TArray);
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            return this.arrayIterator.next();
        }

        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        @JvmStatic
        public final <T> SmartSet<T> create(Collection<? extends T> collection) {
            SmartSet smartSet;
            Intrinsics.checkNotNullParameter(collection, (String)"");
            SmartSet smartSet2 = smartSet = new SmartSet(null);
            boolean bl = false;
            smartSet2.addAll(collection);
            return smartSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final T element;
        private boolean hasNext;

        public SingletonIterator(T t) {
            this.element = t;
            this.hasNext = true;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

