/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.core.ByteReadPacketKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.b.a.a;
import kotlinx.b.a.b;
import kotlinx.b.c;
import kotlinx.b.r;
import kotlinx.b.u;
import kotlinx.b.x;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a!\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001d\u0010\t\u001a\u00020\b*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a1\u0010\u0013\u001a\u00020\u0012*\u00060\u000bj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0015\u001a\u00020\u0012*\u00060\u000bj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a7\u0010\u0018\u001a\u00020\u000f*\u00060\u000bj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a3\u0010\u001a\u001a\u00020\u0012*\u00060\u000bj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0014\u001a1\u0010!\u001a\u00020\u000f*\u00060\u001bj\u0002`\u001c2\u0006\u0010\u000e\u001a\u00020\u001d2\n\u0010\u0017\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010 \u001a\u00020\u000f\u00a2\u0006\u0004\b!\u0010\"\"\u0019\u0010\u0003\u001a\u00020\u0002*\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u001d\u0010'\u001a\u00060\u0004j\u0002`\u0005*\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u001d\u0010'\u001a\u00060\u0004j\u0002`\u0005*\u00060\u001bj\u0002`\u001c8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010(*\n\u0010)\"\u00020\u00042\u00020\u0004*\n\u0010*\"\u00020\u000b2\u00020\u000b*\n\u0010+\"\u00020\u001b2\u00020\u001b*\n\u0010,\"\u00020\u00002\u00020\u0000\u00a8\u0006-"}, d2={"Lkotlin/text/Charsets;", "Lio/ktor/utils/io/charsets/Charsets;", "", "name", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "forName", "(Lkotlin/text/Charsets;Ljava/lang/String;)Ljava/nio/charset/Charset;", "", "isSupported", "(Lkotlin/text/Charsets;Ljava/lang/String;)Z", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "", "input", "", "fromIndex", "toIndex", "", "encodeToByteArray", "(Ljava/nio/charset/CharsetEncoder;Ljava/lang/CharSequence;II)[B", "encodeToByteArraySlow", "Lkotlinx/io/Sink;", "dst", "encodeImpl", "(Ljava/nio/charset/CharsetEncoder;Ljava/lang/CharSequence;IILkotlinx/io/Sink;)I", "encodeToByteArrayImpl", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "Lkotlinx/io/Source;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "decode", "(Ljava/nio/charset/CharsetDecoder;Lkotlinx/io/Source;Ljava/lang/Appendable;I)I", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "getCharset", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "charset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "Charset", "CharsetEncoder", "CharsetDecoder", "Charsets", "ktor-io"})
public final class CharsetJVMKt {
    public static final Charset forName(Charsets charsets, String string) {
        Intrinsics.checkNotNullParameter((Object)charsets, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Charset charset = Charset.forName(string);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"");
        return charset;
    }

    public static final boolean isSupported(Charsets charsets, String string) {
        Intrinsics.checkNotNullParameter((Object)charsets, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return Charset.isSupported(string);
    }

    public static final String getName(Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"");
        String string = charset.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public static final Charset getCharset(CharsetEncoder charsetEncoder) {
        Intrinsics.checkNotNullParameter((Object)charsetEncoder, (String)"");
        Charset charset = charsetEncoder.charset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"");
        return charset;
    }

    public static final byte[] encodeToByteArray(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charsetEncoder, (String)"");
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        if (charSequence instanceof String) {
            if (n2 == 0 && n3 == ((String)charSequence).length()) {
                byte[] byArray = ((String)charSequence).getBytes(charsetEncoder.charset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                return byArray;
            }
            String string = ((String)charSequence).substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            Intrinsics.checkNotNull((Object)string);
            byte[] byArray = string.getBytes(charsetEncoder.charset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow(charsetEncoder, charSequence, n2, n3);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n2, n3);
    }

    private static final byte[] encodeToByteArraySlow(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3) {
        byte[] byArray;
        Object object;
        boolean bl;
        byte[] byArray2;
        byte[] byArray3;
        ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(charSequence, n2, n3));
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            byArray2 = byArray3 = byteBuffer.array();
            bl = false;
            object = byArray2.length == byteBuffer.remaining() ? byArray3 : null;
        } else {
            object = null;
        }
        byte[] byArray4 = byArray = object;
        if (byArray == null) {
            byArray2 = byArray3 = new byte[byteBuffer.remaining()];
            bl = false;
            byteBuffer.get(byArray2);
            byArray4 = byArray3;
        }
        return byArray4;
    }

    public static final int encodeImpl(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3, r r2) {
        Intrinsics.checkNotNullParameter((Object)charsetEncoder, (String)"");
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)r2, (String)"");
        byte[] byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n2, n3);
        r.a((r)r2, (byte[])byArray, (int)0, (int)0, (int)6, null);
        return byArray.length;
    }

    public static final byte[] encodeToByteArrayImpl(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charsetEncoder, (String)"");
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        throw new IllegalStateException("Not needed on jvm".toString());
    }

    public static /* synthetic */ byte[] encodeToByteArrayImpl$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArrayImpl(charsetEncoder, charSequence, n2, n3);
    }

    public static final Charset getCharset(CharsetDecoder charsetDecoder) {
        Intrinsics.checkNotNullParameter((Object)charsetDecoder, (String)"");
        Charset charset = charsetDecoder.charset();
        Intrinsics.checkNotNull((Object)charset);
        return charset;
    }

    public static final int decode(CharsetDecoder charsetDecoder, u u2, Appendable appendable, int n2) {
        Intrinsics.checkNotNullParameter((Object)charsetDecoder, (String)"");
        Intrinsics.checkNotNullParameter((Object)u2, (String)"");
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"");
        if (Intrinsics.areEqual((Object)CharsetJVMKt.getCharset(charsetDecoder), (Object)Charsets.UTF_8)) {
            String string;
            String string2 = string = x.a((u)u2);
            boolean bl = false;
            appendable.append(string2);
            return string.length();
        }
        long l = ByteReadPacketKt.getRemaining(u2);
        appendable.append(b.a((a)c.a((u)u2), (Charset)CharsetJVMKt.getCharset(charsetDecoder)));
        return (int)l;
    }

    public static /* synthetic */ void Charset$annotations() {
    }
}

