/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.material.AnchoredDraggableKt;
import androidx.compose.material.AnchoredDraggableState;
import androidx.compose.material.BackdropScaffoldDefaults;
import androidx.compose.material.BackdropScaffoldKt;
import androidx.compose.material.BackdropValue;
import androidx.compose.material.SnackbarHostState;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverKt;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.unit.Density;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u0001:\u00011BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0007J\b\u0010,\u001a\u00020'H\u0002R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00062"}, d2={"Landroidx/compose/material/BackdropScaffoldState;", "", "initialValue", "Landroidx/compose/material/BackdropValue;", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "confirmValueChange", "Lkotlin/Function1;", "", "snackbarHostState", "Landroidx/compose/material/SnackbarHostState;", "<init>", "(Landroidx/compose/material/BackdropValue;Landroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function1;Landroidx/compose/material/SnackbarHostState;)V", "getConfirmValueChange", "()Lkotlin/jvm/functions/Function1;", "getSnackbarHostState", "()Landroidx/compose/material/SnackbarHostState;", "currentValue", "getCurrentValue", "()Landroidx/compose/material/BackdropValue;", "targetValue", "getTargetValue", "requireOffset", "isRevealed", "()Z", "isConcealed", "reveal", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "conceal", "progress", "from", "to", "anchoredDraggableState", "Landroidx/compose/material/AnchoredDraggableState;", "getAnchoredDraggableState$material", "()Landroidx/compose/material/AnchoredDraggableState;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity$material", "()Landroidx/compose/ui/unit/Density;", "setDensity$material", "(Landroidx/compose/ui/unit/Density;)V", "requireDensity", "nestedScrollConnection", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "getNestedScrollConnection$material", "()Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "Companion", "material"})
public final class BackdropScaffoldState {
    public static final Companion Companion = new Companion(null);
    private final Function1<BackdropValue, Boolean> confirmValueChange;
    private final SnackbarHostState snackbarHostState;
    private final AnchoredDraggableState<BackdropValue> anchoredDraggableState;
    private Density density;
    private final NestedScrollConnection nestedScrollConnection;
    public static final int $stable;

    @Deprecated(message="This constructor is deprecated. Density must be provided by the component. Please use the constructor that provides a [Density].", replaceWith=@ReplaceWith(expression="\n            BackdropScaffoldState(\n                initialValue = initialValue,\n                density = LocalDensity.current,\n                animationSpec = animationSpec,\n                confirmValueChange = confirmValueChange\n            )\n            ", imports={}))
    public BackdropScaffoldState(BackdropValue backdropValue, AnimationSpec<Float> animationSpec, Function1<? super BackdropValue, Boolean> function1, SnackbarHostState snackbarHostState) {
        Intrinsics.checkNotNullParameter((Object)((Object)backdropValue), (String)"");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter((Object)snackbarHostState, (String)"");
        this.confirmValueChange = function1;
        this.snackbarHostState = snackbarHostState;
        Function1<BackdropValue, Boolean> function12 = this.confirmValueChange;
        this.anchoredDraggableState = new AnchoredDraggableState<BackdropValue>(backdropValue, (Function1<? super Float, Float>)((Function1)arg_0 -> BackdropScaffoldState.anchoredDraggableState$lambda$2(this, arg_0)), (Function0<Float>)((Function0)() -> BackdropScaffoldState.anchoredDraggableState$lambda$4(this)), animationSpec, function12);
        this.nestedScrollConnection = BackdropScaffoldKt.ConsumeSwipeNestedScrollConnection(this.anchoredDraggableState, Orientation.Vertical);
    }

    public /* synthetic */ BackdropScaffoldState(BackdropValue backdropValue, AnimationSpec animationSpec, Function1 function1, SnackbarHostState snackbarHostState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            animationSpec = BackdropScaffoldDefaults.INSTANCE.getAnimationSpec();
        }
        if ((n & 4) != 0) {
            function1 = BackdropScaffoldState::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            snackbarHostState = new SnackbarHostState();
        }
        this(backdropValue, animationSpec, (Function1<? super BackdropValue, Boolean>)function1, snackbarHostState);
    }

    public final Function1<BackdropValue, Boolean> getConfirmValueChange() {
        return this.confirmValueChange;
    }

    public final SnackbarHostState getSnackbarHostState() {
        return this.snackbarHostState;
    }

    public final BackdropValue getCurrentValue() {
        return this.anchoredDraggableState.getCurrentValue();
    }

    public final BackdropValue getTargetValue() {
        return this.anchoredDraggableState.getTargetValue();
    }

    public final float requireOffset() {
        return this.anchoredDraggableState.requireOffset();
    }

    public final boolean isRevealed() {
        return this.anchoredDraggableState.getCurrentValue() == BackdropValue.Revealed;
    }

    public final boolean isConcealed() {
        return this.anchoredDraggableState.getCurrentValue() == BackdropValue.Concealed;
    }

    public final Object reveal(Continuation<? super Unit> continuation) {
        Object object = AnchoredDraggableKt.animateTo$default(this.anchoredDraggableState, (Object)BackdropValue.Revealed, 0.0f, continuation, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final Object conceal(Continuation<? super Unit> continuation) {
        Object object = AnchoredDraggableKt.animateTo$default(this.anchoredDraggableState, (Object)BackdropValue.Concealed, 0.0f, continuation, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final float progress(BackdropValue backdropValue, BackdropValue backdropValue2) {
        Intrinsics.checkNotNullParameter((Object)((Object)backdropValue), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)backdropValue2), (String)"");
        float f2 = this.anchoredDraggableState.getAnchors().positionOf(backdropValue);
        float f3 = this.anchoredDraggableState.getAnchors().positionOf(backdropValue2);
        float f4 = RangesKt.coerceIn((float)this.anchoredDraggableState.getOffset(), (float)Math.min(f2, f3), (float)Math.max(f2, f3));
        float f5 = (f4 - f2) / (f3 - f2);
        return Float.isNaN(f5) ? 1.0f : Math.abs(f5);
    }

    public final AnchoredDraggableState<BackdropValue> getAnchoredDraggableState$material() {
        return this.anchoredDraggableState;
    }

    public final Density getDensity$material() {
        return this.density;
    }

    public final void setDensity$material(Density density) {
        this.density = density;
    }

    private final Density requireDensity() {
        Density density = this.density;
        if (density == null) {
            boolean bl = false;
            String string = "The density on BackdropScaffoldState (" + this + ") was not set. Did you use BackdropScaffoldState with the BackdropScaffold composable?";
            throw new IllegalArgumentException(string.toString());
        }
        return density;
    }

    public final NestedScrollConnection getNestedScrollConnection$material() {
        return this.nestedScrollConnection;
    }

    private static final boolean _init_$lambda$0(BackdropValue backdropValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)backdropValue), (String)"");
        return true;
    }

    private static final float anchoredDraggableState$lambda$2(BackdropScaffoldState backdropScaffoldState, float f2) {
        Density density = backdropScaffoldState.requireDensity();
        boolean bl = false;
        return density.toPx-0680j_4(BackdropScaffoldKt.access$getPositionalThreshold$p());
    }

    private static final float anchoredDraggableState$lambda$4(BackdropScaffoldState backdropScaffoldState) {
        Density density = backdropScaffoldState.requireDensity();
        boolean bl = false;
        return density.toPx-0680j_4(BackdropScaffoldKt.access$getVelocityThreshold$p());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Landroidx/compose/material/BackdropScaffoldState$Companion;", "", "<init>", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/material/BackdropScaffoldState;", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "confirmStateChange", "Lkotlin/Function1;", "Landroidx/compose/material/BackdropValue;", "", "snackbarHostState", "Landroidx/compose/material/SnackbarHostState;", "density", "Landroidx/compose/ui/unit/Density;", "material"})
    public static final class Companion {
        private Companion() {
        }

        public final Saver<BackdropScaffoldState, ?> Saver(AnimationSpec<Float> animationSpec, Function1<? super BackdropValue, Boolean> function1, SnackbarHostState snackbarHostState, Density density) {
            Intrinsics.checkNotNullParameter(animationSpec, (String)"");
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Intrinsics.checkNotNullParameter((Object)snackbarHostState, (String)"");
            Intrinsics.checkNotNullParameter((Object)density, (String)"");
            return SaverKt.Saver(Companion::Saver$lambda$0, arg_0 -> Companion.Saver$lambda$1(density, animationSpec, function1, snackbarHostState, arg_0));
        }

        private static final BackdropValue Saver$lambda$0(SaverScope saverScope, BackdropScaffoldState backdropScaffoldState) {
            Intrinsics.checkNotNullParameter((Object)saverScope, (String)"");
            Intrinsics.checkNotNullParameter((Object)backdropScaffoldState, (String)"");
            return backdropScaffoldState.getAnchoredDraggableState$material().getCurrentValue();
        }

        private static final BackdropScaffoldState Saver$lambda$1(Density density, AnimationSpec animationSpec, Function1 function1, SnackbarHostState snackbarHostState, BackdropValue backdropValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)backdropValue), (String)"");
            return BackdropScaffoldKt.BackdropScaffoldState(backdropValue, density, (AnimationSpec<Float>)animationSpec, (Function1<? super BackdropValue, Boolean>)function1, snackbarHostState);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

