/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.packet.RosterPacket;

public class RosterGroup
extends Manager {
    private final String name;
    private final Set<RosterEntry> entries;

    RosterGroup(String string, XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.name = string;
        this.entries = new LinkedHashSet<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.name);
                item.addGroupName(string);
                rosterPacket.addRosterItem(item);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RosterEntry> getEntries() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return new ArrayList<RosterEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(i i2) {
        if (i2 == null) {
            return null;
        }
        i2 = i2.n();
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                if (!rosterEntry.getJid().a((CharSequence)i2)) continue;
                return rosterEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.contains((Object)rosterEntry);
        }
    }

    public boolean contains(i i2) {
        return this.getEntry(i2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (!this.entries.contains((Object)rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.addGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains((Object)rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            this.entries.remove((Object)rosterEntry);
            this.entries.add(rosterEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains((Object)rosterEntry)) {
                this.entries.remove((Object)rosterEntry);
            }
        }
    }
}

