/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.javax;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.h.b.a;
import org.h.d.e;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;

public class JavaxResolver
extends DNSResolver
implements SmackInitializer {
    private static JavaxResolver instance;
    private static DirContext dirContext;

    public static synchronized DNSResolver getInstance() {
        if (instance == null && JavaxResolver.isSupported()) {
            instance = new JavaxResolver();
        }
        return instance;
    }

    public static boolean isSupported() {
        return dirContext != null;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)JavaxResolver.getInstance());
    }

    public JavaxResolver() {
        super(false);
    }

    protected List<e> lookupSrvRecords0(a a2, List<RemoteConnectionEndpointLookupFailure> list, ConnectionConfiguration.DnssecMode dnssecMode) {
        Attribute attribute;
        Cloneable cloneable;
        try {
            cloneable = dirContext.getAttributes(a2.e, new String[]{"SRV"});
            attribute = cloneable.get("SRV");
            if (attribute == null) {
                return null;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            LOGGER.log(Level.FINEST, "No DNS SRV RR found for " + a2, nameNotFoundException);
            return null;
        }
        catch (NamingException namingException) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure dnsLookupFailure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(a2, (Exception)namingException);
            list.add((RemoteConnectionEndpointLookupFailure)dnsLookupFailure);
            return null;
        }
        cloneable = new ArrayList();
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                String string = (String)namingEnumeration.next();
                String[] stringArray = string.split(" ");
                int n = Integer.parseInt(stringArray[stringArray.length - 4]);
                int n2 = Integer.parseInt(stringArray[stringArray.length - 2]);
                int n3 = Integer.parseInt(stringArray[stringArray.length - 3]);
                String string2 = stringArray[stringArray.length - 1];
                if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                e e2 = new e(n, n3, n2, string2);
                cloneable.add(e2);
            }
        }
        catch (NamingException namingException) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure dnsLookupFailure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(a2, (Exception)namingException);
            list.add((RemoteConnectionEndpointLookupFailure)dnsLookupFailure);
        }
        return cloneable;
    }

    public List<Exception> initialize() {
        JavaxResolver.setup();
        return null;
    }

    static {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            dirContext = new InitialDirContext(hashtable);
        }
        catch (NamingException namingException) {
            LOGGER.log(Level.SEVERE, "Could not construct InitialDirContext", namingException);
        }
        JavaxResolver.setup();
    }
}

