/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.unix.IntegerUnixChannelOption;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.RawUnixChannelOption;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class KQueueChannelConfig
extends DefaultChannelConfig {
    private volatile boolean transportProvidesGuess;
    private volatile long maxBytesPerGatheringWrite = Limits.SSIZE_MAX;

    KQueueChannelConfig(AbstractKQueueChannel abstractKQueueChannel) {
        super((Channel)abstractKQueueChannel);
    }

    KQueueChannelConfig(AbstractKQueueChannel abstractKQueueChannel, RecvByteBufAllocator recvByteBufAllocator) {
        super((Channel)abstractKQueueChannel, recvByteBufAllocator);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS});
    }

    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS) {
            return (T)Boolean.valueOf(this.getRcvAllocTransportProvidesGuess());
        }
        try {
            if (channelOption instanceof IntegerUnixChannelOption) {
                IntegerUnixChannelOption integerUnixChannelOption = (IntegerUnixChannelOption)channelOption;
                return (T)Integer.valueOf(((AbstractKQueueChannel)this.channel).socket.getIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname()));
            }
            if (channelOption instanceof RawUnixChannelOption) {
                RawUnixChannelOption rawUnixChannelOption = (RawUnixChannelOption)channelOption;
                ByteBuffer byteBuffer = ByteBuffer.allocate(rawUnixChannelOption.length());
                ((AbstractKQueueChannel)this.channel).socket.getRawOpt(rawUnixChannelOption.level(), rawUnixChannelOption.optname(), byteBuffer);
                return (T)byteBuffer.flip();
            }
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
        return (T)super.getOption(channelOption);
    }

    public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
        this.validate(channelOption, t);
        if (channelOption != KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS) {
            try {
                if (channelOption instanceof IntegerUnixChannelOption) {
                    IntegerUnixChannelOption integerUnixChannelOption = (IntegerUnixChannelOption)channelOption;
                    ((AbstractKQueueChannel)this.channel).socket.setIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), (Integer)t);
                    return true;
                }
                if (channelOption instanceof RawUnixChannelOption) {
                    RawUnixChannelOption rawUnixChannelOption = (RawUnixChannelOption)channelOption;
                    ((AbstractKQueueChannel)this.channel).socket.setRawOpt(rawUnixChannelOption.level(), rawUnixChannelOption.optname(), (ByteBuffer)t);
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new ChannelException((Throwable)iOException);
            }
            return super.setOption(channelOption, t);
        }
        this.setRcvAllocTransportProvidesGuess((Boolean)t);
        return true;
    }

    public KQueueChannelConfig setRcvAllocTransportProvidesGuess(boolean bl) {
        this.transportProvidesGuess = bl;
        return this;
    }

    public boolean getRcvAllocTransportProvidesGuess() {
        return this.transportProvidesGuess;
    }

    public KQueueChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    public KQueueChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    public KQueueChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    public KQueueChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        if (!(recvByteBufAllocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
            throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
        }
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    public KQueueChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    public KQueueChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public KQueueChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    protected final void autoReadCleared() {
        ((AbstractKQueueChannel)this.channel).clearReadFilter();
    }

    final void setMaxBytesPerGatheringWrite(long l) {
        this.maxBytesPerGatheringWrite = Math.min(Limits.SSIZE_MAX, l);
    }

    final long getMaxBytesPerGatheringWrite() {
        return this.maxBytesPerGatheringWrite;
    }
}

