/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueDatagramChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainDatagramChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainDatagramPacket;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class KQueueDomainDatagramChannel
extends AbstractKQueueDatagramChannel
implements DomainDatagramChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final KQueueDomainDatagramChannelConfig config = new KQueueDomainDatagramChannelConfig(this);

    public KQueueDomainDatagramChannel() {
        this(BsdSocket.newSocketDomainDgram(), false);
    }

    public KQueueDomainDatagramChannel(int n) {
        this(new BsdSocket(n), true);
    }

    private KQueueDomainDatagramChannel(BsdSocket bsdSocket, boolean bl) {
        super(null, bsdSocket, bl);
    }

    @Override
    public KQueueDomainDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        super.doBind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
        this.active = true;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.active = false;
        this.connected = false;
        this.local = null;
        this.remote = null;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            if (socketAddress2 != null) {
                this.local = (DomainSocketAddress)socketAddress2;
            }
            this.remote = (DomainSocketAddress)socketAddress;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected boolean doWriteMessage(Object object) {
        long l;
        DomainSocketAddress domainSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)addressedEnvelope.content();
            domainSocketAddress = (DomainSocketAddress)addressedEnvelope.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            domainSocketAddress = null;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return true;
        }
        if (byteBuf.hasMemoryAddress()) {
            long l2 = byteBuf.memoryAddress();
            l = domainSocketAddress == null ? (long)this.socket.writeAddress(l2, byteBuf.readerIndex(), byteBuf.writerIndex()) : (long)this.socket.sendToAddressDomainSocket(l2, byteBuf.readerIndex(), byteBuf.writerIndex(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else if (byteBuf.nioBufferCount() > 1) {
            IovArray iovArray = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            iovArray.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
            int n2 = iovArray.count();
            assert (n2 != 0);
            l = domainSocketAddress == null ? this.socket.writevAddresses(iovArray.memoryAddress(0), n2) : (long)this.socket.sendToAddressesDomainSocket(iovArray.memoryAddress(0), n2, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes());
            l = domainSocketAddress == null ? (long)this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit()) : (long)this.socket.sendToDomainSocket(byteBuffer, byteBuffer.position(), byteBuffer.limit(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        }
        return l > 0L;
    }

    protected Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DomainDatagramPacket) {
            DomainDatagramPacket domainDatagramPacket = (DomainDatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)domainDatagramPacket.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DomainDatagramPacket(this.newDirectBuffer(domainDatagramPacket, byteBuf), (DomainSocketAddress)domainDatagramPacket.recipient()) : object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof DomainSocketAddress)) {
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DefaultAddressedEnvelope((Object)this.newDirectBuffer(addressedEnvelope, byteBuf), (SocketAddress)((DomainSocketAddress)addressedEnvelope.recipient())) : addressedEnvelope;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDomainDatagramChannelUnsafe();
    }

    public PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class KQueueDomainDatagramChannelUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        KQueueDomainDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            assert (KQueueDomainDatagramChannel.this.eventLoop().inEventLoop());
            KQueueDomainDatagramChannelConfig kQueueDomainDatagramChannelConfig = KQueueDomainDatagramChannel.this.config();
            if (KQueueDomainDatagramChannel.this.shouldBreakReadReady((ChannelConfig)kQueueDomainDatagramChannelConfig)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline channelPipeline = KQueueDomainDatagramChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = kQueueDomainDatagramChannelConfig.getAllocator();
            kQueueRecvByteAllocatorHandle.reset((ChannelConfig)kQueueDomainDatagramChannelConfig);
            this.readReadyBefore();
            Throwable throwable = null;
            try {
                ByteBuf byteBuf = null;
                try {
                    boolean bl = KQueueDomainDatagramChannel.this.isConnected();
                    do {
                        DomainDatagramPacket domainDatagramPacket;
                        byteBuf = kQueueRecvByteAllocatorHandle.allocate(byteBufAllocator);
                        kQueueRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                        if (bl) {
                            kQueueRecvByteAllocatorHandle.lastBytesRead(KQueueDomainDatagramChannel.this.doReadBytes(byteBuf));
                            if (kQueueRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                                byteBuf.release();
                                break;
                            }
                            domainDatagramPacket = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                        } else {
                            ByteBuffer byteBuffer;
                            DomainDatagramSocketAddress domainDatagramSocketAddress;
                            if (byteBuf.hasMemoryAddress()) {
                                domainDatagramSocketAddress = KQueueDomainDatagramChannel.this.socket.recvFromAddressDomainSocket(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                            } else {
                                byteBuffer = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                                domainDatagramSocketAddress = KQueueDomainDatagramChannel.this.socket.recvFromDomainSocket(byteBuffer, byteBuffer.position(), byteBuffer.limit());
                            }
                            if (domainDatagramSocketAddress == null) {
                                kQueueRecvByteAllocatorHandle.lastBytesRead(-1);
                                byteBuf.release();
                                break;
                            }
                            byteBuffer = domainDatagramSocketAddress.localAddress();
                            if (byteBuffer == null) {
                                byteBuffer = (DomainSocketAddress)this.localAddress();
                            }
                            kQueueRecvByteAllocatorHandle.lastBytesRead(domainDatagramSocketAddress.receivedAmount());
                            byteBuf.writerIndex(byteBuf.writerIndex() + kQueueRecvByteAllocatorHandle.lastBytesRead());
                            domainDatagramPacket = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)byteBuffer, (DomainSocketAddress)domainDatagramSocketAddress);
                        }
                        kQueueRecvByteAllocatorHandle.incMessagesRead(1);
                        this.readPending = false;
                        channelPipeline.fireChannelRead((Object)domainDatagramPacket);
                        byteBuf = null;
                    } while (kQueueRecvByteAllocatorHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                }
                catch (Throwable throwable2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throwable = throwable2;
                }
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
            }
            finally {
                this.readReadyFinally((ChannelConfig)kQueueDomainDatagramChannelConfig);
            }
        }
    }
}

