/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Name(value={"long"})
@Properties(inherit={javacpp.class})
public class CLongPointer
extends Pointer {
    private static final Logger logger;

    public CLongPointer(long ... lArray) {
        this((long)lArray.length);
        this.put(lArray);
    }

    public CLongPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new CLongPointer(" + l + "): totalBytes = " + CLongPointer.formatBytes(CLongPointer.totalBytes()) + ", physicalBytes = " + CLongPointer.formatBytes(CLongPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public CLongPointer() {
    }

    public CLongPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public CLongPointer position(long l) {
        return (CLongPointer)super.position(l);
    }

    public CLongPointer limit(long l) {
        return (CLongPointer)super.limit(l);
    }

    public CLongPointer capacity(long l) {
        return (CLongPointer)super.capacity(l);
    }

    public CLongPointer getPointer(long l) {
        return (CLongPointer)new CLongPointer(this).offsetAddress(l);
    }

    public long get() {
        return this.get(0L);
    }

    @Cast(value={"long"})
    public native long get(long var1);

    public CLongPointer put(long l) {
        return this.put(0L, l);
    }

    public native CLongPointer put(long var1, long var3);

    public CLongPointer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public CLongPointer put(long ... lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public CLongPointer get(long[] lArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            lArray[i] = this.get(i);
        }
        return this;
    }

    public CLongPointer put(long[] lArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.put((long)i, lArray[i]);
        }
        return this;
    }

    static {
        block2: {
            logger = Logger.create(CLongPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load CLongPointer: " + throwable);
            }
        }
    }
}

