/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.CharBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class CharPointer
extends Pointer {
    private static final Logger logger;

    public CharPointer(String string) {
        this(string.toCharArray().length + 1);
        this.putString(string);
    }

    public CharPointer(char ... cArray) {
        this(cArray.length);
        this.put(cArray);
    }

    public CharPointer(CharBuffer charBuffer) {
        super(charBuffer);
        if (charBuffer != null && !charBuffer.isDirect() && charBuffer.hasArray()) {
            char[] cArray = charBuffer.array();
            this.allocateArray(cArray.length - charBuffer.arrayOffset());
            this.put(cArray, charBuffer.arrayOffset(), cArray.length - charBuffer.arrayOffset());
            this.position(charBuffer.position());
            this.limit(charBuffer.limit());
        }
    }

    public CharPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new CharPointer(" + l + "): totalBytes = " + CharPointer.formatBytes(CharPointer.totalBytes()) + ", physicalBytes = " + CharPointer.formatBytes(CharPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public CharPointer() {
    }

    public CharPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public CharPointer position(long l) {
        return (CharPointer)super.position(l);
    }

    public CharPointer limit(long l) {
        return (CharPointer)super.limit(l);
    }

    public CharPointer capacity(long l) {
        return (CharPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == CharPointer.class ? 2 : super.sizeof();
    }

    public CharPointer getPointer(long l) {
        return (CharPointer)new CharPointer(this).offsetAddress(l);
    }

    public char[] getStringChars() {
        char[] cArray;
        if (this.limit > this.position) {
            char[] cArray2 = new char[(int)Math.min(this.limit - this.position, Integer.MAX_VALUE)];
            this.get(cArray2);
            return cArray2;
        }
        char[] cArray3 = new char[16];
        int n = 0;
        while ((cArray3[n] = this.get(n)) != '\u0000') {
            if (++n < cArray3.length) continue;
            cArray = new char[2 * cArray3.length];
            System.arraycopy(cArray3, 0, cArray, 0, cArray3.length);
            cArray3 = cArray;
        }
        cArray = new char[n];
        System.arraycopy(cArray3, 0, cArray, 0, n);
        return cArray;
    }

    public String getString() {
        return new String(this.getStringChars());
    }

    public CharPointer putString(String string) {
        char[] cArray = string.toCharArray();
        return this.put(cArray).put(cArray.length, '\u0000').limit(cArray.length);
    }

    public char get() {
        return this.get(0L);
    }

    public native char get(long var1);

    public CharPointer put(char c) {
        return this.put(0L, c);
    }

    public native CharPointer put(long var1, char var3);

    public CharPointer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharPointer put(char ... cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public native CharPointer get(char[] var1, int var2, int var3);

    public native CharPointer put(char[] var1, int var2, int var3);

    @Override
    public final CharBuffer asBuffer() {
        return this.asByteBuffer().asCharBuffer();
    }

    static {
        block2: {
            logger = Logger.create(CharPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load CharPointer: " + throwable);
            }
        }
    }
}

