/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class DoublePointer
extends Pointer {
    private static final Logger logger;

    public DoublePointer(double ... dArray) {
        this(dArray.length);
        this.put(dArray);
    }

    public DoublePointer(DoubleBuffer doubleBuffer) {
        super(doubleBuffer);
        if (doubleBuffer != null && !doubleBuffer.isDirect() && doubleBuffer.hasArray()) {
            double[] dArray = doubleBuffer.array();
            this.allocateArray(dArray.length - doubleBuffer.arrayOffset());
            this.put(dArray, doubleBuffer.arrayOffset(), dArray.length - doubleBuffer.arrayOffset());
            this.position(doubleBuffer.position());
            this.limit(doubleBuffer.limit());
        }
    }

    public DoublePointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new DoublePointer(" + l + "): totalBytes = " + DoublePointer.formatBytes(DoublePointer.totalBytes()) + ", physicalBytes = " + DoublePointer.formatBytes(DoublePointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public DoublePointer() {
    }

    public DoublePointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public DoublePointer position(long l) {
        return (DoublePointer)super.position(l);
    }

    public DoublePointer limit(long l) {
        return (DoublePointer)super.limit(l);
    }

    public DoublePointer capacity(long l) {
        return (DoublePointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == DoublePointer.class ? 8 : super.sizeof();
    }

    public DoublePointer getPointer(long l) {
        return (DoublePointer)new DoublePointer(this).offsetAddress(l);
    }

    public double get() {
        return this.get(0L);
    }

    public native double get(long var1);

    public DoublePointer put(double d) {
        return this.put(0L, d);
    }

    public native DoublePointer put(long var1, double var3);

    public DoublePointer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public DoublePointer put(double ... dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    public native DoublePointer get(double[] var1, int var2, int var3);

    public native DoublePointer put(double[] var1, int var2, int var3);

    @Override
    public final DoubleBuffer asBuffer() {
        return this.asByteBuffer().asDoubleBuffer();
    }

    static {
        block2: {
            logger = Logger.create(DoublePointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load DoublePointer: " + throwable);
            }
        }
    }
}

