/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.IntBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class IntPointer
extends Pointer {
    private static final Logger logger;

    public IntPointer(String string) {
        this((long)(string.length() + 1));
        this.putString(string);
    }

    public IntPointer(int ... nArray) {
        this((long)nArray.length);
        this.put(nArray);
    }

    public IntPointer(IntBuffer intBuffer) {
        super(intBuffer);
        if (intBuffer != null && !intBuffer.isDirect() && intBuffer.hasArray()) {
            int[] nArray = intBuffer.array();
            this.allocateArray(nArray.length - intBuffer.arrayOffset());
            this.put(nArray, intBuffer.arrayOffset(), nArray.length - intBuffer.arrayOffset());
            this.position(intBuffer.position());
            this.limit(intBuffer.limit());
        }
    }

    public IntPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new IntPointer(" + l + "): totalBytes = " + IntPointer.formatBytes(IntPointer.totalBytes()) + ", physicalBytes = " + IntPointer.formatBytes(IntPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public IntPointer() {
    }

    public IntPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public IntPointer position(long l) {
        return (IntPointer)super.position(l);
    }

    public IntPointer limit(long l) {
        return (IntPointer)super.limit(l);
    }

    public IntPointer capacity(long l) {
        return (IntPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == IntPointer.class ? 4 : super.sizeof();
    }

    public IntPointer getPointer(long l) {
        return (IntPointer)new IntPointer(this).offsetAddress(l);
    }

    public int[] getStringCodePoints() {
        int[] nArray;
        if (this.limit > this.position) {
            int[] nArray2 = new int[(int)Math.min(this.limit - this.position, Integer.MAX_VALUE)];
            this.get(nArray2);
            return nArray2;
        }
        int[] nArray3 = new int[16];
        int n = 0;
        while ((nArray3[n] = this.get(n)) != 0) {
            if (++n < nArray3.length) continue;
            nArray = new int[2 * nArray3.length];
            System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
            nArray3 = nArray;
        }
        nArray = new int[n];
        System.arraycopy(nArray3, 0, nArray, 0, n);
        return nArray;
    }

    public String getString() {
        int[] nArray = this.getStringCodePoints();
        return new String(nArray, 0, nArray.length);
    }

    public IntPointer putString(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.codePointAt(i);
        }
        return this.put(nArray).put((long)nArray.length, 0).limit(nArray.length);
    }

    public int get() {
        return this.get(0L);
    }

    public native int get(long var1);

    public IntPointer put(int n) {
        return this.put(0L, n);
    }

    public native IntPointer put(long var1, int var3);

    public IntPointer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntPointer put(int ... nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public native IntPointer get(int[] var1, int var2, int var3);

    public native IntPointer put(int[] var1, int var2, int var3);

    @Override
    public final IntBuffer asBuffer() {
        return this.asByteBuffer().asIntBuffer();
    }

    static {
        block2: {
            logger = Logger.create(IntPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load IntPointer: " + throwable);
            }
        }
    }
}

