/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.ShortBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class ShortPointer
extends Pointer {
    private static final Logger logger;

    public ShortPointer(short ... sArray) {
        this(sArray.length);
        this.put(sArray);
    }

    public ShortPointer(ShortBuffer shortBuffer) {
        super(shortBuffer);
        if (shortBuffer != null && !shortBuffer.isDirect() && shortBuffer.hasArray()) {
            short[] sArray = shortBuffer.array();
            this.allocateArray(sArray.length - shortBuffer.arrayOffset());
            this.put(sArray, shortBuffer.arrayOffset(), sArray.length - shortBuffer.arrayOffset());
            this.position(shortBuffer.position());
            this.limit(shortBuffer.limit());
        }
    }

    public ShortPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new ShortPointer(" + l + "): totalBytes = " + ShortPointer.formatBytes(ShortPointer.totalBytes()) + ", physicalBytes = " + ShortPointer.formatBytes(ShortPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public ShortPointer() {
    }

    public ShortPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public ShortPointer position(long l) {
        return (ShortPointer)super.position(l);
    }

    public ShortPointer limit(long l) {
        return (ShortPointer)super.limit(l);
    }

    public ShortPointer capacity(long l) {
        return (ShortPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == ShortPointer.class ? 2 : super.sizeof();
    }

    public ShortPointer getPointer(long l) {
        return (ShortPointer)new ShortPointer(this).offsetAddress(l);
    }

    public short get() {
        return this.get(0L);
    }

    public native short get(long var1);

    public ShortPointer put(short s) {
        return this.put(0L, s);
    }

    public native ShortPointer put(long var1, short var3);

    public ShortPointer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortPointer put(short ... sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public native ShortPointer get(short[] var1, int var2, int var3);

    public native ShortPointer put(short[] var1, int var2, int var3);

    @Override
    public final ShortBuffer asBuffer() {
        return this.asByteBuffer().asShortBuffer();
    }

    static {
        block2: {
            logger = Logger.create(ShortPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load ShortPointer: " + throwable);
            }
        }
    }
}

