/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;

public class ByteArrayIndexer
extends ByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ByteBuffer buffer;
    protected byte[] array;

    public ByteArrayIndexer(byte[] byArray) {
        this(byArray, Index.create((long)byArray.length));
    }

    public ByteArrayIndexer(byte[] byArray, long ... lArray) {
        this(byArray, Index.create(lArray));
    }

    public ByteArrayIndexer(byte[] byArray, long[] lArray, long[] lArray2) {
        this(byArray, Index.create(lArray, lArray2));
    }

    public ByteArrayIndexer(byte[] byArray, Index index) {
        super(index);
        this.array = byArray;
    }

    public byte[] array() {
        return this.array;
    }

    public ByteIndexer reindex(Index index) {
        return new ByteArrayIndexer(this.array, index);
    }

    @Override
    public byte get(long l) {
        return this.array[(int)this.index(l)];
    }

    @Override
    public ByteIndexer get(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.array[(int)this.index(l) + i];
        }
        return this;
    }

    @Override
    public byte get(long l, long l2) {
        return this.array[(int)this.index(l, l2)];
    }

    @Override
    public ByteIndexer get(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.array[(int)this.index(l, l2) + i];
        }
        return this;
    }

    @Override
    public byte get(long l, long l2, long l3) {
        return this.array[(int)this.index(l, l2, l3)];
    }

    @Override
    public byte get(long ... lArray) {
        return this.array[(int)this.index(lArray)];
    }

    @Override
    public ByteIndexer get(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.array[(int)this.index(lArray) + i];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, byte by) {
        this.array[(int)this.index((long)l)] = by;
        return this;
    }

    @Override
    public ByteIndexer put(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.array[(int)this.index((long)l) + i] = byArray[n + i];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte by) {
        this.array[(int)this.index((long)l, (long)l2)] = by;
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.array[(int)this.index((long)l, (long)l2) + i] = byArray[n + i];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long l, long l2, long l3, byte by) {
        this.array[(int)this.index((long)l, (long)l2, (long)l3)] = by;
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte by) {
        this.array[(int)this.index((long[])lArray)] = by;
        return this;
    }

    @Override
    public ByteIndexer put(long[] lArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.array[(int)this.index((long[])lArray) + i] = byArray[n + i];
        }
        return this;
    }

    ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(this.array).order(ByteOrder.nativeOrder());
        }
        return this.buffer;
    }

    @Override
    public byte getByte(long l) {
        return this.array[(int)l];
    }

    @Override
    public ByteIndexer putByte(long l, byte by) {
        this.array[(int)l] = by;
        return this;
    }

    @Override
    public short getShort(long l) {
        if (RAW != null) {
            return RAW.getShort(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 1));
        }
        return this.getBuffer().getShort((int)l);
    }

    @Override
    public ByteIndexer putShort(long l, short s) {
        if (RAW != null) {
            RAW.putShort(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 1), s);
        } else {
            this.getBuffer().putShort((int)l, s);
        }
        return this;
    }

    @Override
    public int getInt(long l) {
        if (RAW != null) {
            return RAW.getInt(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 3));
        }
        return this.getBuffer().getInt((int)l);
    }

    @Override
    public ByteIndexer putInt(long l, int n) {
        if (RAW != null) {
            RAW.putInt(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 3), n);
        } else {
            this.getBuffer().putInt((int)l, n);
        }
        return this;
    }

    @Override
    public long getLong(long l) {
        if (RAW != null) {
            return RAW.getLong(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 7));
        }
        return this.getBuffer().getLong((int)l);
    }

    @Override
    public ByteIndexer putLong(long l, long l2) {
        if (RAW != null) {
            RAW.putLong(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 7), l2);
        } else {
            this.getBuffer().putLong((int)l, l2);
        }
        return this;
    }

    @Override
    public float getFloat(long l) {
        if (RAW != null) {
            return RAW.getFloat(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 3));
        }
        return this.getBuffer().getFloat((int)l);
    }

    @Override
    public ByteIndexer putFloat(long l, float f) {
        if (RAW != null) {
            RAW.putFloat(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 3), f);
        } else {
            this.getBuffer().putFloat((int)l, f);
        }
        return this;
    }

    @Override
    public double getDouble(long l) {
        if (RAW != null) {
            return RAW.getDouble(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 7));
        }
        return this.getBuffer().getDouble((int)l);
    }

    @Override
    public ByteIndexer putDouble(long l, double d) {
        if (RAW != null) {
            RAW.putDouble(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 7), d);
        } else {
            this.getBuffer().putDouble((int)l, d);
        }
        return this;
    }

    @Override
    public char getChar(long l) {
        if (RAW != null) {
            return RAW.getChar(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 1));
        }
        return this.getBuffer().getChar((int)l);
    }

    @Override
    public ByteIndexer putChar(long l, char c) {
        if (RAW != null) {
            RAW.putChar(this.array, ByteArrayIndexer.checkIndex(l, this.array.length - 1), c);
        } else {
            this.getBuffer().putChar((int)l, c);
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

