/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.ByteArrayIndexer;
import org.bytedeco.javacpp.indexer.ByteBufferIndexer;
import org.bytedeco.javacpp.indexer.ByteRawIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.ULongIndexer;

public abstract class ByteIndexer
extends Indexer {
    public static final int VALUE_BYTES = 1;

    protected ByteIndexer(Index index) {
        super(index);
    }

    protected ByteIndexer(long[] lArray, long[] lArray2) {
        super(lArray, lArray2);
    }

    public static ByteIndexer create(byte[] byArray) {
        return new ByteArrayIndexer(byArray);
    }

    public static ByteIndexer create(ByteBuffer byteBuffer) {
        return new ByteBufferIndexer(byteBuffer);
    }

    public static ByteIndexer create(BytePointer bytePointer) {
        return new ByteRawIndexer(bytePointer);
    }

    public static ByteIndexer create(byte[] byArray, Index index) {
        return new ByteArrayIndexer(byArray, index);
    }

    public static ByteIndexer create(ByteBuffer byteBuffer, Index index) {
        return new ByteBufferIndexer(byteBuffer, index);
    }

    public static ByteIndexer create(BytePointer bytePointer, Index index) {
        return new ByteRawIndexer(bytePointer, index);
    }

    public static ByteIndexer create(byte[] byArray, long ... lArray) {
        return new ByteArrayIndexer(byArray, lArray);
    }

    public static ByteIndexer create(ByteBuffer byteBuffer, long ... lArray) {
        return new ByteBufferIndexer(byteBuffer, lArray);
    }

    public static ByteIndexer create(BytePointer bytePointer, long ... lArray) {
        return new ByteRawIndexer(bytePointer, lArray);
    }

    public static ByteIndexer create(byte[] byArray, long[] lArray, long[] lArray2) {
        return new ByteArrayIndexer(byArray, lArray, lArray2);
    }

    public static ByteIndexer create(ByteBuffer byteBuffer, long[] lArray, long[] lArray2) {
        return new ByteBufferIndexer(byteBuffer, lArray, lArray2);
    }

    public static ByteIndexer create(BytePointer bytePointer, long[] lArray, long[] lArray2) {
        return new ByteRawIndexer(bytePointer, lArray, lArray2);
    }

    public static ByteIndexer create(BytePointer bytePointer, long[] lArray, long[] lArray2, boolean bl) {
        return ByteIndexer.create(bytePointer, Index.create(lArray, lArray2), bl);
    }

    public static ByteIndexer create(final BytePointer bytePointer, Index index, boolean bl) {
        if (bl) {
            return Raw.getInstance() != null ? new ByteRawIndexer(bytePointer, index) : new ByteBufferIndexer(bytePointer.asBuffer(), index);
        }
        final long l = bytePointer.position();
        byte[] byArray = new byte[(int)Math.min(bytePointer.limit() - l, Integer.MAX_VALUE)];
        bytePointer.get(byArray);
        return new ByteArrayIndexer(byArray, index){

            @Override
            public void release() {
                bytePointer.position(l).put(this.array);
                super.release();
            }
        };
    }

    public abstract byte get(long var1);

    public ByteIndexer get(long l, byte[] byArray) {
        return this.get(l, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer get(long var1, byte[] var3, int var4, int var5);

    public abstract byte get(long var1, long var3);

    public ByteIndexer get(long l, long l2, byte[] byArray) {
        return this.get(l, l2, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer get(long var1, long var3, byte[] var5, int var6, int var7);

    public abstract byte get(long var1, long var3, long var5);

    public abstract byte get(long ... var1);

    public ByteIndexer get(long[] lArray, byte[] byArray) {
        return this.get(lArray, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer get(long[] var1, byte[] var2, int var3, int var4);

    public abstract ByteIndexer put(long var1, byte var3);

    public ByteIndexer put(long l, byte ... byArray) {
        return this.put(l, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer put(long var1, byte[] var3, int var4, int var5);

    public abstract ByteIndexer put(long var1, long var3, byte var5);

    public ByteIndexer put(long l, long l2, byte ... byArray) {
        return this.put(l, l2, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer put(long var1, long var3, byte[] var5, int var6, int var7);

    public abstract ByteIndexer put(long var1, long var3, long var5, byte var7);

    public abstract ByteIndexer put(long[] var1, byte var2);

    public ByteIndexer put(long[] lArray, byte ... byArray) {
        return this.put(lArray, byArray, 0, byArray.length);
    }

    public abstract ByteIndexer put(long[] var1, byte[] var2, int var3, int var4);

    public abstract byte getByte(long var1);

    public abstract ByteIndexer putByte(long var1, byte var3);

    public abstract short getShort(long var1);

    public abstract ByteIndexer putShort(long var1, short var3);

    public abstract int getInt(long var1);

    public abstract ByteIndexer putInt(long var1, int var3);

    public abstract long getLong(long var1);

    public abstract ByteIndexer putLong(long var1, long var3);

    public abstract float getFloat(long var1);

    public abstract ByteIndexer putFloat(long var1, float var3);

    public abstract double getDouble(long var1);

    public abstract ByteIndexer putDouble(long var1, double var3);

    public abstract char getChar(long var1);

    public abstract ByteIndexer putChar(long var1, char var3);

    public int getUByte(long l) {
        return this.getByte(l) & 0xFF;
    }

    public ByteIndexer putUByte(long l, int n) {
        return this.putByte(l, (byte)n);
    }

    public int getUShort(long l) {
        return this.getShort(l) & 0xFFFF;
    }

    public ByteIndexer putUShort(long l, int n) {
        return this.putShort(l, (short)n);
    }

    public long getUInt(long l) {
        return (long)this.getInt(l) & 0xFFFFFFFFL;
    }

    public ByteIndexer putUInt(long l, long l2) {
        return this.putInt(l, (int)l2);
    }

    public BigInteger getULong(long l) {
        return ULongIndexer.toBigInteger(this.getLong(l));
    }

    public ByteIndexer putULong(long l, BigInteger bigInteger) {
        return this.putLong(l, ULongIndexer.fromBigInteger(bigInteger));
    }

    public float getHalf(long l) {
        return HalfIndexer.toFloat(this.getShort(l));
    }

    public ByteIndexer putHalf(long l, float f) {
        return this.putShort(l, (short)HalfIndexer.fromFloat(f));
    }

    public float getBfloat16(long l) {
        return Bfloat16Indexer.toFloat(this.getShort(l));
    }

    public ByteIndexer putBfloat16(long l, float f) {
        return this.putShort(l, (short)Bfloat16Indexer.fromFloat(f));
    }

    public boolean getBoolean(long l) {
        return this.get(l) != 0;
    }

    public ByteIndexer putBoolean(long l, boolean bl) {
        return this.put(l, bl ? (byte)1 : 0);
    }

    @Override
    public double getDouble(long ... lArray) {
        return this.get(lArray);
    }

    @Override
    public ByteIndexer putDouble(long[] lArray, double d) {
        return this.put(lArray, (byte)d);
    }
}

