/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class IntRawIndexer
extends IntIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected IntPointer pointer;
    final long base;
    final long size;

    public IntRawIndexer(IntPointer intPointer) {
        this(intPointer, Index.create(intPointer.limit() - intPointer.position()));
    }

    public IntRawIndexer(IntPointer intPointer, long ... lArray) {
        this(intPointer, Index.create(lArray));
    }

    public IntRawIndexer(IntPointer intPointer, long[] lArray, long[] lArray2) {
        this(intPointer, Index.create(lArray, lArray2));
    }

    public IntRawIndexer(IntPointer intPointer, Index index) {
        super(index);
        this.pointer = intPointer;
        this.base = intPointer.address() + intPointer.position() * 4L;
        this.size = intPointer.limit() - intPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public IntIndexer reindex(Index index) {
        return new IntRawIndexer(this.pointer, index);
    }

    public int getRaw(long l) {
        return RAW.getInt(this.base + IntRawIndexer.checkIndex(l, this.size) * 4L);
    }

    @Override
    public int get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public IntIndexer get(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public int get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public IntIndexer get(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public int get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public int get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public IntIndexer get(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public IntIndexer putRaw(long l, int n) {
        RAW.putInt(this.base + IntRawIndexer.checkIndex(l, this.size) * 4L, n);
        return this;
    }

    @Override
    public IntIndexer put(long l, int n) {
        return this.putRaw(this.index(l), n);
    }

    @Override
    public IntIndexer put(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public IntIndexer put(long l, long l2, int n) {
        this.putRaw(this.index(l, l2), n);
        return this;
    }

    @Override
    public IntIndexer put(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public IntIndexer put(long l, long l2, long l3, int n) {
        this.putRaw(this.index(l, l2, l3), n);
        return this;
    }

    @Override
    public IntIndexer put(long[] lArray, int n) {
        this.putRaw(this.index(lArray), n);
        return this;
    }

    @Override
    public IntIndexer put(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

