/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UByteIndexer;

public class UByteRawIndexer
extends UByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BytePointer pointer;
    final long base;
    final long size;

    public UByteRawIndexer(BytePointer bytePointer) {
        this(bytePointer, Index.create(bytePointer.limit() - bytePointer.position()));
    }

    public UByteRawIndexer(BytePointer bytePointer, long ... lArray) {
        this(bytePointer, lArray, UByteRawIndexer.strides(lArray));
    }

    public UByteRawIndexer(BytePointer bytePointer, long[] lArray, long[] lArray2) {
        this(bytePointer, Index.create(lArray, lArray2));
    }

    public UByteRawIndexer(BytePointer bytePointer, Index index) {
        super(index);
        this.pointer = bytePointer;
        this.base = bytePointer.address() + bytePointer.position();
        this.size = bytePointer.limit() - bytePointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public UByteIndexer reindex(Index index) {
        return new UByteRawIndexer(this.pointer, index);
    }

    public int getRaw(long l) {
        return RAW.getByte(this.base + UByteRawIndexer.checkIndex(l, this.size)) & 0xFF;
    }

    @Override
    public int get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public UByteIndexer get(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l) + (long)i) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long l, long l2) {
        return this.getRaw(this.index(l, l2)) & 0xFF;
    }

    @Override
    public UByteIndexer get(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(l, l2) + (long)i) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3)) & 0xFF;
    }

    @Override
    public int get(long ... lArray) {
        return this.getRaw(this.index(lArray)) & 0xFF;
    }

    @Override
    public UByteIndexer get(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.getRaw(this.index(lArray) + (long)i) & 0xFF;
        }
        return this;
    }

    public UByteIndexer putRaw(long l, int n) {
        RAW.putByte(this.base + UByteRawIndexer.checkIndex(l, this.size), (byte)n);
        return this;
    }

    @Override
    public UByteIndexer put(long l, int n) {
        this.putRaw(this.index(l), n);
        return this;
    }

    @Override
    public UByteIndexer put(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public UByteIndexer put(long l, long l2, int n) {
        this.putRaw(this.index(l, l2), n);
        return this;
    }

    @Override
    public UByteIndexer put(long l, long l2, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public UByteIndexer put(long l, long l2, long l3, int n) {
        this.putRaw(this.index(l, l2, l3), n);
        return this;
    }

    @Override
    public UByteIndexer put(long[] lArray, int n) {
        this.putRaw(this.index(lArray), n);
        return this;
    }

    @Override
    public UByteIndexer put(long[] lArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, nArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

