/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.lang.reflect.Field;
import org.bytedeco.javacpp.indexer.Raw;
import sun.misc.Unsafe;

class UnsafeRaw
extends Raw {
    protected static final Unsafe UNSAFE;
    protected static final long arrayOffset;

    UnsafeRaw() {
    }

    static boolean isAvailable() {
        return UNSAFE != null;
    }

    @Override
    byte getByte(long l) {
        return UNSAFE.getByte(l);
    }

    @Override
    void putByte(long l, byte by) {
        UNSAFE.putByte(l, by);
    }

    @Override
    short getShort(long l) {
        return UNSAFE.getShort(l);
    }

    @Override
    void putShort(long l, short s) {
        UNSAFE.putShort(l, s);
    }

    @Override
    int getInt(long l) {
        return UNSAFE.getInt(l);
    }

    @Override
    void putInt(long l, int n) {
        UNSAFE.putInt(l, n);
    }

    @Override
    long getLong(long l) {
        return UNSAFE.getLong(l);
    }

    @Override
    void putLong(long l, long l2) {
        UNSAFE.putLong(l, l2);
    }

    @Override
    float getFloat(long l) {
        return UNSAFE.getFloat(l);
    }

    @Override
    void putFloat(long l, float f) {
        UNSAFE.putFloat(l, f);
    }

    @Override
    double getDouble(long l) {
        return UNSAFE.getDouble(l);
    }

    @Override
    void putDouble(long l, double d) {
        UNSAFE.putDouble(l, d);
    }

    @Override
    char getChar(long l) {
        return UNSAFE.getChar(l);
    }

    @Override
    void putChar(long l, char c) {
        UNSAFE.putChar(l, c);
    }

    @Override
    boolean getBoolean(long l) {
        return UNSAFE.getByte(l) != 0;
    }

    @Override
    void putBoolean(long l, boolean bl) {
        UNSAFE.putByte(l, bl ? (byte)1 : 0);
    }

    @Override
    byte getByte(byte[] byArray, long l) {
        return UNSAFE.getByte(byArray, arrayOffset + l);
    }

    @Override
    void putByte(byte[] byArray, long l, byte by) {
        UNSAFE.putByte(byArray, arrayOffset + l, by);
    }

    @Override
    short getShort(byte[] byArray, long l) {
        return UNSAFE.getShort(byArray, arrayOffset + l);
    }

    @Override
    void putShort(byte[] byArray, long l, short s) {
        UNSAFE.putShort(byArray, arrayOffset + l, s);
    }

    @Override
    int getInt(byte[] byArray, long l) {
        return UNSAFE.getInt(byArray, arrayOffset + l);
    }

    @Override
    void putInt(byte[] byArray, long l, int n) {
        UNSAFE.putInt(byArray, arrayOffset + l, n);
    }

    @Override
    long getLong(byte[] byArray, long l) {
        return UNSAFE.getLong(byArray, arrayOffset + l);
    }

    @Override
    void putLong(byte[] byArray, long l, long l2) {
        UNSAFE.putLong(byArray, arrayOffset + l, l2);
    }

    @Override
    float getFloat(byte[] byArray, long l) {
        return UNSAFE.getFloat(byArray, arrayOffset + l);
    }

    @Override
    void putFloat(byte[] byArray, long l, float f) {
        UNSAFE.putFloat(byArray, arrayOffset + l, f);
    }

    @Override
    double getDouble(byte[] byArray, long l) {
        return UNSAFE.getDouble(byArray, arrayOffset + l);
    }

    @Override
    void putDouble(byte[] byArray, long l, double d) {
        UNSAFE.putDouble(byArray, arrayOffset + l, d);
    }

    @Override
    char getChar(byte[] byArray, long l) {
        return UNSAFE.getChar(byArray, arrayOffset + l);
    }

    @Override
    void putChar(byte[] byArray, long l, char c) {
        UNSAFE.putChar(byArray, arrayOffset + l, c);
    }

    @Override
    boolean getBoolean(byte[] byArray, long l) {
        return UNSAFE.getBoolean(byArray, arrayOffset + l);
    }

    @Override
    void putBoolean(byte[] byArray, long l, boolean bl) {
        UNSAFE.putBoolean(byArray, arrayOffset + l, bl);
    }

    static {
        long l;
        Unsafe unsafe;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            clazz.getDeclaredMethod("getByte", Long.TYPE);
            clazz.getDeclaredMethod("getShort", Long.TYPE);
            clazz.getDeclaredMethod("getInt", Long.TYPE);
            clazz.getDeclaredMethod("getLong", Long.TYPE);
            clazz.getDeclaredMethod("getFloat", Long.TYPE);
            clazz.getDeclaredMethod("getDouble", Long.TYPE);
            clazz.getDeclaredMethod("getChar", Long.TYPE);
            clazz.getDeclaredMethod("arrayBaseOffset", Class.class);
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            l = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            unsafe = null;
            l = 0L;
        }
        UNSAFE = unsafe;
        arrayOffset = l;
    }
}

