/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.BuildEnabled;
import org.bytedeco.javacpp.tools.ClassScanner;
import org.bytedeco.javacpp.tools.CommandExecutor;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.Parser;
import org.bytedeco.javacpp.tools.UserClassLoader;

public class Builder {
    final Logger logger;
    String encoding = null;
    File outputDirectory = null;
    String outputName = null;
    File configDirectory = null;
    String jarPrefix = null;
    boolean clean = false;
    boolean generate = true;
    boolean compile = true;
    boolean deleteJniFiles = true;
    boolean header = false;
    boolean copyLibs = false;
    boolean copyResources = false;
    Properties properties = null;
    ClassScanner classScanner = null;
    String[] buildCommand = null;
    File workingDirectory = null;
    Map<String, String> environmentVariables = null;
    Collection<String> compilerOptions = null;
    CommandExecutor commandExecutor = null;

    void cleanOutputDirectory() {
        if (this.outputDirectory != null && this.outputDirectory.isDirectory() && this.clean) {
            Loader.deleteDirectory(this.outputDirectory);
        }
    }

    File[] parse(String[] stringArray, Class clazz) {
        this.cleanOutputDirectory();
        return new Parser(this.logger, this.properties, this.encoding, null).parse(this.outputDirectory, stringArray, clazz);
    }

    void includeJavaPaths(ClassProperties classProperties, boolean bl) {
        if (classProperties.getProperty("platform", "").startsWith("android")) {
            return;
        }
        String string = Loader.getPlatform();
        final String string2 = classProperties.getProperty("platform.link.prefix", "") + "jvm" + classProperties.getProperty("platform.link.suffix", "");
        final String string3 = classProperties.getProperty("platform.library.prefix", "") + "jvm" + classProperties.getProperty("platform.library.suffix", "");
        final HashSet<String> hashSet = new HashSet<String>();
        final HashSet<String> hashSet2 = new HashSet<String>();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                if (new File(file, "jni.h").exists()) {
                    hashSet.add(file.getAbsolutePath());
                }
                if (new File(file, "jni_md.h").exists()) {
                    hashSet.add(file.getAbsolutePath());
                }
                if (new File(file, string2).exists()) {
                    hashSet2.add(file.getAbsolutePath());
                }
                if (new File(file, string3).exists()) {
                    hashSet2.add(file.getAbsolutePath());
                }
                return new File(file, string).isDirectory();
            }
        };
        File[] fileArray = new File[2];
        try {
            fileArray[0] = Loader.getCanonicalFile(new File(System.getProperty("java.home")));
            fileArray[1] = Loader.getCanonicalFile(fileArray[0].getParentFile());
        }
        catch (IOException | NullPointerException exception) {
            this.logger.warn("Could not include header files from java.home:" + exception);
            return;
        }
        Object object = fileArray;
        int n = ((File[])object).length;
        for (int i = 0; i < n; ++i) {
            File file = object[i];
            hashSet.clear();
            hashSet2.clear();
            ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(file.listFiles(filenameFilter)));
            while (!arrayList.isEmpty()) {
                File file2 = arrayList.remove(arrayList.size() - 1);
                String string4 = file2.getPath();
                File[] fileArray2 = file2.listFiles(filenameFilter);
                if (string4 == null || fileArray2 == null) continue;
                for (File file3 : fileArray2) {
                    try {
                        file3 = Loader.getCanonicalFile(file3);
                    }
                    catch (IOException iOException) {
                        file3 = file3.getAbsoluteFile();
                    }
                    if (string4.startsWith(file3.getPath())) continue;
                    arrayList.add(file3);
                }
            }
            if (!hashSet.isEmpty() && !hashSet2.isEmpty()) break;
        }
        if (hashSet.isEmpty() && new File((String)(object = "/System/Library/Frameworks/JavaVM.framework/Headers/")).isDirectory()) {
            hashSet.add((String)object);
        }
        classProperties.addAll("platform.includepath", hashSet);
        if (string.equals(classProperties.getProperty("platform", string)) && bl) {
            classProperties.get("platform.link").add(0, "jvm");
            classProperties.addAll("platform.linkpath", hashSet2);
            if (string.startsWith("macosx") && hashSet2.isEmpty()) {
                classProperties.addAll("platform.framework", "JavaVM");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    int compile(String[] stringArray, String string, ClassProperties classProperties, File file) {
        int n;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.includeJavaPaths(classProperties, this.header);
        String string2 = Loader.getPlatform();
        String string3 = classProperties.getProperty("platform.compiler");
        arrayList.add(string3);
        String string4 = classProperties.getProperty("platform.sysroot.prefix", "");
        for (String string5 : classProperties.get("platform.sysroot")) {
            object2 = new File(string5);
            if (!((File)object2).isDirectory()) continue;
            string5 = Loader.getCanonicalPath((File)object2);
            if (string4.endsWith(" ")) {
                arrayList.add(string4.trim());
                arrayList.add(string5);
                continue;
            }
            arrayList.add(string4 + string5);
        }
        string4 = classProperties.getProperty("platform.toolchain.prefix", "");
        for (String string5 : classProperties.get("platform.toolchain")) {
            object2 = new File(string5);
            if (!((File)object2).isDirectory()) continue;
            string5 = Loader.getCanonicalPath((File)object2);
            if (string4.endsWith(" ")) {
                arrayList.add(string4.trim());
                arrayList.add(string5);
                continue;
            }
            arrayList.add(string4 + string5);
        }
        string4 = classProperties.getProperty("platform.includepath.prefix", "");
        for (String string5 : classProperties.get("platform.includepath")) {
            object2 = new File(string5);
            if (!((File)object2).isDirectory()) continue;
            string5 = Loader.getCanonicalPath((File)object2);
            if (string4.endsWith(" ")) {
                arrayList.add(string4.trim());
                arrayList.add(string5);
                continue;
            }
            arrayList.add(string4 + string5);
        }
        for (String string5 : classProperties.get("platform.includeresource")) {
            for (File file2 : Loader.cacheResources(string5)) {
                if (!file2.isDirectory()) continue;
                if (string4.endsWith(" ")) {
                    arrayList.add(string4.trim());
                    arrayList.add(Loader.getCanonicalPath(file2));
                    continue;
                }
                arrayList.add(string4 + Loader.getCanonicalPath(file2));
            }
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            arrayList.add(stringArray[i]);
        }
        List<String> list = classProperties.get("platform.compiler.*");
        if (!list.contains("!default") && !list.contains("default")) {
            list.add(0, "default");
        }
        for (String string5 : list) {
            if (string5 == null || string5.length() == 0) continue;
            object2 = "platform.compiler." + string5;
            String string6 = classProperties.getProperty((String)object2);
            if (string6 != null && string6.length() > 0) {
                arrayList.addAll(Arrays.asList(string6.split(" ")));
                continue;
            }
            if ("!default".equals(string5) || "default".equals(string5)) continue;
            this.logger.warn("Could not get the property named \"" + (String)object2 + "\"");
        }
        arrayList.addAll(this.compilerOptions);
        Object object4 = classProperties.getProperty("platform.compiler.output");
        int n2 = 1;
        while (n2 < 2 || object4 != null) {
            if (object4 != null && ((String)object4).length() > 0) {
                arrayList.addAll(Arrays.asList(((String)object4).split(" ")));
            }
            if (object4 == null || ((String)object4).length() == 0 || ((String)object4).endsWith(" ")) {
                arrayList.add(string);
            } else {
                arrayList.add((String)arrayList.remove(arrayList.size() - 1) + string);
            }
            object4 = classProperties.getProperty("platform.compiler.output" + ++n2);
        }
        String string7 = classProperties.getProperty("platform.linkpath.prefix", "");
        object2 = classProperties.getProperty("platform.linkpath.prefix2");
        for (String string5 : classProperties.get("platform.linkpath")) {
            File file3 = new File(string5);
            if (!file3.isDirectory()) continue;
            String string6 = Loader.getCanonicalPath(file3);
            if (string7.endsWith(" ")) {
                arrayList.add(string7.trim());
                arrayList.add(string6);
            } else {
                arrayList.add(string7 + string6);
            }
            if (object2 == null) continue;
            if (((String)object2).endsWith(" ")) {
                arrayList.add(((String)object2).trim());
                arrayList.add(string6);
                continue;
            }
            arrayList.add((String)object2 + string6);
        }
        for (String string8 : classProperties.get("platform.linkresource")) {
            for (File file4 : Loader.cacheResources(string8)) {
                if (!file4.isDirectory()) continue;
                if (string7.endsWith(" ")) {
                    arrayList.add(string7.trim());
                    arrayList.add(Loader.getCanonicalPath(file4));
                } else {
                    arrayList.add(string7 + Loader.getCanonicalPath(file4));
                }
                if (object2 == null) continue;
                if (((String)object2).endsWith(" ")) {
                    arrayList.add(((String)object2).trim());
                    arrayList.add(Loader.getCanonicalPath(file4));
                    continue;
                }
                arrayList.add((String)object2 + Loader.getCanonicalPath(file4));
            }
        }
        string7 = classProperties.getProperty("platform.link.prefix", "");
        object2 = classProperties.getProperty("platform.link.suffix", "");
        String string9 = "";
        String string10 = "";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (string7.endsWith(" ")) {
            arrayList2.addAll(Arrays.asList(string7.trim().split(" ")));
        } else {
            n = string7.lastIndexOf(" ");
            if (n != -1) {
                arrayList2.addAll(Arrays.asList(string7.substring(0, n).split(" ")));
                String string11 = string7.substring(n + 1);
            } else {
                String string12 = string7;
            }
        }
        if (((String)object2).startsWith(" ")) {
            arrayList3.addAll(Arrays.asList(((String)object2).trim().split(" ")));
        } else {
            n = ((String)object2).indexOf(" ");
            if (n != -1) {
                String string13 = ((String)object2).substring(0, n);
                arrayList3.addAll(Arrays.asList(((String)object2).substring(n + 1).split(" ")));
            } else {
                Object object = object2;
            }
        }
        n = arrayList.size();
        for (String string14 : classProperties.get("platform.link")) {
            void var13_46;
            void var12_25;
            String[] stringArray2 = string14.split("#")[0].split("@");
            string14 = stringArray2.length == 3 && stringArray2[1].length() == 0 ? stringArray2[0] + stringArray2[2] : stringArray2[0];
            ArrayList<String> arrayList4 = new ArrayList<String>();
            arrayList4.addAll(arrayList2);
            arrayList4.add((String)var12_25 + (string14.endsWith("!") ? string14.substring(0, string14.length() - 1) : string14) + (String)var13_46);
            arrayList4.addAll(arrayList3);
            arrayList.addAll(n, arrayList4);
        }
        string7 = classProperties.getProperty("platform.frameworkpath.prefix", "");
        for (String string15 : classProperties.get("platform.frameworkpath")) {
            File file5 = new File(string15);
            if (!file5.isDirectory()) continue;
            String string16 = Loader.getCanonicalPath(file5);
            if (string7.endsWith(" ")) {
                arrayList.add(string7.trim());
                arrayList.add(string16);
                continue;
            }
            arrayList.add(string7 + string16);
        }
        string7 = classProperties.getProperty("platform.framework.prefix", "");
        object2 = classProperties.getProperty("platform.framework.suffix", "");
        for (String string17 : classProperties.get("platform.framework")) {
            if (string7.endsWith(" ") && ((String)object2).startsWith(" ")) {
                arrayList.add(string7.trim());
                arrayList.add(string17);
                arrayList.add(((String)object2).trim());
                continue;
            }
            if (string7.endsWith(" ")) {
                arrayList.add(string7.trim());
                arrayList.add(string17 + (String)object2);
                continue;
            }
            if (((String)object2).startsWith(" ")) {
                arrayList.add(string7 + string17);
                arrayList.add(((String)object2).trim());
                continue;
            }
            arrayList.add(string7 + string17 + (String)object2);
        }
        boolean bl = string2.startsWith("windows");
        for (int i = 0; i < arrayList.size(); ++i) {
            void var12_36;
            void var12_34;
            String string18 = (String)arrayList.get(i);
            if (string18 == null) {
                String string19 = "";
            }
            if (var12_34.trim().isEmpty() && bl) {
                String string20 = "\"\"";
            }
            arrayList.set(i, (String)var12_36);
        }
        return this.commandExecutor.executeCommand(arrayList, file, this.environmentVariables);
    }

    File getOutputPath(Class[] classArray, String[] stringArray) {
        this.cleanOutputDirectory();
        File file = this.outputDirectory != null ? Loader.getCanonicalFile(this.outputDirectory) : null;
        ClassProperties classProperties = Loader.loadProperties(classArray, this.properties, true);
        String string = this.properties.getProperty("platform");
        String string2 = this.properties.getProperty("platform.extension");
        String string3 = file != null ? file.getPath() + File.separator : "";
        String string4 = classProperties.getProperty("platform.library.path", "");
        if (stringArray != null) {
            stringArray[0] = stringArray[1] = string3;
        }
        if (file == null) {
            URI uRI = null;
            try {
                Object object;
                Object object2;
                Object object3;
                int n;
                String string5 = '/' + classArray[0].getName().replace('.', '/') + ".class";
                String string6 = Loader.findResource(classArray[0], string5).toString();
                String string7 = string6.substring(0, string6.lastIndexOf(47) + 1);
                for (n = 1; n < classArray.length; ++n) {
                    String string8;
                    object3 = '/' + classArray[n].getName().replace('.', '/') + ".class";
                    object2 = Loader.findResource(classArray[n], (String)object3).toString();
                    object = ((String)object2).substring(0, ((String)object2).lastIndexOf(47) + 1);
                    String string9 = ((String)object).length() >= string7.length() ? object : string7;
                    String string10 = string8 = ((String)object).length() < string7.length() ? object : string7;
                    while (!string9.startsWith(string8) && string8.lastIndexOf(47) > 0) {
                        string8 = string8.substring(0, string8.lastIndexOf(47));
                    }
                    string7 = string8;
                }
                uRI = new URI(string7);
                n = "file".equals(uRI.getScheme()) ? 1 : 0;
                object3 = Loader.getCanonicalFile(new File(this.classScanner.getClassLoader().getPaths()[0]));
                object2 = n != 0 ? new File(uRI) : new File((File)object3, string5.substring(0, string5.lastIndexOf(47) + 1));
                uRI = new URI(string6.substring(0, string6.length() - string5.length() + 1));
                object = string4.length() > 0 ? (n != 0 ? new File(uRI) : object3) : new File((File)object2, string + (string2 != null ? string2 : ""));
                file = new File((File)object, string4);
                string3 = ((File)object2).getPath() + File.separator;
                if (stringArray != null) {
                    stringArray[0] = ((File)object3).getPath() + File.separator;
                    stringArray[1] = string3;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("URI: " + uRI, illegalArgumentException);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File[] generateAndCompile(Class[] classArray, String string, boolean bl, boolean bl2) {
        int n;
        void var21_36;
        int n2;
        String[] stringArray = new String[2];
        File file = this.getOutputPath(classArray, stringArray);
        ClassProperties classProperties = Loader.loadProperties(classArray, this.properties, true);
        String string2 = classProperties.getProperty("platform.source.suffix", ".cpp");
        String string3 = classProperties.getProperty("platform.library.prefix", "");
        String string4 = classProperties.getProperty("platform.library.suffix", "");
        Generator generator = new Generator(this.logger, this.properties, this.encoding);
        String[] stringArray2 = new String[]{stringArray[0] + "jnijavacpp" + string2, stringArray[1] + string + string2};
        String[] stringArray3 = new String[]{this.configDirectory != null ? new File(this.configDirectory, "jnijavacpp").getPath() : null, this.configDirectory != null ? new File(this.configDirectory, string).getPath() : null};
        String[] stringArray4 = new String[]{null, this.header ? stringArray[1] + string + ".h" : null};
        String[] stringArray5 = new String[]{"_jnijavacpp", null};
        String[] stringArray6 = new String[]{null, "_jnijavacpp"};
        String string5 = System.getProperty("java.class.path");
        for (String string6 : this.classScanner.getClassLoader().getPaths()) {
            string5 = string5 + File.pathSeparator + string6;
        }
        String[] stringArray7 = new String[]{null, string5};
        Class[][] classArrayArray = new Class[][]{null, classArray};
        String[] stringArray8 = new String[]{string3 + "jnijavacpp" + string4, string3 + string + string4};
        Object var21_24 = null;
        if (string.equals("jnijavacpp")) {
            stringArray2 = new String[]{stringArray[0] + string + string2};
            stringArray3 = new String[]{this.configDirectory != null ? new File(this.configDirectory, string).getPath() : null};
            stringArray4 = new String[]{this.header ? stringArray[0] + string + ".h" : null};
            stringArray5 = new String[]{null};
            stringArray6 = new String[]{null};
            stringArray7 = new String[]{string5};
            classArrayArray = new Class[][]{classArray};
            stringArray8 = new String[]{string3 + string + string4};
        }
        boolean bl3 = true;
        String[] stringArray9 = new String[stringArray2.length];
        String[] stringArray10 = new String[stringArray2.length];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (n2 == 0 && !bl) continue;
            this.logger.info("Generating " + stringArray2[n2]);
            stringArray9[n2] = stringArray3[n2] != null ? stringArray3[n2] + File.separator + "jni-config.json" : null;
            String string7 = stringArray10[n2] = stringArray3[n2] != null ? stringArray3[n2] + File.separator + "reflect-config.json" : null;
            if (generator.generate(stringArray2[n2], stringArray9[n2], stringArray10[n2], stringArray4[n2], stringArray5[n2], stringArray6[n2], stringArray7[n2], classArrayArray[n2])) continue;
            this.logger.info("Nothing generated for " + stringArray2[n2]);
            bl3 = false;
            break;
        }
        if (!bl3) return var21_36;
        if (this.compile) {
            n2 = 0;
            String string8 = this.properties.getProperty("platform.library.static", "false").toLowerCase();
            if (string8.equals("true") || string8.equals("t") || string8.equals("")) {
                File[] fileArray = new File[stringArray2.length];
                for (n = 0; n2 == 0 && n < stringArray2.length; ++n) {
                    if (n == 0 && !bl) continue;
                    this.logger.info("Compiling " + file.getPath() + File.separator + stringArray8[n]);
                    n2 = this.compile(new String[]{stringArray2[n]}, stringArray8[n], classProperties, file);
                    fileArray[n] = new File(file, stringArray8[n]);
                }
            } else {
                String string9 = stringArray8[stringArray8.length - 1];
                this.logger.info("Compiling " + file.getPath() + File.separator + string9);
                n2 = this.compile(stringArray2, string9, classProperties, file);
                File[] fileArray = new File[]{new File(file, string9)};
            }
            if (n2 != 0) throw new RuntimeException("Process exited with an error: " + n2);
            for (n = stringArray2.length - 1; n >= 0; --n) {
                if (n == 0 && !bl2) continue;
                if (this.deleteJniFiles) {
                    this.logger.info("Deleting " + stringArray2[n]);
                    new File(stringArray2[n]).delete();
                    continue;
                }
                this.logger.info("Keeping " + stringArray2[n]);
            }
        } else {
            File[] fileArray = new File[stringArray2.length];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                fileArray[n2] = new File(stringArray2[n2]);
            }
        }
        if (this.header) {
            String[] stringArray11 = stringArray4;
            int n3 = stringArray11.length;
            for (n = 0; n < n3; ++n) {
                void var21_30;
                String string10 = stringArray11[n];
                if (string10 == null) continue;
                File[] fileArray = (File[])Arrays.copyOf(var21_30, ((void)var21_30).length + 1);
                fileArray[fileArray.length - 1] = new File(string10);
            }
        }
        if (this.configDirectory == null) return var21_36;
        for (String string10 : stringArray9) {
            void var21_32;
            if (string10 == null) continue;
            File[] fileArray = (File[])Arrays.copyOf(var21_32, ((void)var21_32).length + 1);
            fileArray[fileArray.length - 1] = new File(string10);
        }
        for (String string10 : stringArray10) {
            void var21_34;
            if (string10 == null) continue;
            File[] fileArray = (File[])Arrays.copyOf(var21_34, ((void)var21_34).length + 1);
            fileArray[fileArray.length - 1] = new File(string10);
        }
        return var21_36;
    }

    void createJar(File file, String[] stringArray, File ... fileArray) {
        this.logger.info("Creating " + file);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        for (File file2 : fileArray) {
            int n;
            Object object;
            Object object2;
            Object object3 = file2.getPath();
            if (stringArray != null) {
                int n2;
                object2 = new String[stringArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    object = Loader.getCanonicalPath(new File(stringArray[n2]));
                    if (!((String)object3).startsWith((String)object)) continue;
                    object2[n2] = ((String)object3).substring(((String)object).length() + 1);
                }
                for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                    if (object2[n2] == null || ((String)object2[n2]).length() >= ((String)object3).length()) continue;
                    object3 = object2[n2];
                }
            }
            object2 = new ZipEntry(((String)object3).replace(File.separatorChar, '/'));
            ((ZipEntry)object2).setTime(file2.lastModified());
            jarOutputStream.putNextEntry((ZipEntry)object2);
            FileInputStream fileInputStream = new FileInputStream(file2);
            object = new byte[65536];
            while ((n = fileInputStream.read((byte[])object)) != -1) {
                jarOutputStream.write((byte[])object, 0, n);
            }
            fileInputStream.close();
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
    }

    public Builder() {
        this(Logger.create(Builder.class));
    }

    public Builder(Logger logger) {
        this.logger = logger;
        System.setProperty("org.bytedeco.javacpp.loadlibraries", "false");
        this.properties = Loader.loadProperties();
        this.classScanner = new ClassScanner(logger, new ArrayList<Class>(), new UserClassLoader(Thread.currentThread().getContextClassLoader()));
        this.compilerOptions = new ArrayList<String>();
        this.commandExecutor = new CommandExecutor(logger);
    }

    public Builder classPaths(String string) {
        this.classPaths(string == null ? null : string.split(File.pathSeparator));
        return this;
    }

    public Builder classPaths(String ... stringArray) {
        this.classScanner.getClassLoader().addPaths(stringArray);
        return this;
    }

    public Builder encoding(String string) {
        this.encoding = string;
        return this;
    }

    public Builder outputDirectory(String string) {
        this.outputDirectory(string == null ? null : new File(string));
        return this;
    }

    public Builder outputDirectory(File file) {
        this.outputDirectory = file;
        return this;
    }

    public Builder clean(boolean bl) {
        this.clean = bl;
        return this;
    }

    public Builder generate(boolean bl) {
        this.generate = bl;
        return this;
    }

    public Builder compile(boolean bl) {
        this.compile = bl;
        return this;
    }

    public Builder deleteJniFiles(boolean bl) {
        this.deleteJniFiles = bl;
        return this;
    }

    public Builder header(boolean bl) {
        this.header = bl;
        return this;
    }

    public Builder copyLibs(boolean bl) {
        this.copyLibs = bl;
        return this;
    }

    public Builder copyResources(boolean bl) {
        this.copyResources = bl;
        return this;
    }

    public Builder outputName(String string) {
        this.outputName = string;
        return this;
    }

    public Builder configDirectory(String string) {
        this.configDirectory(string == null ? null : new File(string));
        return this;
    }

    public Builder configDirectory(File file) {
        this.configDirectory = file;
        return this;
    }

    public Builder jarPrefix(String string) {
        this.jarPrefix = string;
        return this;
    }

    public Builder properties(String string) {
        if (string != null) {
            this.properties = Loader.loadProperties(string, null);
        }
        return this;
    }

    public Builder properties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.property((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    public Builder propertyFile(String string) {
        this.propertyFile(string == null ? null : new File(string));
        return this;
    }

    public Builder propertyFile(File file) {
        if (file == null) {
            return this;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.properties = new Properties();
        try {
            this.properties.load(new InputStreamReader(fileInputStream));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.properties.load(fileInputStream);
        }
        fileInputStream.close();
        return this;
    }

    public Builder property(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            n = string.indexOf(58);
        }
        this.property(string.substring(0, n), string.substring(n + 1));
        return this;
    }

    public Builder property(String string, String string2) {
        if (string.length() > 0 && string2.length() > 0) {
            this.properties.put(string, string2);
        }
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Builder addProperty(String string, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String string2 = this.properties.getProperty("platform.path.separator");
            String string3 = this.properties.getProperty(string, "");
            for (String string4 : stringArray) {
                string3 = string3 + (string3.length() == 0 || string3.endsWith(string2) ? string4 : string2 + string4);
            }
            this.properties.setProperty(string, string3);
        }
        return this;
    }

    public Builder classesOrPackages(String ... stringArray) {
        if (stringArray == null) {
            this.classScanner.addPackage(null, true);
        } else {
            for (String string : stringArray) {
                this.classScanner.addClassOrPackage(string);
            }
        }
        return this;
    }

    public Builder buildCommand(String[] stringArray) {
        this.buildCommand = stringArray;
        return this;
    }

    public Builder workingDirectory(String string) {
        this.workingDirectory(string == null ? null : new File(string));
        return this;
    }

    public Builder workingDirectory(File file) {
        this.workingDirectory = file;
        return this;
    }

    public Builder environmentVariables(Map<String, String> map) {
        this.environmentVariables = map;
        return this;
    }

    public Builder compilerOptions(String ... stringArray) {
        if (stringArray != null) {
            this.compilerOptions.addAll(Arrays.asList(stringArray));
        }
        return this;
    }

    public Builder commandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public File[] build() {
        Object object;
        Object object2;
        Object object32;
        File[] fileArray;
        if (this.buildCommand != null && this.buildCommand.length > 0) {
            int exception;
            List<String> list = Arrays.asList(this.buildCommand);
            String string = this.properties.getProperty("platform.buildpath", "");
            String string2 = this.properties.getProperty("platform.linkresource", "");
            String string3 = this.properties.getProperty("platform.buildresource", "");
            String string4 = this.properties.getProperty("platform.path.separator");
            ArrayList<String> arrayList = new ArrayList<String>();
            ClassProperties classProperties = null;
            for (Class bl : this.classScanner.getClasses()) {
                if (Loader.getEnclosingClass(bl) != bl) continue;
                classProperties = Loader.loadProperties(bl, this.properties, true);
                if (!classProperties.isLoaded()) {
                    this.logger.warn("Could not load platform properties for " + bl);
                    continue;
                }
                arrayList.addAll(classProperties.get("platform.preload"));
                arrayList.addAll(classProperties.get("platform.link"));
            }
            if (classProperties == null) {
                classProperties = new ClassProperties(this.properties);
            }
            this.includeJavaPaths(classProperties, this.header);
            if (this.environmentVariables == null) {
                this.environmentVariables = new HashMap<String, String>();
            }
            for (Map.Entry linkedHashSet : classProperties.entrySet()) {
                void var12_52;
                String string5 = (String)linkedHashSet.getKey();
                string5 = string5.toUpperCase().replace('.', '_');
                List list2 = (List)linkedHashSet.getValue();
                String string6 = "";
                for (String string7 : list2) {
                    String string8 = (String)var12_52 + (var12_52.length() > 0 && !var12_52.endsWith(string4) ? string4 + string7 : string7);
                }
                this.environmentVariables.put(string5, (String)var12_52);
            }
            if ((string = string.replace(string4, File.pathSeparator)).length() > 0 || string3.length() > 0) {
                for (Iterator<Object> iterator : string3.split(string4)) {
                    for (File file : Loader.cacheResources(iterator)) {
                        String string9 = Loader.getCanonicalPath(file);
                        if (string.length() > 0 && !string.endsWith(File.pathSeparator)) {
                            string = string + File.pathSeparator;
                        }
                        string = string + string9;
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (String string10 : string2.split(string4)) {
                            for (File file2 : Loader.cacheResources(string10)) {
                                String string11 = Loader.getCanonicalPath(file2);
                                if (!string11.startsWith(string9) || string11.equals(string9)) continue;
                                arrayList2.add(string11);
                            }
                        }
                        Object[] objectArray = file.listFiles();
                        if (objectArray == null) continue;
                        for (Object object4 : objectArray) {
                            Loader.createLibraryLink(((File)object4).getAbsolutePath(), classProperties, null, arrayList2.toArray(new String[arrayList2.size()]));
                        }
                    }
                }
                if (string.length() > 0) {
                    if (this.environmentVariables == null) {
                        this.environmentVariables = new LinkedHashMap<String, String>();
                    }
                    this.environmentVariables.put("BUILD_PATH", string);
                    this.environmentVariables.put("BUILD_PATH_SEPARATOR", File.pathSeparator);
                }
            }
            if ((exception = this.commandExecutor.executeCommand(list, this.workingDirectory, this.environmentVariables)) != 0) {
                throw new RuntimeException("Process exited with an error: " + exception);
            }
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (this.classScanner.getClasses().isEmpty()) {
            if (this.outputName != null && this.outputName.equals("jnijavacpp")) {
                fileArray = this.generateAndCompile(null, this.outputName, true, true);
                if (fileArray != null && fileArray.length > 0) {
                    arrayList.addAll(Arrays.asList(fileArray));
                }
            } else {
                return null;
            }
        }
        fileArray = new HashMap();
        HashMap hashMap = new HashMap();
        for (Class object42 : this.classScanner.getClasses()) {
            String string;
            if (Loader.getEnclosingClass(object42) != object42) continue;
            object32 = Loader.loadProperties(object42, this.properties, false);
            if (((ClassProperties)object32).isLoaded()) {
                if (Arrays.asList(object42.getInterfaces()).contains(BuildEnabled.class)) {
                    try {
                        ((BuildEnabled)object42.newInstance()).init(this.logger, this.properties, this.encoding);
                    }
                    catch (ClassCastException | IllegalAccessException | InstantiationException exception) {
                        this.logger.warn("Could not create an instance of " + object42 + ": " + exception);
                    }
                }
                if ((object2 = ((ClassProperties)object32).getProperty("global")) != null && !object42.getName().equals(object2)) {
                    int n;
                    boolean bl = false;
                    object = this.classScanner.getClasses().iterator();
                    while (object.hasNext()) {
                        Class clazz = (Class)object.next();
                        n |= clazz.getName().equals(object2);
                    }
                    if (this.generate && n != false || (object = this.parse(this.classScanner.getClassLoader().getPaths(), object42)) == null) continue;
                    arrayList.addAll(Arrays.asList(object));
                    continue;
                }
            }
            if (!((ClassProperties)object32).isLoaded()) {
                object32 = Loader.loadProperties(object42, this.properties, true);
            }
            if (!((ClassProperties)object32).isLoaded()) {
                this.logger.warn("Could not load platform properties for " + object42);
                continue;
            }
            object2 = ((ClassProperties)object32).get("platform.executable");
            Iterator<String> iterator = object2.iterator();
            while (iterator.hasNext()) {
                void var11_41;
                object = iterator.next();
                LinkedHashSet linkedHashSet = (LinkedHashSet)fileArray.get(object = ((String)object).split("#")[0]);
                if (linkedHashSet == null) {
                    arrayList3.add(object);
                    LinkedHashSet linkedHashSet2 = new LinkedHashSet();
                    fileArray.put(object, linkedHashSet2);
                }
                var11_41.addAll(((ClassProperties)object32).getEffectiveClasses());
            }
            if (object2.size() > 0) continue;
            String string12 = string = this.outputName != null ? this.outputName : ((ClassProperties)object32).getProperty("platform.library", "");
            if (!this.generate || string.length() == 0) continue;
            object = (LinkedHashSet)hashMap.get(string);
            if (object == null) {
                arrayList3.add(string);
                object = new LinkedHashSet();
                hashMap.put(string, object);
            }
            ((AbstractCollection)object).addAll(((ClassProperties)object32).getEffectiveClasses());
        }
        int n = 0;
        for (Object object32 : arrayList3) {
            void var11_50;
            void var11_47;
            Object object52;
            Object object6;
            Object object72;
            Object object8;
            object2 = (LinkedHashSet)fileArray.get(object32);
            LinkedHashSet linkedHashSet = (LinkedHashSet)hashMap.get(object32);
            object = null;
            Object var11_43 = null;
            if (object2 != null) {
                object = ((HashSet)object2).toArray((Class[])new Class[((HashSet)object2).size()]);
                ClassProperties classProperties = Loader.loadProperties((Class[])object, this.properties, true);
                object8 = classProperties.getProperty("platform.executable.prefix", "");
                String string = classProperties.getProperty("platform.executable.suffix", "");
                String string13 = (String)object8 + (String)object32 + string;
                object72 = classProperties.get("platform.executablepath").iterator();
                while (object72.hasNext()) {
                    object6 = object72.next();
                    Path path = Paths.get((String)object6, string13);
                    if (!Files.exists(path, new LinkOption[0])) {
                        path = Paths.get((String)object6, new String[]{object32});
                    }
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    this.logger.info("Copying " + path);
                    File file = this.getOutputPath((Class[])object, null);
                    object52 = new File(file, string13).toPath();
                    Files.copy(path, (Path)object52, StandardCopyOption.REPLACE_EXISTING);
                    File[] fileArray2 = new File[]{object52.toFile()};
                    break;
                }
            } else {
                if (linkedHashSet == null) continue;
                object = linkedHashSet.toArray(new Class[linkedHashSet.size()]);
                File[] fileArray3 = this.generateAndCompile((Class[])object, (String)object32, n == 0, n == hashMap.size() - 1);
                ++n;
            }
            if (var11_47 != null && ((void)var11_47).length > 0) {
                void var12_61;
                Object var12_59 = null;
                for (Object object72 : var11_47) {
                    if (object72 == null) continue;
                    File file = ((File)object72).getParentFile();
                    break;
                }
                arrayList.addAll(Arrays.asList(var11_47));
                if (this.copyLibs) {
                    object8 = Loader.loadProperties((Class[])object, this.properties, false);
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    arrayList4.addAll(((ClassProperties)object8).get("platform.preload"));
                    arrayList4.addAll(((ClassProperties)object8).get("platform.link"));
                    ClassProperties classProperties = Loader.loadProperties((Class[])object, this.properties, true);
                    object72 = arrayList4.iterator();
                    while (object72.hasNext()) {
                        void var11_48;
                        File file;
                        object6 = (String)object72.next();
                        if (object6.trim().endsWith("#") || object6.trim().length() == 0) continue;
                        URL[] uRLArray = Loader.findLibrary(null, (ClassProperties)object8, (String)object6);
                        try {
                            file = new File(new URI(uRLArray[0].toURI().toString().split("#")[0]));
                        }
                        catch (Exception exception) {
                            uRLArray = Loader.findLibrary(null, classProperties, (String)object6);
                            try {
                                file = new File(new URI(uRLArray[0].toURI().toString().split("#")[0]));
                            }
                            catch (Exception exception2) {
                                this.logger.warn("Could not find library " + (String)object6);
                                continue;
                            }
                        }
                        object52 = new File((File)var12_61, file.getName());
                        if (!file.exists() || arrayList.contains(object52)) continue;
                        this.logger.info("Copying " + file);
                        Files.copy(file.toPath(), ((File)object52).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        arrayList.add(object52);
                        File[] fileArray4 = (File[])Arrays.copyOf(var11_48, ((void)var11_48).length + 1);
                        fileArray4[fileArray4.length - 1] = object52;
                    }
                }
                if (this.copyResources) {
                    object8 = Loader.loadProperties((Class[])object, this.properties, false);
                    List<String> list = ((ClassProperties)object8).get("platform.resource");
                    object8 = Loader.loadProperties((Class[])object, this.properties, true);
                    List<String> list3 = ((ClassProperties)object8).get("platform.resourcepath");
                    object72 = var12_61.toPath();
                    block30: for (String string : list) {
                        final Path path = object72.resolve(string);
                        if (!Files.exists(path, new LinkOption[0])) {
                            Files.createDirectories(path, new FileAttribute[0]);
                        }
                        object52 = list3.iterator();
                        while (object52.hasNext()) {
                            String string14 = (String)object52.next();
                            final Path path2 = Paths.get(string14, string);
                            if (!Files.exists(path2, new LinkOption[0])) continue;
                            this.logger.info("Copying " + path2);
                            Files.walkFileTree(path2, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) {
                                    block2: {
                                        Path path22 = path.resolve(path2.relativize(path3));
                                        try {
                                            Files.copy(path3, path22, StandardCopyOption.REPLACE_EXISTING);
                                        }
                                        catch (DirectoryNotEmptyException | FileAlreadyExistsException fileSystemException) {
                                            if (Files.isDirectory(path22, new LinkOption[0])) break block2;
                                            throw fileSystemException;
                                        }
                                    }
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) {
                                    Files.copy(path3, path.resolve(path2.relativize(path3)), StandardCopyOption.REPLACE_EXISTING);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                            File[] fileArray5 = (File[])Arrays.copyOf(var11_50, ((void)var11_50).length + 1);
                            fileArray5[fileArray5.length - 1] = path2.toFile();
                            continue block30;
                        }
                    }
                }
            }
            if (this.configDirectory == null) continue;
            File file = new File(this.configDirectory, (String)object32 + "/resource-config.json");
            object8 = file.getParentFile();
            if (object8 != null) {
                ((File)object8).mkdirs();
            }
            this.logger.info("Generating " + file);
            try (PrintWriter printWriter = this.encoding != null ? new PrintWriter(file, this.encoding) : new PrintWriter(file);){
                printWriter.println("{");
                printWriter.println("  \"resources\": [");
                printWriter.println("    {\"pattern\": \"META-INF/.*\"},");
                printWriter.print("    {\"pattern\": \"org/bytedeco/javacpp/properties/.*\"}");
                object72 = "," + System.lineSeparator();
                for (Object object52 : var11_50 != null ? var11_50 : new File[]{}) {
                    if (object52 == null || ((File)object52).toPath().startsWith(this.configDirectory.toPath())) continue;
                    printWriter.print((String)object72 + "    {\"pattern\": \".*/" + ((File)object52).getName() + (((File)object52).isDirectory() ? "/.*" : "") + "\"}");
                }
                printWriter.println();
                printWriter.println("  ]");
                printWriter.println("}");
            }
            arrayList.add(file);
        }
        File[] fileArray6 = arrayList.toArray(new File[arrayList.size()]);
        if (this.jarPrefix != null && fileArray6.length > 0) {
            object32 = new File(this.jarPrefix + "-" + this.properties.getProperty("platform") + this.properties.getProperty("platform.extension", "") + ".jar");
            object2 = ((File)object32).getParentFile();
            if (object2 != null && !((File)object2).exists()) {
                ((File)object2).mkdir();
            }
            this.createJar((File)object32, this.outputDirectory == null ? this.classScanner.getClassLoader().getPaths() : null, fileArray6);
        }
        System.setProperty("org.bytedeco.javacpp.loadlibraries", "true");
        return fileArray6;
    }

    public static void printHelp() {
        String string = Builder.class.getPackage().getImplementationVersion();
        if (string == null) {
            string = "unknown";
        }
        System.out.println("JavaCPP version " + string + "\nCopyright (C) 2011-2022 Samuel Audet <samuel.audet@gmail.com>\nProject site: https://github.com/bytedeco/javacpp");
        System.out.println();
        System.out.println("Usage: java -jar javacpp.jar [options] [class or package (suffixed with .* or .**)] [commands]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("    -classpath <path>      Load user classes from path");
        System.out.println("    -encoding <name>       Character encoding used for input and output files");
        System.out.println("    -d <directory>         Output all generated files to directory");
        System.out.println("    -o <name>              Output everything in a file named after given name");
        System.out.println("    -clean                 Delete the output directory before generating anything in it");
        System.out.println("    -nogenerate            Do not try to generate C++ source files, only try to parse header files");
        System.out.println("    -nocompile             Do not compile or delete the generated C++ source files");
        System.out.println("    -nodelete              Do not delete generated C++ JNI files after compilation");
        System.out.println("    -header                Generate header file with declarations of callbacks functions");
        System.out.println("    -copylibs              Copy to output directory dependent libraries (link and preload)");
        System.out.println("    -copyresources         Copy to output directory resources listed in properties");
        System.out.println("    -configdir <directory> Also create config files for GraalVM native-image in directory");
        System.out.println("    -jarprefix <prefix>    Also create a JAR file named \"<prefix>-<platform>.jar\"");
        System.out.println("    -properties <resource> Load all platform properties from resource");
        System.out.println("    -propertyfile <file>   Load all platform properties from file");
        System.out.println("    -D<property>=<value>   Set platform property to value");
        System.out.println("    -Xcompiler <option>    Pass option directly to compiler");
        System.out.println();
        System.out.println("and where optional commands include:");
        System.out.println();
        System.out.println("    -clear                 Before doing anything else, delete all files from the cache");
        System.out.println("    -mod <file>            Output a module-info.java file for native JAR where module name is the package of the first class");
        System.out.println("    -exec [args...]        After build, call java command on the first class");
        System.out.println("    -print <property>      Print the given platform property, for example, \"platform.includepath\", and exit");
        System.out.println("                           \"platform.includepath\" has jni.h, jni_md.h, etc, and \"platform.linkpath\", the jvm library");
        System.out.println();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        ArrayList<String> arrayList;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        Builder builder = new Builder();
        String[] stringArray2 = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-help".equals(stringArray[i]) || "--help".equals(stringArray[i])) {
                Builder.printHelp();
                System.exit(0);
                continue;
            }
            if ("-classpath".equals(stringArray[i]) || "-cp".equals(stringArray[i]) || "-lib".equals(stringArray[i])) {
                builder.classPaths(stringArray[++i]);
                continue;
            }
            if ("-encoding".equals(stringArray[i])) {
                builder.encoding(stringArray[++i]);
                continue;
            }
            if ("-d".equals(stringArray[i])) {
                builder.outputDirectory(stringArray[++i]);
                continue;
            }
            if ("-o".equals(stringArray[i])) {
                builder.outputName(stringArray[++i]);
                continue;
            }
            if ("-clean".equals(stringArray[i])) {
                builder.clean(true);
                continue;
            }
            if ("-nocpp".equals(stringArray[i]) || "-nogenerate".equals(stringArray[i])) {
                builder.generate(false);
                continue;
            }
            if ("-cpp".equals(stringArray[i]) || "-nocompile".equals(stringArray[i])) {
                builder.compile(false);
                continue;
            }
            if ("-nodelete".equals(stringArray[i])) {
                builder.deleteJniFiles(false);
                continue;
            }
            if ("-header".equals(stringArray[i])) {
                builder.header(true);
                continue;
            }
            if ("-copylibs".equals(stringArray[i])) {
                builder.copyLibs(true);
                continue;
            }
            if ("-copyresources".equals(stringArray[i])) {
                builder.copyResources(true);
                continue;
            }
            if ("-configdir".equals(stringArray[i])) {
                builder.configDirectory(stringArray[++i]);
                continue;
            }
            if ("-jarprefix".equals(stringArray[i])) {
                builder.jarPrefix(stringArray[++i]);
                continue;
            }
            if ("-properties".equals(stringArray[i])) {
                builder.properties(stringArray[++i]);
                continue;
            }
            if ("-propertyfile".equals(stringArray[i])) {
                builder.propertyFile(stringArray[++i]);
                continue;
            }
            if (stringArray[i].startsWith("-D")) {
                builder.property(stringArray[i].length() > 2 ? stringArray[i].substring(2) : stringArray[++i]);
                continue;
            }
            if ("-Xcompiler".equals(stringArray[i])) {
                builder.compilerOptions(stringArray[++i]);
                continue;
            }
            if ("-clear".equals(stringArray[i])) {
                bl = true;
                continue;
            }
            if ("-mod".equals(stringArray[i])) {
                string = stringArray[++i];
                continue;
            }
            if ("-exec".equals(stringArray[i])) {
                stringArray2 = Arrays.copyOfRange(stringArray, i + 1, stringArray.length);
                i = stringArray.length;
                continue;
            }
            if ("-print".equals(stringArray[i])) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                builder.logger.error("Invalid option \"" + stringArray[i] + "\"");
                Builder.printHelp();
                System.exit(1);
                continue;
            }
            object2 = stringArray[i];
            if (((String)object2).endsWith(".java")) {
                void object3;
                arrayList = new ArrayList<String>(Arrays.asList("javac", "-cp"));
                String string3 = System.getProperty("java.class.path");
                for (String string4 : builder.classScanner.getClassLoader().getPaths()) {
                    String string5 = (String)object3 + File.pathSeparator + string4;
                }
                arrayList.add((String)object3);
                arrayList.add((String)object2);
                int n = builder.commandExecutor.executeCommand(arrayList, builder.workingDirectory, builder.environmentVariables);
                if (n != 0) {
                    throw new RuntimeException("Could not compile " + (String)object2 + ": " + n);
                }
                object2 = ((String)object2).replace(File.separatorChar, '.').replace('/', '.').substring(0, ((String)object2).length() - 5);
            }
            builder.classesOrPackages(new String[]{object2});
            bl2 = true;
        }
        if (bl) {
            Loader.clearCacheDir();
        }
        if (string2 != null) {
            Collection<Class> collection = builder.classScanner.getClasses();
            object2 = Loader.loadProperties(collection.toArray(new Class[collection.size()]), builder.properties, true);
            builder.includeJavaPaths((ClassProperties)object2, builder.header);
            for (String string6 : ((ClassProperties)object2).get(string2)) {
                System.out.println(string6);
            }
            System.exit(0);
        } else if (!bl && !bl2) {
            Builder.printHelp();
            System.exit(2);
        }
        File[] fileArray = builder.build();
        object2 = builder.classScanner.getClasses();
        if (string != null) {
            arrayList = object2.iterator().next();
            String string7 = ((Class)((Object)arrayList)).getPackage().getName();
            String string8 = "open module " + string7 + "." + builder.properties.getProperty("platform").replace('-', '.') + " {\n  requires transitive " + string7 + ";\n}\n";
            Path path = Paths.get(string, new String[0]);
            Path path2 = path.getParent();
            if (path2 != null) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            Files.write(path, string8.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (fileArray != null && fileArray.length > 0 && !object2.isEmpty() && stringArray2 != null) {
            arrayList = (Class)object2.iterator().next();
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList("java", "-cp"));
            String string9 = System.getProperty("java.class.path");
            for (String string10 : builder.classScanner.getClassLoader().getPaths()) {
                string9 = string9 + File.pathSeparator + string10;
            }
            arrayList2.add(string9);
            arrayList2.add(((Class)((Object)arrayList)).getCanonicalName());
            arrayList2.addAll(Arrays.asList(stringArray2));
            System.exit(builder.commandExecutor.executeCommand(arrayList2, builder.workingDirectory, builder.environmentVariables));
        }
    }
}

