/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.Predicate;
import dorkbox.collections.Select;
import dorkbox.collections.StateException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterable;
import kotlin.jvm.internal.markers.KMutableIterator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 x*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003vwxB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB%\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000eB\u0015\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010B-\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u001b\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J#\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u00002\u0006\u0010/\u001a\u00028\u0000\u00a2\u0006\u0002\u00100J+\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u00002\u0006\u0010/\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0000\u00a2\u0006\u0002\u00102J\u0016\u00103\u001a\u00020)2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J&\u00103\u001a\u00020)2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J)\u00103\u001a\u00020)2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u00104J\u001f\u00103\u001a\u00020)2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f\"\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u00105\u001a\u00020)J\u001d\u00106\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0007\u00a2\u0006\u0002\u00108J\u001e\u00109\u001a\u00020\u00072\u000e\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00107\u001a\u00020\u0007J\u001e\u0010;\u001a\u00020\u00072\u000e\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00107\u001a\u00020\u0007J\u001b\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010=\u001a\u00020\u0004\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\u00020\u00072\b\u0010@\u001a\u0004\u0018\u00010AH\u0096\u0002J\u000e\u0010B\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AJ\r\u0010C\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u00028\u00002\u0006\u0010F\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u00020\u0004H\u0016J\u001d\u0010I\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0007\u00a2\u0006\u0002\u0010JJ\u001b\u0010K\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ\u0016\u0010M\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010N\u001a\u00020\u0007J\u000f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000PH\u0096\u0002J\u001d\u0010Q\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0007\u00a2\u0006\u0002\u0010JJ\u0006\u0010R\u001a\u00020\u0007J\r\u0010S\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010DJ\r\u0010T\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010DJ\r\u0010U\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010DJ\u001e\u0010V\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00107\u001a\u00020\u0007J\u0015\u0010W\u001a\u0004\u0018\u00018\u00002\u0006\u0010F\u001a\u00020\u0004\u00a2\u0006\u0002\u0010GJ\u0016\u0010X\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u0004J\u001d\u0010Z\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0007\u00a2\u0006\u0002\u00108J\u001d\u0010[\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010\\\u001a\u00020\u0004H\u0004\u00a2\u0006\u0002\u0010>J\u0006\u0010]\u001a\u00020)J\u001c\u0010^\u001a\b\u0012\u0004\u0012\u00028\u00000_2\u000e\u0010`\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010aJ%\u0010b\u001a\u0004\u0018\u00018\u00002\u000e\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000d2\u0006\u0010e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010fJ\u001e\u0010g\u001a\u00020\u00042\u000e\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000d2\u0006\u0010e\u001a\u00020\u0004J\u001e\u0010h\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010*\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010LJ\u001b\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010\\\u001a\u00020\u0004\u00a2\u0006\u0002\u0010>J\u0013\u0010i\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010j\u001a\u00020)J\u0006\u0010k\u001a\u00020)J\u0018\u0010k\u001a\u00020)2\u0010\u0010c\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000dJ\u0016\u0010l\u001a\u00020)2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u0004J\u0011\u0010n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u001bJ'\u0010n\u001a\b\u0012\u0004\u0012\u0002Ho0\u000f\"\u0004\b\u0001\u0010o2\u000e\u0010p\u001a\n\u0012\u0004\u0012\u0002Ho\u0018\u00010\n\u00a2\u0006\u0002\u0010qJ\b\u0010r\u001a\u00020sH\u0016J\u000e\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020sJ\u000e\u0010u\u001a\u00020)2\u0006\u0010\\\u001a\u00020\u0004R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u0010R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0005\u00a8\u0006y"}, d2={"Ldorkbox/collections/ExpandingArray;", "T", "", "capacity", "", "(I)V", "ordered", "", "(ZI)V", "arrayType", "Ljava/lang/Class;", "(ZILjava/lang/Class;)V", "(Ljava/lang/Class;)V", "array", "(Ldorkbox/collections/ExpandingArray;)V", "", "([Ljava/lang/Object;)V", "start", "count", "(Z[Ljava/lang/Object;II)V", "allocateIterators", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "items", "getItems", "()[Ljava/lang/Object;", "setItems", "[Ljava/lang/Object;", "iterable", "Ldorkbox/collections/ExpandingArray$ArrayIterable;", "getOrdered", "setOrdered", "predicateIterable", "Ldorkbox/collections/Predicate$PredicateIterable;", "size", "getSize", "()I", "setSize", "add", "", "value", "(Ljava/lang/Object;)V", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;)V", "value3", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "value4", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "addAll", "([Ljava/lang/Object;II)V", "clear", "contains", "identity", "(Ljava/lang/Object;Z)Z", "containsAll", "values", "containsAny", "ensureCapacity", "additionalCapacity", "(I)[Ljava/lang/Object;", "equals", "other", "", "equalsIdentity", "first", "()Ljava/lang/Object;", "get", "index", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;Z)I", "insert", "(ILjava/lang/Object;)V", "insertRange", "isEmpty", "iterator", "Ldorkbox/collections/ExpandingArray$ArrayIterator;", "lastIndexOf", "notEmpty", "peek", "pop", "random", "removeAll", "removeIndex", "removeRange", "end", "removeValue", "resize", "newSize", "reverse", "select", "", "predicate", "Ldorkbox/collections/Predicate;", "selectRanked", "comparator", "Ljava/util/Comparator;", "kthLowest", "(Ljava/util/Comparator;I)Ljava/lang/Object;", "selectRankedIndex", "set", "shrink", "shuffle", "sort", "swap", "second", "toArray", "V", "type", "(Ljava/lang/Class;)[Ljava/lang/Object;", "toString", "", "separator", "truncate", "ArrayIterable", "ArrayIterator", "Companion", "Collections"})
public final class ExpandingArray<T>
implements Iterable<T>,
KMutableIterable {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private T[] items;
    private int size;
    private boolean ordered;
    private ArrayIterable<T> iterable;
    private Predicate.PredicateIterable<T> predicateIterable;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final T[] getItems() {
        return this.items;
    }

    public final void setItems(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.items = TArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final boolean getOrdered() {
        return this.ordered;
    }

    public final void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public ExpandingArray(int n) {
        this(true, n);
    }

    public ExpandingArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new Object[n];
    }

    public /* synthetic */ ExpandingArray(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            n = 16;
        }
        this(bl, n);
    }

    public ExpandingArray(boolean bl, int n, Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this.ordered = bl;
        Object object = Array.newInstance(clazz, n);
        Intrinsics.checkNotNull((Object)object);
        this.items = (Object[])object;
    }

    public ExpandingArray(Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this(true, 16, clazz);
    }

    public ExpandingArray(ExpandingArray<? extends T> expandingArray) {
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        boolean bl = expandingArray.ordered;
        int n = expandingArray.size;
        Class<?> clazz = expandingArray.items.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz);
        this(bl, n, clazz);
        this.size = expandingArray.size;
        System.arraycopy(expandingArray.items, 0, this.items, 0, this.size);
    }

    public ExpandingArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this(true, TArray, 0, TArray.length);
    }

    public ExpandingArray(boolean bl, T[] TArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        Class<?> clazz = TArray.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz);
        this(bl, n2, clazz);
        this.size = n2;
        System.arraycopy(TArray, n, this.items, 0, this.size);
    }

    public final void add(T t) {
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        int n = this.size;
        this.size = n + 1;
        TArray[n] = t;
    }

    public final void add(T t, T t2) {
        T[] TArray = this.items;
        if (this.size + 1 >= TArray.length) {
            TArray = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        TArray[this.size] = t;
        TArray[this.size + 1] = t2;
        this.size += 2;
    }

    public final void add(T t, T t2, T t3) {
        T[] TArray = this.items;
        if (this.size + 2 >= TArray.length) {
            TArray = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        TArray[this.size] = t;
        TArray[this.size + 1] = t2;
        TArray[this.size + 2] = t3;
        this.size += 3;
    }

    public final void add(T t, T t2, T t3, T t4) {
        T[] TArray = this.items;
        if (this.size + 3 >= TArray.length) {
            TArray = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.8f))));
        }
        TArray[this.size] = t;
        TArray[this.size + 1] = t2;
        TArray[this.size + 2] = t3;
        TArray[this.size + 3] = t4;
        this.size += 4;
    }

    public final void addAll(ExpandingArray<? extends T> expandingArray) {
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        this.addAll(expandingArray.items, 0, expandingArray.size);
    }

    public final void addAll(ExpandingArray<? extends T> expandingArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        if (n + n2 > expandingArray.size) {
            throw new StateException("start + count must be <= size: " + n + " + " + n2 + " <= " + expandingArray.size);
        }
        this.addAll(expandingArray.items, n, n2);
    }

    public final void addAll(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.addAll(TArray, 0, TArray.length);
    }

    public final void addAll(T[] TArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        T[] TArray2 = this.items;
        int n3 = this.size + n2;
        if (n3 > TArray2.length) {
            TArray2 = this.resize((int)Math.max(Math.max(8.0, (double)n3), (double)((int)((float)this.size * 1.75f))));
        }
        System.arraycopy(TArray, n, TArray2, this.size, n2);
        this.size = n3;
    }

    public final T get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        T t = this.items[n];
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void set(int n, T t) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = t;
    }

    public final void insert(int n, T t) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        if (this.ordered) {
            System.arraycopy(TArray, n, TArray, n + 1, this.size - n);
        } else {
            TArray[this.size] = TArray[n];
        }
        int n2 = this.size;
        this.size = n2 + 1;
        TArray[n] = t;
    }

    public final void insertRange(int n, int n2) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        int n3 = this.size + n2;
        if (n3 > this.items.length) {
            this.items = this.resize((int)Math.max(Math.max(8.0, (double)n3), (double)((int)((float)this.size * 1.75f))));
        }
        System.arraycopy(this.items, n, this.items, n + n2, this.size - n);
        this.size = n3;
    }

    public final void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = TArray[n];
        TArray[n] = TArray[n2];
        TArray[n2] = t;
    }

    public final boolean contains(T t, boolean bl) {
        T[] TArray = this.items;
        int n = this.size - 1;
        if (bl || t == null) {
            while (n >= 0) {
                if (TArray[n--] != t) continue;
                return true;
            }
        } else {
            while (n >= 0) {
                if (!Intrinsics.areEqual(t, TArray[n--])) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean containsAll(ExpandingArray<? extends T> expandingArray, boolean bl) {
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        T[] TArray = expandingArray.items;
        int n = expandingArray.size;
        for (int i = 0; i < n; ++i) {
            if (this.contains(TArray[i], bl)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAny(ExpandingArray<? extends T> expandingArray, boolean bl) {
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        T[] TArray = expandingArray.items;
        int n = expandingArray.size;
        for (int i = 0; i < n; ++i) {
            if (!this.contains(TArray[i], bl)) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(t, TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int lastIndexOf(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            for (int i = this.size - 1; -1 < i; --i) {
                if (TArray[i] != t) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; -1 < i; --i) {
                if (!Intrinsics.areEqual(t, TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean removeValue(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(t, TArray[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public final T removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = TArray[n];
        int n2 = this.size;
        this.size = n2 + -1;
        if (this.ordered) {
            System.arraycopy(TArray, n + 1, TArray, n, this.size - n);
        } else {
            TArray[n] = TArray[this.size];
        }
        TArray[this.size] = null;
        return t;
    }

    public final void removeRange(int n, int n2) {
        int n3;
        int n4 = this.size;
        if (n2 >= n4) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        T[] TArray = this.items;
        int n5 = n2 - n + 1;
        int n6 = n4 - n5;
        if (this.ordered) {
            System.arraycopy(TArray, n + n5, TArray, n, n4 - (n + n5));
        } else {
            n3 = (int)Math.max((double)n6, (double)(n2 + 1));
            System.arraycopy(TArray, n3, TArray, n, n4 - n3);
        }
        for (n3 = n6; n3 < n4; ++n3) {
            TArray[n3] = null;
        }
        this.size = n4 - n5;
    }

    public final boolean removeAll(ExpandingArray<? extends T> expandingArray, boolean bl) {
        int n;
        Intrinsics.checkNotNullParameter(expandingArray, (String)"");
        int n2 = n = this.size;
        T[] TArray = this.items;
        if (bl) {
            int n3 = expandingArray.size;
            block0: for (int i = 0; i < n3; ++i) {
                T t = expandingArray.get(i);
                int n4 = n;
                for (int j = 0; j < n4; ++j) {
                    if (t != TArray[j]) continue;
                    this.removeIndex(j);
                    --n;
                    continue block0;
                }
            }
        } else {
            int n5 = expandingArray.size;
            block2: for (int i = 0; i < n5; ++i) {
                T t = expandingArray.get(i);
                int n6 = n;
                for (int j = 0; j < n6; ++j) {
                    if (!Intrinsics.areEqual(t, TArray[j])) continue;
                    this.removeIndex(j);
                    --n;
                    continue block2;
                }
            }
        }
        return n != n2;
    }

    public final T pop() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        this.size += -1;
        T t = this.items[this.size];
        this.items[this.size] = null;
        return t;
    }

    public final T peek() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.items[this.size - 1];
    }

    public final T first() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.items[0];
    }

    public final boolean notEmpty() {
        return this.size > 0;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        Arrays.fill(this.items, 0, this.size, null);
        this.size = 0;
    }

    public final T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public final T[] ensureCapacity(int n) {
        if (n < 0) {
            throw new StateException("additionalCapacity must be >= 0: " + n);
        }
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize((int)Math.max(Math.max(8.0, (double)n2), (double)((int)((float)this.size * 1.75f))));
        }
        return this.items;
    }

    public final T[] setSize(int n) {
        this.truncate(n);
        if (n > this.items.length) {
            this.resize((int)Math.max(8.0, (double)n));
        }
        this.size = n;
        return this.items;
    }

    protected final T[] resize(int n) {
        T[] TArray = this.items;
        Object object = Array.newInstance(TArray.getClass().getComponentType(), n);
        Intrinsics.checkNotNull((Object)object);
        Object[] objectArray = (Object[])object;
        System.arraycopy(TArray, 0, objectArray, 0, (int)Math.min((double)this.size, (double)objectArray.length));
        this.items = objectArray;
        return objectArray;
    }

    public final void sort() {
        ArraysKt.sort((Object[])this.items, (int)0, (int)this.size);
    }

    public final void sort(Comparator<? super T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        ArraysKt.sortWith((Object[])this.items, comparator, (int)0, (int)this.size);
    }

    public final T selectRanked(Comparator<T> comparator, int n) {
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        if (n < 1) {
            throw new RuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.Companion.instance().select(this.items, comparator, n, this.size);
    }

    public final int selectRankedIndex(Comparator<T> comparator, int n) {
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        if (n < 1) {
            throw new RuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.Companion.instance().selectIndex(this.items, comparator, n, this.size);
    }

    public final void reverse() {
        T[] TArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            T t = TArray[i];
            TArray[i] = TArray[n3];
            TArray[n3] = t;
        }
    }

    public final void shuffle() {
        T[] TArray = this.items;
        for (int i = this.size - 1; -1 < i; --i) {
            int n = Collections.INSTANCE.random(i);
            T t = TArray[i];
            TArray[i] = TArray[n];
            TArray[n] = t;
        }
    }

    @Override
    public ArrayIterator<T> iterator() {
        if (this.allocateIterators) {
            return new ArrayIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this, false, 2, null);
        }
        ArrayIterable<T> arrayIterable = this.iterable;
        Intrinsics.checkNotNull(arrayIterable);
        return arrayIterable.iterator();
    }

    public final Iterable<T> select(Predicate<T> predicate) {
        if (this.allocateIterators) {
            return new Predicate.PredicateIterable<T>(this, predicate);
        }
        if (this.predicateIterable == null) {
            this.predicateIterable = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            Predicate.PredicateIterable<T> predicateIterable = this.predicateIterable;
            Intrinsics.checkNotNull(predicateIterable);
            predicateIterable.set(this, predicate);
        }
        Predicate.PredicateIterable<T> predicateIterable = this.predicateIterable;
        Intrinsics.checkNotNull(predicateIterable);
        return predicateIterable;
    }

    public final void truncate(int n) {
        if (n < 0) {
            throw new StateException("newSize must be >= 0: " + n);
        }
        if (this.size <= n) {
            return;
        }
        int n2 = this.size;
        for (int i = n; i < n2; ++i) {
            this.items[i] = null;
        }
        this.size = n;
    }

    public final T random() {
        return this.size == 0 ? null : (T)this.items[Collections.INSTANCE.random(0, this.size - 1)];
    }

    public final T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public final <V> V[] toArray(Class<V> clazz) {
        Object object = Array.newInstance(clazz, this.size);
        Intrinsics.checkNotNull((Object)object);
        Object[] objectArray = (Object[])object;
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] TArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n *= 31;
            T t = TArray[i];
            if (t == null) continue;
            n += t.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ExpandingArray)) {
            return false;
        }
        ExpandingArray cfr_ignored_0 = (ExpandingArray)object;
        if (!((ExpandingArray)object).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ExpandingArray)object).size) {
            return false;
        }
        T[] TArray = this.items;
        T[] TArray2 = ((ExpandingArray)object).items;
        for (int i = 0; i < n; ++i) {
            T t = TArray[i];
            T t2 = TArray2[i];
            T t3 = t;
            if (t3 == null ? t2 == null : Intrinsics.areEqual(t3, t2)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ExpandingArray)) {
            return false;
        }
        ExpandingArray cfr_ignored_0 = (ExpandingArray)object;
        if (!((ExpandingArray)object).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ExpandingArray)object).size) {
            return false;
        }
        T[] TArray = this.items;
        T[] TArray2 = ((ExpandingArray)object).items;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(TArray[0]);
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i]);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String toString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (this.size == 0) {
            return "";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(TArray[0]);
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(TArray[i]);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\tH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/collections/ExpandingArray$ArrayIterable;", "T", "", "array", "Ldorkbox/collections/ExpandingArray;", "allowRemove", "", "(Ldorkbox/collections/ExpandingArray;Z)V", "iterator1", "Ldorkbox/collections/ExpandingArray$ArrayIterator;", "iterator2", "iterator", "Collections"})
    public static final class ArrayIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        private final ExpandingArray<T> array;
        private final boolean allowRemove;
        private ArrayIterator<T> iterator1;
        private ArrayIterator<T> iterator2;

        public ArrayIterable(ExpandingArray<T> expandingArray, boolean bl) {
            Intrinsics.checkNotNullParameter(expandingArray, (String)"");
            this.array = expandingArray;
            this.allowRemove = bl;
        }

        public /* synthetic */ ArrayIterable(ExpandingArray expandingArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(expandingArray, bl);
        }

        @Override
        public ArrayIterator<T> iterator() {
            if (this.array.getAllocateIterators()) {
                return new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ArrayIterator<T>(this.array, this.allowRemove);
                this.iterator2 = new ArrayIterator<T>(this.array, this.allowRemove);
            }
            ArrayIterator<T> arrayIterator = this.iterator1;
            Intrinsics.checkNotNull(arrayIterator);
            if (!arrayIterator.getValid()) {
                ArrayIterator<T> arrayIterator2 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator2);
                arrayIterator2.setIndex(0);
                ArrayIterator<T> arrayIterator3 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator3);
                arrayIterator3.setValid(true);
                ArrayIterator<T> arrayIterator4 = this.iterator2;
                Intrinsics.checkNotNull(arrayIterator4);
                arrayIterator4.setValid(false);
                ArrayIterator<T> arrayIterator5 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator5);
                return arrayIterator5;
            }
            ArrayIterator<T> arrayIterator6 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator6);
            arrayIterator6.setIndex(0);
            ArrayIterator<T> arrayIterator7 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator7);
            arrayIterator7.setValid(true);
            ArrayIterator<T> arrayIterator8 = this.iterator1;
            Intrinsics.checkNotNull(arrayIterator8);
            arrayIterator8.setValid(false);
            ArrayIterator<T> arrayIterator9 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator9);
            return arrayIterator9;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0007H\u0096\u0002J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u0016\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Ldorkbox/collections/ExpandingArray$ArrayIterator;", "T", "", "", "array", "Ldorkbox/collections/ExpandingArray;", "allowRemove", "", "(Ldorkbox/collections/ExpandingArray;Z)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "valid", "getValid", "()Z", "setValid", "(Z)V", "hasNext", "iterator", "next", "()Ljava/lang/Object;", "remove", "", "reset", "Collections"})
    public static final class ArrayIterator<T>
    implements Iterable<T>,
    Iterator<T>,
    KMappedMarker,
    KMutableIterator {
        private final ExpandingArray<T> array;
        private final boolean allowRemove;
        private int index;
        private boolean valid;

        public ArrayIterator(ExpandingArray<T> expandingArray, boolean bl) {
            Intrinsics.checkNotNullParameter(expandingArray, (String)"");
            this.array = expandingArray;
            this.allowRemove = bl;
            this.valid = true;
        }

        public /* synthetic */ ArrayIterator(ExpandingArray expandingArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(expandingArray, bl);
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.getSize();
        }

        @Override
        public T next() {
            if (this.index >= this.array.getSize()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            T t = this.array.getItems()[n];
            Intrinsics.checkNotNull(t);
            return t;
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new RuntimeException("Remove not allowed.");
            }
            int n = this.index;
            this.index = n + -1;
            this.array.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @Override
        public ArrayIterator<T> iterator() {
            return this;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ0\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u0010\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldorkbox/collections/ExpandingArray$Companion;", "", "()V", "version", "", "of", "Ldorkbox/collections/ExpandingArray;", "T", "arrayType", "Ljava/lang/Class;", "ordered", "", "capacity", "", "with", "array", "", "([Ljava/lang/Object;)Ldorkbox/collections/ExpandingArray;", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> ExpandingArray<T> of(Class<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"");
            return new ExpandingArray<T>(clazz);
        }

        public final <T> ExpandingArray<T> of(boolean bl, int n, Class<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"");
            return new ExpandingArray<T>(bl, n, clazz);
        }

        public final <T> ExpandingArray<T> with(T ... TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return new ExpandingArray<T>(TArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

