/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.IdentityMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class IdentitySet<E>
extends AbstractSet<E>
implements Serializable,
Cloneable,
Set<E> {
    private transient IdentityMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public IdentitySet() {
        this.map = new IdentityMap();
    }

    public IdentitySet(Collection<? extends E> collection) {
        this.map = new IdentityMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public IdentitySet(int n) {
        this.map = new IdentityMap(n);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

