/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0006efghijB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\b\u0010@\u001a\u00020AH\u0016J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u0002H\u0016J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020\u0002H\u0016J\u000e\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u0002J\u0006\u0010\u0010\u001a\u00020\u0017J\u0013\u0010I\u001a\u00020\u000b2\b\u0010J\u001a\u0004\u0018\u00010KH\u0096\u0002J\u0017\u0010L\u001a\u0004\u0018\u00010\u00022\b\u0010F\u001a\u0004\u0018\u00010K\u00a2\u0006\u0002\u0010MJ\u0018\u0010L\u001a\u00020\u00022\b\u0010F\u001a\u0004\u0018\u00010K2\u0006\u0010N\u001a\u00020\u0002J\u0018\u0010O\u001a\u0004\u0018\u00010\u00022\u0006\u0010D\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010PJ\"\u0010O\u001a\u0004\u0018\u00010\u00022\u0006\u0010D\u001a\u00020\u00022\b\u0010Q\u001a\u0004\u0018\u00010\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u00020\u0002H\u0016J\b\u0010T\u001a\u00020\u000bH\u0016J\u0006\u0010\"\u001a\u00020%J\u0010\u0010U\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0002H\u0002J\u0006\u0010V\u001a\u00020\u000bJ\u0010\u0010W\u001a\u00020\u00022\u0006\u0010X\u001a\u00020\u0002H\u0004J\u001f\u0010Y\u001a\u0004\u0018\u00010\u00022\u0006\u0010D\u001a\u00020\u00022\u0006\u0010F\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010ZJ\u000e\u0010[\u001a\u00020A2\u0006\u0010\b\u001a\u00020\u0000J\u001e\u0010[\u001a\u00020A2\u0014\u0010\\\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020]H\u0016J\u0018\u0010^\u001a\u00020A2\u0006\u0010D\u001a\u00020\u00022\u0006\u0010F\u001a\u00020\u0002H\u0002J\u0017\u0010_\u001a\u0004\u0018\u00010\u00022\u0006\u0010D\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010PJ\u0010\u0010`\u001a\u00020A2\u0006\u0010a\u001a\u00020\u0002H\u0002J\u000e\u0010b\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002J\b\u0010c\u001a\u00020dH\u0016J\u0006\u00106\u001a\u00020;R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR,\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u0014\u0010/\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010)R\u000e\u00101\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001f\"\u0004\b5\u0010!R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010)\"\u0004\b?\u0010+\u00a8\u0006k"}, d2={"Ldorkbox/collections/IntIntMap;", "", "", "()V", "initialCapacity", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/IntIntMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/IntIntMap$Entries;", "entries2", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/IntIntMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "getValueTable", "setValueTable", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/IntIntMap$Values;", "values2", "zeroValue", "getZeroValue", "setZeroValue", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "ensureCapacity", "additionalCapacity", "equals", "other", "", "findKey", "(Ljava/lang/Object;)Ljava/lang/Integer;", "notFound", "get", "(I)Ljava/lang/Integer;", "defaultValue", "(ILjava/lang/Integer;)Ljava/lang/Integer;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "(II)Ljava/lang/Integer;", "putAll", "from", "", "putResize", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public final class IntIntMap
implements Map<Integer, Integer>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private int[] keyTable;
    private int[] valueTable;
    private int zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries entries1;
    private transient Entries entries2;
    private transient Values values1;
    private transient Values values2;
    private transient Keys keys1;
    private transient Keys keys2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.keyTable = nArray;
    }

    public final int[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.valueTable = nArray;
    }

    public final int getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(int n) {
        this.zeroValue = n;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntIntMap() {
        this(51, 0.8f);
    }

    public IntIntMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n2];
        this.valueTable = new int[n2];
    }

    public /* synthetic */ IntIntMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntIntMap(IntIntMap intIntMap) {
        Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
        this((int)((float)intIntMap.keyTable.length * intIntMap.loadFactor), intIntMap.loadFactor);
        System.arraycopy(intIntMap.keyTable, 0, this.keyTable, 0, intIntMap.keyTable.length);
        System.arraycopy(intIntMap.valueTable, 0, this.valueTable, 0, intIntMap.valueTable.length);
        this.size_ = intIntMap.size_;
        this.zeroValue = intIntMap.zeroValue;
        this.hasZeroValue = intIntMap.hasZeroValue;
    }

    protected final int place(int n) {
        return (int)((long)n * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        int n3;
        while ((n3 = nArray[n2]) != 0) {
            if (n3 == n) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    @Override
    public Integer put(int n, int n2) {
        if (n == 0) {
            int n3 = this.zeroValue;
            this.zeroValue = n2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                int n4 = this.size_;
                this.size_ = n4 + 1;
            }
            return n3;
        }
        int n5 = this.locateKey(n);
        if (n5 >= 0) {
            int n6 = this.valueTable[n5];
            this.valueTable[n5] = n2;
            return n6;
        }
        n5 = -(n5 + 1);
        this.keyTable[n5] = n;
        this.valueTable[n5] = n2;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public final void putAll(IntIntMap intIntMap) {
        Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
        this.ensureCapacity(intIntMap.size_);
        if (intIntMap.hasZeroValue) {
            this.put(0, intIntMap.zeroValue);
        }
        int[] nArray = intIntMap.keyTable;
        int[] nArray2 = intIntMap.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            this.put(n2, nArray2[i]);
        }
    }

    private final void putResize(int n, int n2) {
        int[] nArray = this.keyTable;
        int n3 = this.place(n);
        while (true) {
            if (nArray[n3] == 0) {
                nArray[n3] = n;
                this.valueTable[n3] = n2;
                return;
            }
            n3 = n3 + 1 & this.mask;
        }
    }

    public Integer get(int n) {
        if (n == 0) {
            return this.hasZeroValue ? Integer.valueOf(this.zeroValue) : null;
        }
        int n2 = this.locateKey(n);
        return n2 >= 0 ? Integer.valueOf(this.valueTable[n2]) : null;
    }

    public final Integer get(int n, Integer n2) {
        if (n == 0) {
            return this.hasZeroValue ? Integer.valueOf(this.zeroValue) : n2;
        }
        int n3 = this.locateKey(n);
        return n3 >= 0 ? Integer.valueOf(this.valueTable[n3]) : n2;
    }

    public Integer remove(int n) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            int n3 = this.zeroValue;
            this.zeroValue = 0;
            int n4 = this.size_;
            this.size_ = n4 + -1;
            return n3;
        }
        int n5 = this.locateKey(n);
        if (n5 < 0) {
            return null;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n6 = nArray2[n5];
        int n7 = this.mask;
        int n8 = n5 + 1 & n7;
        int n9 = 0;
        while (true) {
            int n10 = n2 = nArray[n8];
            boolean bl = false;
            n9 = n10;
            if (n2 == 0) break;
            n2 = this.place(n9);
            if ((n8 - n2 & n7) > (n5 - n2 & n7)) {
                nArray[n5] = n9;
                nArray2[n5] = nArray2[n8];
                n5 = n8;
            }
            n8 = n8 + 1 & n7;
        }
        nArray[n5] = 0;
        nArray2[n5] = 0;
        n2 = this.size_;
        this.size_ = n2 + -1;
        return n6;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.ensureCapacity(map.size());
        Iterable iterable = map.entrySet();
        boolean bl = false;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            boolean bl2 = false;
            int n = ((Number)entry.getKey()).intValue();
            int n2 = ((Number)entry.getValue()).intValue();
            this.put(n, n2);
        }
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public final void clear(int n) {
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = 0;
        this.resize(n2);
    }

    public Set<Map.Entry<Integer, Integer>> getEntries() {
        Entries entries = this.entries();
        Intrinsics.checkNotNull((Object)entries);
        return TypeIntrinsics.asMutableSet((Object)entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    public Set<Integer> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    public Collection<Integer> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, 0);
        this.zeroValue = 0;
        this.hasZeroValue = false;
    }

    public boolean containsValue(int n) {
        int[] nArray = this.valueTable;
        if (n == 0) {
            if (this.hasZeroValue && this.zeroValue == 0) {
                return true;
            }
            int[] nArray2 = this.keyTable;
            int n2 = nArray.length + -1;
            if (0 <= n2) {
                do {
                    int n3;
                    if (nArray2[n3 = n2--] == 0 || nArray[n3] != 0) continue;
                    return true;
                } while (0 <= n2);
            }
        } else {
            if (n == this.zeroValue) {
                return true;
            }
            int n4 = nArray.length + -1;
            if (0 <= n4) {
                do {
                    int n5;
                    if (nArray[n5 = n4--] != n) continue;
                    return true;
                } while (0 <= n4);
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        return n == 0 ? this.hasZeroValue : this.locateKey(n) >= 0;
    }

    public final Integer findKey(Object object) {
        int[] nArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == 0) {
                return 0;
            }
            int[] nArray2 = this.keyTable;
            int n = nArray.length + -1;
            if (0 <= n) {
                do {
                    int n2;
                    if (nArray2[n2 = n--] == 0 || nArray[n2] != 0) continue;
                    return nArray2[n2];
                } while (0 <= n);
            }
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)this.zeroValue)) {
                return 0;
            }
            int n = nArray.length + -1;
            if (0 <= n) {
                do {
                    int n3 = n--;
                    Object object2 = object;
                    if (!(object2 instanceof Integer) || nArray[n3] != ((Number)object2).intValue()) continue;
                    return this.keyTable[n3];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final int findKey(Object object, int n) {
        Integer n2 = this.findKey(object);
        return n2 != null ? n2 : n;
    }

    public final void ensureCapacity(int n) {
        int n2 = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        this.keyTable = new int[n];
        this.valueTable = new int[n];
        if (this.size_ > 0) {
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                if (n3 == 0) continue;
                this.putResize(n3, nArray2[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size_;
        if (this.hasZeroValue && this.zeroValue != 0) {
            n += Integer.hashCode(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            n += n3 * 31;
            int n4 = nArray2[i];
            if (n4 == 0) continue;
            n += Integer.hashCode(n4);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntIntMap)) {
            return false;
        }
        if (((IntIntMap)object).size_ != this.size_) {
            return false;
        }
        if (((IntIntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntIntMap)object).zeroValue == 0 ? this.zeroValue != 0 : ((IntIntMap)object).zeroValue != this.zeroValue)) {
            return false;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            int n3 = nArray2[i];
            if (n3 == 0) {
                if (((IntIntMap)object).get((Object)n2) == null) continue;
                return false;
            }
            Integer n4 = (Integer)((IntIntMap)object).get((Object)n2);
            if (n4 != null && n3 == n4) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                stringBuilder.append('=');
                stringBuilder.append(nArray2[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(nArray2[n2]);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final Entries entries() {
        if (this.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries entries = this.entries1;
        Intrinsics.checkNotNull((Object)entries);
        if (!entries.getValid()) {
            Entries entries2 = this.entries1;
            Intrinsics.checkNotNull((Object)entries2);
            entries2.reset();
            Entries entries3 = this.entries1;
            Intrinsics.checkNotNull((Object)entries3);
            entries3.setValid(true);
            Entries entries4 = this.entries2;
            Intrinsics.checkNotNull((Object)entries4);
            entries4.setValid(false);
            Entries entries5 = this.entries1;
            Intrinsics.checkNotNull((Object)entries5);
            return entries5;
        }
        Entries entries6 = this.entries2;
        Intrinsics.checkNotNull((Object)entries6);
        entries6.reset();
        Entries entries7 = this.entries2;
        Intrinsics.checkNotNull((Object)entries7);
        entries7.setValid(true);
        Entries entries8 = this.entries1;
        Intrinsics.checkNotNull((Object)entries8);
        entries8.setValid(false);
        Entries entries9 = this.entries2;
        Intrinsics.checkNotNull((Object)entries9);
        return entries9;
    }

    public final Values values() {
        if (this.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values values = this.values1;
        Intrinsics.checkNotNull((Object)values);
        if (!values.getValid()) {
            Values values2 = this.values1;
            Intrinsics.checkNotNull((Object)values2);
            values2.reset();
            Values values3 = this.values1;
            Intrinsics.checkNotNull((Object)values3);
            values3.setValid(true);
            Values values4 = this.values2;
            Intrinsics.checkNotNull((Object)values4);
            values4.setValid(false);
            Values values5 = this.values1;
            Intrinsics.checkNotNull((Object)values5);
            return values5;
        }
        Values values6 = this.values2;
        Intrinsics.checkNotNull((Object)values6);
        values6.reset();
        Values values7 = this.values2;
        Intrinsics.checkNotNull((Object)values7);
        values7.setValid(true);
        Values values8 = this.values1;
        Intrinsics.checkNotNull((Object)values8);
        values8.setValid(false);
        Values values9 = this.values2;
        Intrinsics.checkNotNull((Object)values9);
        return values9;
    }

    public final Keys keys() {
        if (this.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        return this.put(((Number)object).intValue(), ((Number)object2).intValue());
    }

    @Override
    public final /* synthetic */ Object get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final Integer get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final /* synthetic */ Object remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final Integer remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final Set<Map.Entry<Integer, Integer>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<Integer> keySet() {
        return this.getKeys();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Collection<Integer> values() {
        return this.getValues();
    }

    @Override
    public final boolean containsValue(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.containsValue(((Number)object).intValue());
    }

    @Override
    public final boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.containsKey(((Number)object).intValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/IntIntMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ldorkbox/collections/IntIntMap$Entries;", "", "Ldorkbox/collections/IntIntMap$Entry;", "Ldorkbox/collections/IntIntMap$MapIterator;", "", "map", "Ldorkbox/collections/IntIntMap;", "(Ldorkbox/collections/IntIntMap;)V", "entry", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static final class Entries
    extends MapIterator<Integer, Entry>
    implements Set<Entry>,
    KMutableSet {
        private final Entry entry;

        public Entries(IntIntMap intIntMap) {
            Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
            super(intIntMap);
            this.entry = new Entry(intIntMap);
        }

        @Override
        public Entry next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(nArray[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Entry> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                this.getMap().put(entry.getKey(), entry.getValue());
                bl = true;
            }
            return bl;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl2 = false;
                int n = ((Number)((Map.Entry)entry).getKey()).intValue();
                int n2 = ((Number)((Map.Entry)entry).getValue()).intValue();
                Integer n3 = (Integer)this.getMap().get((Object)n);
                int n4 = n2;
                if (n3 != null && n3 == n4) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            Integer n = (Integer)this.getMap().get(entry.getKey());
            int n2 = entry.getValue();
            return n != null && n == n2;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            boolean bl;
            int n;
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl2 = false;
            if (this.getMap().getHasZeroValue()) {
                boolean bl3;
                Object v0;
                block5: {
                    Iterable iterable = collection;
                    n = 0;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        bl = false;
                        if (!(entry.getKey() == 0)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                boolean bl4 = bl3 = v0 != null;
                if (bl3) {
                    bl2 = this.getMap().remove((Object)0) != null;
                }
            }
            int[] nArray = this.getMap().getKeyTable();
            boolean bl5 = false;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                boolean bl6;
                Object v2;
                int n3;
                block6: {
                    int n4;
                    n3 = n4 = nArray[n];
                    bl = false;
                    if (n3 == 0) continue;
                    Iterable iterable = collection;
                    boolean bl7 = false;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        boolean bl8 = false;
                        if (!(entry.getKey() == n3)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                boolean bl9 = bl6 = v2 != null;
                if (bl6) continue;
                bl2 = this.getMap().remove((Object)n3) != null || bl2;
            }
            this.reset();
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                int n = ((Number)((Map.Entry)entry).getKey()).intValue();
                bl = this.getMap().remove((Object)n) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            boolean bl = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\n\u00a8\u0006\u0014"}, d2={"Ldorkbox/collections/IntIntMap$Entry;", "", "", "map", "Ldorkbox/collections/IntIntMap;", "(Ldorkbox/collections/IntIntMap;)V", "key", "getKey", "()Ljava/lang/Integer;", "setKey", "(I)V", "getMap", "()Ldorkbox/collections/IntIntMap;", "value", "getValue", "setValue", "newValue", "(I)Ljava/lang/Integer;", "toString", "", "Collections"})
    public static final class Entry
    implements Map.Entry<Integer, Integer>,
    KMutableMap.Entry {
        private final IntIntMap map;
        private int key;
        private int value;

        public Entry(IntIntMap intIntMap) {
            Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
            this.map = intIntMap;
        }

        public final IntIntMap getMap() {
            return this.map;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        public void setKey(int n) {
            this.key = n;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void setValue(int n) {
            this.value = n;
        }

        @Override
        public Integer setValue(int n) {
            int n2 = this.getValue();
            Integer n3 = n;
            ((Map)this.map).put(this.getKey(), n3);
            this.setValue(n);
            return n2;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }

        @Override
        public /* synthetic */ Object setValue(Object object) {
            return this.setValue(((Number)object).intValue());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\t\u0010\u0014\u001a\u00020\u000bH\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u001d\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\u0007\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntIntMap$Keys;", "", "", "Ldorkbox/collections/IntIntMap$MapIterator;", "map", "Ldorkbox/collections/IntIntMap;", "(Ldorkbox/collections/IntIntMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    public static final class Keys
    extends MapIterator<Integer, Integer>
    implements Set<Integer>,
    KMutableSet {
        public Keys(IntIntMap intIntMap) {
            Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
            super(intIntMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.getNextIndex() == -1 ? 0 : this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return n;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                int n = ((Number)t).intValue();
                boolean bl3 = false;
                bl = bl || this.getMap().put(n, 0) == null;
            }
            return bl;
        }

        @Override
        public boolean add(int n) {
            return this.getMap().put(n, 0) == null;
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                int n = ((Number)t).intValue();
                boolean bl2 = false;
                if (this.getMap().containsKey((Object)n)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int n) {
            return this.getMap().containsKey((Object)n);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            int[] nArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = n2 = nArray[i];
                boolean bl3 = false;
                if (collection.contains(n3) || this.getMap().remove((Object)n3) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                int n = ((Number)t).intValue();
                boolean bl3 = false;
                if (this.getMap().remove((Object)n) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Integer n) {
            return this.getMap().remove(n) == null;
        }

        public final int[] toArray() {
            int[] nArray = new int[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        public final int[] toArray(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).intValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Integer)) {
                return false;
            }
            return this.contains(((Number)object).intValue());
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntIntMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/IntIntMap;", "(Ldorkbox/collections/IntIntMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/IntIntMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final IntIntMap map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(IntIntMap intIntMap) {
            Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
            this.map = intIntMap;
            this.valid = true;
            this.reset();
        }

        public final IntIntMap getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                int[] nArray = this.map.getKeyTable();
                int n = nArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(0);
            } else {
                int n2;
                if (n < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] nArray = this.map.getKeyTable();
                int[] nArray2 = this.map.getValueTable();
                int n3 = this.map.getMask();
                int n4 = n + 1 & n3;
                int n5 = 0;
                while (true) {
                    int n6;
                    n2 = n6 = nArray[n4];
                    boolean bl = false;
                    n5 = n2;
                    if (n6 == 0) break;
                    n6 = this.map.place(n5);
                    if ((n4 - n6 & n3) > (n - n6 & n3)) {
                        nArray[n] = n5;
                        nArray2[n] = nArray2[n4];
                        n = n4;
                    }
                    n4 = n4 + 1 & n3;
                }
                nArray[n] = 0;
                nArray2[n] = 0;
                if (n != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                IntIntMap intIntMap = this.map;
                n2 = intIntMap.size_;
                intIntMap.size_ = n2 + -1;
            }
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntIntMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\t\u0010\u0014\u001a\u00020\u000bH\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u001d\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0007\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Ldorkbox/collections/IntIntMap$Values;", "", "", "Ldorkbox/collections/IntIntMap$MapIterator;", "map", "Ldorkbox/collections/IntIntMap;", "(Ldorkbox/collections/IntIntMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "Collections"})
    public static final class Values
    extends MapIterator<Integer, Integer>
    implements Collection<Integer>,
    KMutableCollection {
        public Values(IntIntMap intIntMap) {
            Intrinsics.checkNotNullParameter((Object)intIntMap, (String)"");
            super(intIntMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return n;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(int n) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                int n = ((Number)t).intValue();
                boolean bl2 = false;
                if (this.getMap().containsValue((Object)n)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int n) {
            return this.getMap().containsValue((Object)n);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            int[] nArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer n2;
                int n3;
                int n4 = n3 = nArray[i];
                boolean bl3 = false;
                if (n4 == 0 || CollectionsKt.contains((Iterable)collection, (Object)(n2 = (Integer)this.getMap().get((Object)n4)))) continue;
                this.getMap().remove((Object)n4);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                int n = ((Number)t).intValue();
                boolean bl3 = false;
                Integer n2 = this.getMap().findKey(n);
                if (n2 == null) continue;
                bl = this.getMap().remove(n2) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Integer n) {
            boolean bl = false;
            Integer n2 = this.getMap().findKey(n);
            if (n2 != null) {
                bl = this.getMap().remove(n2) != null;
            }
            this.reset();
            return bl;
        }

        public final int[] toArray() {
            int[] nArray = new int[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).intValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Integer)) {
                return false;
            }
            return this.contains(((Number)object).intValue());
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

