/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectMap;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 q*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0006qrstuvB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010I\u001a\u00020JH\u0016J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0006J\u0010\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\u0003H\u0016J\u0017\u0010N\u001a\u00020\r2\b\u0010O\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010PJ\u001a\u0010N\u001a\u00020\r2\b\u0010O\u001a\u0004\u0018\u00010Q2\b\b\u0002\u0010R\u001a\u00020\rJ\u000e\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0019J\u0013\u0010U\u001a\u00020\r2\b\u0010V\u001a\u0004\u0018\u00010QH\u0096\u0002J\u0010\u0010W\u001a\u00020\r2\b\u0010V\u001a\u0004\u0018\u00010QJ\u001f\u0010X\u001a\u0004\u0018\u00010\u00032\b\u0010O\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\r\u00a2\u0006\u0002\u0010YJ \u0010X\u001a\u00020\u00032\b\u0010O\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\u0003J\u0018\u0010[\u001a\u0004\u0018\u00018\u00002\u0006\u0010M\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\\J \u0010[\u001a\u0004\u0018\u00018\u00002\u0006\u0010M\u001a\u00020\u00032\u0006\u0010]\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010^J\b\u0010_\u001a\u00020\u0006H\u0016J\b\u0010`\u001a\u00020\rH\u0016J\u0006\u0010$\u001a\u00020'J\u0010\u0010a\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u0003H\u0002J\u0006\u0010b\u001a\u00020\rJ\u0010\u0010c\u001a\u00020\u00062\u0006\u0010d\u001a\u00020\u0003H\u0004J!\u0010e\u001a\u0004\u0018\u00018\u00002\u0006\u0010M\u001a\u00020\u00032\b\u0010O\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010^J\u0018\u0010f\u001a\u00020J2\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u0000J \u0010f\u001a\u00020J2\u0016\u0010g\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000hH\u0016J\u001f\u0010i\u001a\u00020J2\u0006\u0010M\u001a\u00020\u00032\b\u0010O\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010jJ\u0017\u0010k\u001a\u0004\u0018\u00018\u00002\u0006\u0010M\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\\J\u0010\u0010l\u001a\u00020J2\u0006\u0010m\u001a\u00020\u0006H\u0002J\u000e\u0010n\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0006J\b\u0010o\u001a\u00020pH\u0016J\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000AR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00140\u00138VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0004\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0017R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u0014\u00101\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010+R\u000e\u00103\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0018\u0010@\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010B\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010C\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010H\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006w"}, d2={"Ldorkbox/collections/LongMap;", "V", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/LongMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/LongMap$Entries;", "entries2", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "keyTable", "", "getKeyTable", "()[J", "setKeyTable", "([J)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/LongMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[Ljava/lang/Object;", "setValueTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/LongMap$Values;", "values2", "zeroValue", "getZeroValue", "()Ljava/lang/Object;", "setZeroValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Long;", "notFound", "get", "(J)Ljava/lang/Object;", "defaultValue", "(JLjava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(JLjava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public final class LongMap<V>
implements Map<Long, V>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private long[] keyTable;
    private V[] valueTable;
    private V zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries<V> entries1;
    private transient Entries<V> entries2;
    private transient Values<V> values1;
    private transient Values<V> values2;
    private transient Keys keys1;
    private transient Keys keys2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final long[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
        this.keyTable = lArray;
    }

    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"");
        this.valueTable = VArray;
    }

    public final V getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(V v) {
        this.zeroValue = v;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[n2];
        this.valueTable = new Object[n2];
    }

    public /* synthetic */ LongMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public LongMap(LongMap<? extends V> longMap) {
        Intrinsics.checkNotNullParameter(longMap, (String)"");
        this((int)((float)longMap.keyTable.length * longMap.loadFactor), longMap.loadFactor);
        System.arraycopy(longMap.keyTable, 0, this.keyTable, 0, longMap.keyTable.length);
        System.arraycopy(longMap.valueTable, 0, this.valueTable, 0, longMap.valueTable.length);
        this.size_ = longMap.size_;
        this.zeroValue = longMap.zeroValue;
        this.hasZeroValue = longMap.hasZeroValue;
    }

    protected final int place(long l) {
        return (int)(l * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(long l) {
        long[] lArray = this.keyTable;
        int n = this.place(l);
        long l2;
        while ((l2 = lArray[n]) != 0L) {
            if (l2 == l) {
                return n;
            }
            n = n + 1 & this.mask;
        }
        return -(n + 1);
    }

    @Override
    public V put(long l, V v) {
        if (l == 0L) {
            V v2 = this.zeroValue;
            this.zeroValue = v;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                int n = this.size_;
                this.size_ = n + 1;
            }
            return v2;
        }
        int n = this.locateKey(l);
        if (n >= 0) {
            V v3 = this.valueTable[n];
            this.valueTable[n] = v;
            return v3;
        }
        n = -(n + 1);
        this.keyTable[n] = l;
        this.valueTable[n] = v;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public final void putAll(LongMap<? extends V> longMap) {
        Intrinsics.checkNotNullParameter(longMap, (String)"");
        this.ensureCapacity(longMap.size_);
        if (longMap.hasZeroValue) {
            V v = longMap.zeroValue;
            Intrinsics.checkNotNull(v);
            this.put(0L, v);
        }
        long[] lArray = longMap.keyTable;
        V[] VArray = longMap.valueTable;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            V v = VArray[i];
            Intrinsics.checkNotNull(v);
            this.put(l, v);
        }
    }

    private final void putResize(long l, V v) {
        long[] lArray = this.keyTable;
        int n = this.place(l);
        while (true) {
            if (lArray[n] == 0L) {
                lArray[n] = l;
                this.valueTable[n] = v;
                return;
            }
            n = n + 1 & this.mask;
        }
    }

    public V get(long l) {
        if (l == 0L) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        int n = this.locateKey(l);
        return n >= 0 ? (V)this.valueTable[n] : null;
    }

    public final V get(long l, V v) {
        if (l == 0L) {
            V v2;
            if (this.hasZeroValue) {
                V v3 = this.zeroValue;
                v2 = v3;
                Intrinsics.checkNotNull(v3);
            } else {
                v2 = v;
            }
            return v2;
        }
        int n = this.locateKey(l);
        return n >= 0 ? this.valueTable[n] : v;
    }

    public V remove(long l) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V v = this.zeroValue;
            this.zeroValue = null;
            int n = this.size_;
            this.size_ = n + -1;
            return v;
        }
        int n = this.locateKey(l);
        if (n < 0) {
            return null;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v = VArray[n];
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        long l2 = 0L;
        while (true) {
            long l3;
            long l4 = l3 = lArray[n3];
            boolean bl = false;
            l2 = l4;
            if (l3 == 0L) break;
            int n4 = this.place(l2);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                lArray[n] = l2;
                VArray[n] = VArray[n3];
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        lArray[n] = 0L;
        VArray[n] = null;
        int n5 = this.size_;
        this.size_ = n5 + -1;
        return v;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.ensureCapacity(map.size());
        Iterable iterable = map.entrySet();
        boolean bl = false;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            boolean bl2 = false;
            long l = ((Number)entry.getKey()).longValue();
            Object v = entry.getValue();
            this.put(l, v);
        }
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public final void clear(int n) {
        int n2 = ObjectSet.Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(n2);
    }

    public Set<Map.Entry<Long, V>> getEntries() {
        Entries<V> entries = this.entries();
        Intrinsics.checkNotNull(entries);
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    public Set<Long> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0L);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue(object, false);
    }

    public final boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            long[] lArray = this.keyTable;
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n2;
                    if (lArray[n2 = n--] == 0L || VArray[n2] != null) continue;
                    return true;
                } while (0 <= n);
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n3;
                    if (VArray[n3 = n--] != object) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)object, this.zeroValue)) {
                return true;
            }
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n4;
                    if (!Intrinsics.areEqual((Object)object, VArray[n4 = n--])) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean containsValue$default(LongMap longMap, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return longMap.containsValue(object, bl);
    }

    public boolean containsKey(long l) {
        return l == 0L ? this.hasZeroValue : this.locateKey(l) >= 0;
    }

    public final Long findKey(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            long[] lArray = this.keyTable;
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n2;
                    if (lArray[n2 = n--] == 0L || VArray[n2] != null) continue;
                    return lArray[n2];
                } while (0 <= n);
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0L;
            }
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n3;
                    if (VArray[n3 = n--] != object) continue;
                    return this.keyTable[n3];
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)object, this.zeroValue)) {
                return 0L;
            }
            int n = VArray.length + -1;
            if (0 <= n) {
                do {
                    int n4;
                    if (!Intrinsics.areEqual((Object)object, VArray[n4 = n--])) continue;
                    return this.keyTable[n4];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final long findKey(Object object, boolean bl, long l) {
        Long l2 = this.findKey(object, bl);
        return l2 != null ? l2 : l;
    }

    public final void ensureCapacity(int n) {
        int n2 = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new long[n];
        this.valueTable = new Object[n];
        if (this.size_ > 0) {
            for (int i = 0; i < n2; ++i) {
                long l = lArray[i];
                if (l == 0L) continue;
                this.putResize(l, VArray[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size_;
        if (this.hasZeroValue && this.zeroValue != null) {
            V v = this.zeroValue;
            n += v != null ? v.hashCode() : 0;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = lArray.length;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            n += (int)l * 31;
            V v = VArray[i];
            if (v == null) continue;
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        LongMap cfr_ignored_0 = (LongMap)object;
        if (((LongMap)object).size_ != this.size_) {
            return false;
        }
        if (((LongMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((LongMap)object).zeroValue == null ? this.zeroValue != null : !Intrinsics.areEqual(((LongMap)object).zeroValue, this.zeroValue))) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            V v;
            long l = lArray[i];
            if (l == 0L || !((v = VArray[i]) == null ? ((LongMap)object).get(l, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(v, ((LongMap)object).get((Object)l)))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        LongMap cfr_ignored_0 = (LongMap)object;
        if (((LongMap)object).size_ != this.size_) {
            return false;
        }
        if (((LongMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((LongMap)object).zeroValue) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            if (l == 0L || VArray[i] == ((LongMap)object).get(l, ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long l;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = lArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n-- > 0) {
                l = lArray[n];
                if (l == 0L) continue;
                stringBuilder.append(l);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n]);
                break;
            }
        }
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final Entries<V> entries() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        Entries<V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    @Override
    public final Values<V> values() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5);
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9);
        return values9;
    }

    public final Keys keys() {
        if (this.allocateIterators) {
            return new Keys((LongMap<?>)this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys((LongMap<?>)this);
            this.keys2 = new Keys((LongMap<?>)this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        return this.put(((Number)object).longValue(), object2);
    }

    @Override
    public final V get(Object object) {
        if (!(object instanceof Long)) {
            return null;
        }
        return this.get(((Number)object).longValue());
    }

    @Override
    public final V remove(Object object) {
        if (!(object instanceof Long)) {
            return null;
        }
        return this.remove(((Number)object).longValue());
    }

    @Override
    public final Set<Map.Entry<Long, V>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<Long> keySet() {
        return this.getKeys();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Override
    public final boolean containsKey(Object object) {
        if (!(object instanceof Long)) {
            return false;
        }
        return this.containsKey(((Number)object).longValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/LongMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u00022\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\t\u0010\u0017\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0017\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u001aH\u0096\u0002J\u0011\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u001d\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\u001e\u0010\u001e\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Ldorkbox/collections/LongMap$Entries;", "V", "", "Ldorkbox/collections/LongMap$Entry;", "Ldorkbox/collections/LongMap$MapIterator;", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "entry", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static final class Entries<V>
    extends MapIterator<V, Entry<V>>
    implements Set<Entry<V>>,
    KMutableSet {
        private final Entry<V> entry;

        public Entries(LongMap<V> longMap) {
            Intrinsics.checkNotNullParameter(longMap, (String)"");
            super(longMap);
            this.entry = new Entry<V>(longMap);
        }

        @Override
        public Entry<V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long[] lArray = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0L);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(lArray[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Entry<V>> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                this.getMap().put(entry.getKey(), entry.getValue());
                bl = true;
            }
            return bl;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl2 = false;
                long l = ((Number)((Map.Entry)entry).getKey()).longValue();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.getMap().get((Object)l), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            return Intrinsics.areEqual(this.getMap().get(entry.getKey()), entry.getValue());
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            int n;
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            if (this.getMap().getHasZeroValue()) {
                boolean bl2;
                Object v0;
                block5: {
                    Iterable iterable = collection;
                    n = 0;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        boolean bl3 = false;
                        if (!(entry.getKey() == 0L)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                boolean bl4 = bl2 = v0 != null;
                if (bl2) {
                    bl = this.getMap().remove((Object)0L) != null;
                }
            }
            long[] lArray = this.getMap().getKeyTable();
            boolean bl5 = false;
            int n2 = lArray.length;
            for (n = 0; n < n2; ++n) {
                boolean bl6;
                Object v2;
                long l;
                block6: {
                    long l2;
                    l = l2 = lArray[n];
                    boolean bl7 = false;
                    if (l == 0L) continue;
                    Iterable iterable = collection;
                    boolean bl8 = false;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        boolean bl9 = false;
                        if (!(entry.getKey() == l)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                boolean bl10 = bl6 = v2 != null;
                if (bl6) continue;
                bl = this.getMap().remove((Object)l) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry entry = (Entry)t;
                boolean bl3 = false;
                long l = ((Number)((Map.Entry)entry).getKey()).longValue();
                bl = this.getMap().remove((Object)l) != null || bl;
            }
            this.reset();
            return bl;
        }

        public boolean remove(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            boolean bl = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ldorkbox/collections/LongMap$Entry;", "V", "", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "key", "getKey", "()Ljava/lang/Long;", "setKey", "(J)V", "getMap", "()Ldorkbox/collections/LongMap;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<V>
    implements Map.Entry<Long, V>,
    KMutableMap.Entry {
        private final LongMap<V> map;
        private long key;
        private V value;

        public Entry(LongMap<V> longMap) {
            Intrinsics.checkNotNullParameter(longMap, (String)"");
            this.map = longMap;
        }

        public final LongMap<V> getMap() {
            return this.map;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        public void setKey(long l) {
            this.key = l;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(V v) {
            this.value = v;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.getValue();
            ((Map)this.map).put(this.getKey(), v);
            this.setValue(v);
            return v2;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Ldorkbox/collections/LongMap$Keys;", "", "", "Ldorkbox/collections/LongMap$MapIterator;", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Long;", "remove", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    public static final class Keys
    extends MapIterator<Object, Long>
    implements Set<Long>,
    KMutableSet {
        public Keys(LongMap<?> longMap) {
            Intrinsics.checkNotNullParameter(longMap, (String)"");
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public Long next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long l = this.getNextIndex() == -1 ? 0L : this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return l;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public boolean addAll(Collection<? extends Long> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                long l = ((Number)t).longValue();
                boolean bl3 = false;
                bl = bl || this.getMap().put(l, (Object)null) == null;
            }
            return bl;
        }

        @Override
        public boolean add(long l) {
            return this.getMap().put(l, (Object)null) == null;
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            for (Object t : iterable) {
                long l = ((Number)t).longValue();
                boolean bl2 = false;
                if (this.getMap().containsKey((Object)l)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(long l) {
            return this.getMap().containsKey((Object)l);
        }

        @Override
        public Iterator<Long> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            long[] lArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                long l;
                long l2 = l = lArray[i];
                boolean bl3 = false;
                if (collection.contains(l2) || this.getMap().remove((Object)l2) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            for (Object t : iterable) {
                long l = ((Number)t).longValue();
                boolean bl3 = false;
                if (this.getMap().remove((Object)l) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        public boolean remove(long l) {
            return this.getMap().remove((Object)l) == null;
        }

        public final long[] toArray() {
            long[] lArray = new long[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                lArray[n++] = this.next();
            }
            return lArray;
        }

        public final long[] toArray(long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                lArray[n++] = this.next();
            }
            return lArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).longValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Long)) {
                return false;
            }
            return this.contains(((Number)object).longValue());
        }

        @Override
        public final boolean remove(Object object) {
            if (!(object instanceof Long)) {
                return false;
            }
            return this.remove(((Number)object).longValue());
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/LongMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/LongMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final LongMap<V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(LongMap<V> longMap) {
            Intrinsics.checkNotNullParameter(longMap, (String)"");
            this.map = longMap;
            this.valid = true;
            this.reset();
        }

        public final LongMap<V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                long[] lArray = this.map.getKeyTable();
                int n = lArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (lArray[this.nextIndex] == 0L);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(null);
            } else {
                if (n < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] lArray = this.map.getKeyTable();
                V[] VArray = this.map.getValueTable();
                int n2 = this.map.getMask();
                int n3 = n + 1 & n2;
                long l = 0L;
                while (true) {
                    long l2;
                    long l3 = l2 = lArray[n3];
                    boolean bl = false;
                    l = l3;
                    if (l2 == 0L) break;
                    int n4 = this.map.place(l);
                    if ((n3 - n4 & n2) > (n - n4 & n2)) {
                        lArray[n] = l;
                        VArray[n] = VArray[n3];
                        n = n3;
                    }
                    n3 = n3 + 1 & n2;
                }
                lArray[n] = 0L;
                VArray[n] = null;
                if (n != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                LongMap<V> longMap = this.map;
                int n5 = ((LongMap)longMap).size_;
                ((LongMap)longMap).size_ = n5 + -1;
            }
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/LongMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\t\u0010\u0016\u001a\u00020\fH\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\u0002\u0010!R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/LongMap$Values;", "V", "", "Ldorkbox/collections/LongMap$MapIterator;", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    public static final class Values<V>
    extends MapIterator<V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(LongMap<V> longMap) {
            Intrinsics.checkNotNullParameter(longMap, (String)"");
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            V v = null;
            v = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            V v2 = v;
            Intrinsics.checkNotNull(v2);
            return v2;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V v) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            Iterable iterable = collection;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl2 = false;
                if (this.getMap().containsValue(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return this.getMap().containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            long[] lArray = this.getMap().getKeyTable();
            boolean bl2 = false;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Object v;
                long l;
                long l2 = l = lArray[i];
                boolean bl3 = false;
                if (l2 == 0L || CollectionsKt.contains((Iterable)collection, v = this.getMap().get((Object)l2))) continue;
                this.getMap().remove((Object)l2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            Iterable iterable = collection;
            boolean bl2 = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object t2 = t = iterator.next();
                boolean bl3 = false;
                Long l = this.getMap().findKey(t2, false);
                if (l == null) continue;
                bl = this.getMap().remove(l) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            Long l = this.getMap().findKey(object, false);
            if (l != null) {
                bl = this.getMap().remove(l) != null;
            }
            this.reset();
            return bl;
        }

        @Override
        public final V[] toArray() {
            int n = 0;
            int n2 = this.getMap().size_;
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }
    }
}

