/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 [*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002[\\B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u0014\u00101\u001a\u0002022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J)\u00101\u001a\u00020\r2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006\u00a2\u0006\u0002\u00106J\u001f\u00101\u001a\u00020\r2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016\"\u00028\u0000\u00a2\u0006\u0002\u00107J\u001b\u00101\u001a\u0002022\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u001aJ+\u00101\u001a\u0002022\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006\u00a2\u0006\u0002\u00108J\u0016\u00101\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016J\u0015\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u000202H\u0016J\u0010\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020\u0006H\u0016J\u0016\u0010@\u001a\u00020\r2\u0006\u0010/\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00100J\u0016\u0010A\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016J\u000e\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020\u0006J\u0013\u0010D\u001a\u00020\r2\b\u0010E\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\r\u0010F\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u0004\u0018\u00018\u00002\u0006\u0010<\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020\u0006H\u0016J\b\u0010K\u001a\u00020\rH\u0016J\u000f\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0096\u0002J\u0015\u0010M\u001a\u00020\u00062\b\u0010<\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010NJ\u0006\u0010O\u001a\u00020\rJ\u0015\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010NJ\u0015\u0010R\u001a\u00020\r2\u0006\u0010/\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u0016\u0010S\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016J\u0010\u0010T\u001a\u0002022\u0006\u0010U\u001a\u00020\u0006H\u0002J\u0016\u0010V\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016J\u000e\u0010W\u001a\u0002022\u0006\u0010?\u001a\u00020\u0006J\b\u0010X\u001a\u00020YH\u0016J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YH\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R\u001a\u0010+\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$\u00a8\u0006]"}, d2={"Ldorkbox/collections/ObjectSet;", "T", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/ObjectSet;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "iterator1", "Ldorkbox/collections/ObjectSet$ObjectSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "setSize", "threshold", "getThreshold", "setThreshold", "add", "element", "(Ljava/lang/Object;)Z", "addAll", "", "array", "offset", "length", "([Ljava/lang/Object;II)Z", "([Ljava/lang/Object;)Z", "([Ljava/lang/Object;II)V", "elements", "", "addResize", "key", "(Ljava/lang/Object;)V", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "first", "()Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "iterator", "locateKey", "(Ljava/lang/Object;)I", "notEmpty", "place", "item", "remove", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "separator", "Companion", "ObjectSetIterator", "Collections"})
public class ObjectSet<T>
implements Set<T>,
KMutableSet {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size;
    private T[] keyTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient ObjectSetIterator<T> iterator1;
    private transient ObjectSetIterator<T> iterator2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public final T[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.keyTable = TArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        int n2 = Companion.tableSize(n, f);
        this.threshold = (int)((float)n2 * f);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
    }

    public /* synthetic */ ObjectSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectSet(ObjectSet<? extends T> objectSet) {
        Intrinsics.checkNotNullParameter(objectSet, (String)"");
        this((int)((float)objectSet.keyTable.length * objectSet.loadFactor), objectSet.loadFactor);
        System.arraycopy(objectSet.keyTable, 0, this.keyTable, 0, objectSet.keyTable.length);
        this.setSize(objectSet.size());
    }

    protected final int place(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        return (int)((long)t.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public final int locateKey(T t) {
        if (t == null) {
            boolean bl = false;
            String string = "key cannot be null.";
            throw new IllegalArgumentException(string.toString());
        }
        T[] TArray = this.keyTable;
        int n = this.place(t);
        while (TArray[n] != null) {
            T t2;
            if (Intrinsics.areEqual(t2, t)) {
                return n;
            }
            n = n + 1 & this.mask;
        }
        return -(n + 1);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            boolean bl3 = false;
            bl = this.add((T)t2) || bl;
        }
        return bl;
    }

    @Override
    public boolean add(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = this.locateKey(t);
        if (n >= 0) {
            return false;
        }
        n = -(n + 1);
        this.keyTable[n] = t;
        this.setSize(this.size() + 1);
        if (this.size() >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    public final void addAll(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.addAll(TArray, 0, TArray.length);
    }

    public final void addAll(T[] TArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        if (n + n2 > TArray.length) {
            throw new StateException("offset + length must be <= size: " + n + " + " + n2 + " <= " + TArray.length);
        }
        this.addAll(TArray, n, n2);
    }

    public final boolean addAll(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        return this.addAll(TArray, 0, TArray.length);
    }

    public final boolean addAll(T[] TArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        this.ensureCapacity(n2);
        int n4 = this.size();
        int n5 = n3 + n2;
        for (n3 = n; n3 < n5; ++n3) {
            this.add(TArray[n3]);
        }
        return n4 != this.size();
    }

    public final void addAll(ObjectSet<T> objectSet) {
        Intrinsics.checkNotNullParameter(objectSet, (String)"");
        this.ensureCapacity(objectSet.size());
        for (T t : objectSet.keyTable) {
            T t2;
            if (t == null) continue;
            boolean bl = false;
            this.add(t2);
        }
    }

    private final void addResize(T t) {
        T[] TArray = this.keyTable;
        int n = this.place(t);
        while (true) {
            if (TArray[n] == null) {
                TArray[n] = t;
                return;
            }
            n = n + 1 & this.mask;
        }
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        T[] TArray = this.keyTable;
        boolean bl2 = false;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T t;
            T t2 = t = TArray[i];
            boolean bl3 = false;
            if (t2 == null || collection.contains(t2)) continue;
            bl = this.remove(t2) || bl;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl = false;
        Iterable iterable = collection;
        boolean bl2 = false;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            boolean bl3 = false;
            if (!this.remove(t2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.locateKey(object);
        if (n < 0) {
            return false;
        }
        T[] TArray = this.keyTable;
        int n2 = this.mask;
        int n3 = n + 1 & n2;
        T t = null;
        while (true) {
            T t2;
            T t3 = t2 = TArray[n3];
            boolean bl = false;
            t = t3;
            if (t2 == null) break;
            T t4 = t;
            Intrinsics.checkNotNull(t4);
            int n4 = this.place(t4);
            if ((n3 - n4 & n2) > (n - n4 & n2)) {
                TArray[n] = t;
                n = n3;
            }
            n3 = n3 + 1 & n2;
        }
        TArray[n] = null;
        int n5 = this.size();
        this.setSize(n5 + -1);
        return true;
    }

    public final boolean notEmpty() {
        return this.size() > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        int n2 = Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length > n2) {
            this.resize(n2);
        }
    }

    public void clear(int n) {
        int n2 = Companion.tableSize(n, this.loadFactor);
        if (this.keyTable.length <= n2) {
            this.clear();
            return;
        }
        this.setSize(0);
        this.resize(n2);
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.setSize(0);
        Arrays.fill(this.keyTable, null);
    }

    @Override
    public boolean containsAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Iterable iterable = collection;
        boolean bl = false;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            boolean bl2 = false;
            if (this.contains(t2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return this.locateKey(object) >= 0;
    }

    public final T get(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = this.locateKey(t);
        return n < 0 ? null : (T)this.keyTable[n];
    }

    public final T first() {
        T[] TArray = this.keyTable;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] == null) continue;
            return TArray[i];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public final void ensureCapacity(int n) {
        int n2 = Companion.tableSize(this.size() + n, this.loadFactor);
        if (this.keyTable.length < n2) {
            this.resize(n2);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        T[] TArray = this.keyTable;
        this.keyTable = new Object[n];
        if (this.size() > 0) {
            for (int i = 0; i < n2; ++i) {
                T t = TArray[i];
                if (t != null) {
                    T t2;
                    boolean bl = false;
                    this.addResize(t2);
                }
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size();
        for (T t : this.keyTable) {
            if (t == null) continue;
            n += t.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectSet)) {
            return false;
        }
        ObjectSet cfr_ignored_0 = (ObjectSet)object;
        if (((ObjectSet)object).size() != this.size()) {
            return false;
        }
        T[] TArray = this.keyTable;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] == null || CollectionsKt.contains((Iterable)((Iterable)object), TArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return '{' + this.toString(", ") + '}';
    }

    public String toString(String string) {
        T t;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (this.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        T[] TArray = this.keyTable;
        int n = TArray.length;
        while (n-- > 0) {
            T t2 = TArray[n];
            if (t2 == null) continue;
            t = t2;
            stringBuilder.append((Object)(t == this ? "(this)" : t));
            break;
        }
        while (n-- > 0) {
            if (TArray[n] == null) continue;
            stringBuilder.append(string);
            stringBuilder.append((Object)(t == this ? "(this)" : t));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (this.allocateIterators) {
            return new ObjectSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        ObjectSetIterator<T> objectSetIterator = this.iterator1;
        Intrinsics.checkNotNull(objectSetIterator);
        if (!objectSetIterator.getValid()) {
            ObjectSetIterator<T> objectSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator2);
            objectSetIterator2.reset();
            ObjectSetIterator<T> objectSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator3);
            objectSetIterator3.setValid(true);
            ObjectSetIterator<T> objectSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull(objectSetIterator4);
            objectSetIterator4.setValid(false);
            ObjectSetIterator<T> objectSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator5);
            return objectSetIterator5;
        }
        ObjectSetIterator<T> objectSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator6);
        objectSetIterator6.reset();
        ObjectSetIterator<T> objectSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator7);
        objectSetIterator7.setValid(true);
        ObjectSetIterator<T> objectSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull(objectSetIterator8);
        objectSetIterator8.setValid(false);
        ObjectSetIterator<T> objectSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator9);
        return objectSetIterator9;
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ/\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0001\u0010\f*\u00020\u00012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000e\"\u0002H\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/ObjectSet$Companion;", "", "()V", "version", "", "tableSize", "", "capacity", "loadFactor", "", "with", "Ldorkbox/collections/ObjectSet;", "T", "array", "", "([Ljava/lang/Object;)Ldorkbox/collections/ObjectSet;", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> ObjectSet<T> with(T ... TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            ObjectSet<T> objectSet = new ObjectSet<T>();
            objectSet.addAll(Arrays.copyOf(TArray, TArray.length));
            return objectSet;
        }

        public final int tableSize(int n, float f) {
            if (n < 0) {
                throw new StateException("capacity must be >= 0: " + n);
            }
            int n2 = Collections.INSTANCE.nextPowerOfTwo((int)Math.max(2.0, (double)((int)Math.ceil((float)n / f))));
            if (n2 > 0x40000000) {
                throw new StateException("The required capacity is too large: " + n);
            }
            return n2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u001f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016\u00a2\u0006\u0002\u0010%J!\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016\u00a2\u0006\u0002\u0010'R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Ldorkbox/collections/ObjectSet$ObjectSetIterator;", "K", "", "", "", "set", "Ldorkbox/collections/ObjectSet;", "(Ldorkbox/collections/ObjectSet;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/ObjectSet;", "valid", "getValid", "setValid", "findNextIndex", "", "iterator", "next", "()Ljava/lang/Object;", "remove", "reset", "toArray", "", "()[Ljava/lang/Object;", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K>,
    KMappedMarker,
    KMutableIterator {
        private final ObjectSet<K> set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public ObjectSetIterator(ObjectSet<K> objectSet) {
            Intrinsics.checkNotNullParameter(objectSet, (String)"");
            this.set = objectSet;
            this.valid = true;
            this.reset();
        }

        public final ObjectSet<K> getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        private final void findNextIndex() {
            block1: {
                K[] KArray = this.set.getKeyTable();
                int n = this.set.getKeyTable().length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int n = this.currentIndex;
            if (!(n >= 0)) {
                boolean bl = false;
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            K[] KArray = this.set.getKeyTable();
            int n2 = this.set.getMask();
            int n3 = n + 1 & n2;
            Object t = null;
            while (true) {
                object = KArray[n3];
                K k = object;
                boolean bl = false;
                t = k;
                if (object == null) break;
                Object t2 = t;
                Intrinsics.checkNotNull(t2);
                int n4 = this.set.place(t2);
                if ((n3 - n4 & n2) > (n - n4 & n2)) {
                    KArray[n] = t;
                    n = n3;
                }
                n3 = n3 + 1 & n2;
            }
            KArray[n] = null;
            object = this.set;
            int n5 = ((ObjectSet)object).size();
            ((ObjectSet)object).setSize(n5 + -1);
            if (n != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K k = this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            K k2 = k;
            Intrinsics.checkNotNull(k2);
            return k2;
        }

        @Override
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        public K[] toArray() {
            int n = 0;
            int n2 = this.set.size();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = this.next();
            }
            return objectArray;
        }

        public K[] toArray(K[] KArray) {
            Intrinsics.checkNotNullParameter(KArray, (String)"");
            int n = 0;
            while (this.hasNext) {
                KArray[n++] = this.next();
            }
            return KArray;
        }
    }
}

