/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 6*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u000267B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u00020\"2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001b\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0007H\u0016J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096\u0002J\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000fj\b\u0012\u0004\u0012\u00028\u0000`\u0010J\u0015\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010.\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\"J\u0016\u00100\u001a\u00020\"2\u000e\u00101\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u000002J\b\u00103\u001a\u000204H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0016R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000fj\b\u0012\u0004\u0012\u00028\u0000`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u00068"}, d2={"Ldorkbox/collections/OrderedSet;", "T", "", "", "Ldorkbox/collections/ObjectSet;", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "(I)V", "set", "(Ldorkbox/collections/OrderedSet;)V", "items", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "iterator1", "Ldorkbox/collections/OrderedSet$OrderedSetIterator;", "getIterator1", "()Ldorkbox/collections/OrderedSet$OrderedSetIterator;", "setIterator1", "(Ldorkbox/collections/OrderedSet$OrderedSetIterator;)V", "iterator2", "getIterator2", "setIterator2", "add", "", "element", "(Ljava/lang/Object;)Z", "key", "index", "(Ljava/lang/Object;I)Z", "addAll", "", "alter", "before", "after", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "alterIndex", "(ILjava/lang/Object;)Z", "clear", "maximumCapacity", "iterator", "orderedItems", "remove", "removeIndex", "(I)Ljava/lang/Object;", "sort", "comparator", "Ljava/util/Comparator;", "toString", "", "separator", "Companion", "OrderedSetIterator", "Collections"})
public final class OrderedSet<T>
extends ObjectSet<T> {
    public static final Companion Companion = new Companion(null);
    private final ArrayList<T> items;
    private transient OrderedSetIterator<T> iterator1;
    private transient OrderedSetIterator<T> iterator2;
    private static final String version = "2.8";

    public final OrderedSetIterator<T> getIterator1() {
        return this.iterator1;
    }

    public final void setIterator1(OrderedSetIterator<T> orderedSetIterator) {
        this.iterator1 = orderedSetIterator;
    }

    public final OrderedSetIterator<T> getIterator2() {
        return this.iterator2;
    }

    public final void setIterator2(OrderedSetIterator<T> orderedSetIterator) {
        this.iterator2 = orderedSetIterator;
    }

    public OrderedSet() {
        this.items = new ArrayList();
    }

    public OrderedSet(int n, float f) {
        super(n, f);
        this.items = new ArrayList(n);
    }

    public OrderedSet(int n) {
        super(n, 0.0f, 2, null);
        this.items = new ArrayList(n);
    }

    public OrderedSet(OrderedSet<? extends T> orderedSet) {
        Intrinsics.checkNotNullParameter(orderedSet, (String)"");
        super((ObjectSet)orderedSet);
        this.items = new ArrayList(orderedSet.items);
    }

    public final void sort() {
        CollectionsKt.sort((List)this.items);
    }

    public final void sort(Comparator<? super T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        CollectionsKt.sortWith((List)this.items, comparator);
    }

    @Override
    public boolean add(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (!super.add(t)) {
            return false;
        }
        this.items.add(t);
        return true;
    }

    public final boolean add(T t, int n) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (!super.add(t)) {
            int n2 = 0;
            n2 = -1;
            Iterable iterable = this.items;
            boolean bl = false;
            int n3 = 0;
            for (Object t2 : iterable) {
                int n4;
                if ((n4 = n3++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t3 = t2;
                int n5 = n4;
                boolean bl2 = false;
                if (t3 != t) continue;
                n2 = n5;
            }
            if (n2 != n) {
                T t4 = this.items.remove(n2);
                Intrinsics.checkNotNullExpressionValue(t4, (String)"");
                iterable = t4;
                this.items.add(n, iterable);
            }
            return false;
        }
        this.items.add(n, t);
        return true;
    }

    @Override
    public final void addAll(OrderedSet<T> orderedSet) {
        Intrinsics.checkNotNullParameter(orderedSet, (String)"");
        this.ensureCapacity(orderedSet.size());
        ArrayList<T> arrayList = orderedSet.items;
        int n = orderedSet.items.size();
        for (int i = 0; i < n; ++i) {
            T t = arrayList.get(i);
            Intrinsics.checkNotNullExpressionValue(t, (String)"");
            this.add(t);
        }
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.remove(object)) {
            return false;
        }
        this.items.remove(object);
        return true;
    }

    public final T removeIndex(int n) {
        T t = this.items.remove(n);
        Intrinsics.checkNotNullExpressionValue(t, (String)"");
        T t2 = t;
        super.remove(t2);
        return t2;
    }

    public final boolean alter(T t, T t2) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        Intrinsics.checkNotNullParameter(t2, (String)"");
        if (this.contains(t2)) {
            return false;
        }
        if (!super.remove(t)) {
            return false;
        }
        super.add(t2);
        this.items.set(this.items.indexOf(t), t2);
        return true;
    }

    public final boolean alterIndex(int n, T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (n < 0 || n >= this.size() || this.contains(t)) {
            return false;
        }
        super.remove(this.items.get(n));
        super.add(t);
        this.items.set(n, t);
        return true;
    }

    @Override
    public void clear(int n) {
        this.items.clear();
        super.clear(n);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    public final ArrayList<T> orderedItems() {
        return this.items;
    }

    @Override
    public OrderedSetIterator<T> iterator() {
        if (this.getAllocateIterators()) {
            return new OrderedSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSetIterator(this);
            this.iterator2 = new OrderedSetIterator(this);
        }
        OrderedSetIterator<T> orderedSetIterator = this.iterator1;
        Intrinsics.checkNotNull(orderedSetIterator);
        if (!orderedSetIterator.getValid()) {
            OrderedSetIterator<T> orderedSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull(orderedSetIterator2);
            orderedSetIterator2.reset();
            OrderedSetIterator<T> orderedSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull(orderedSetIterator3);
            orderedSetIterator3.setValid(true);
            OrderedSetIterator<T> orderedSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull(orderedSetIterator4);
            orderedSetIterator4.setValid(false);
            OrderedSetIterator<T> orderedSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull(orderedSetIterator5);
            return orderedSetIterator5;
        }
        OrderedSetIterator<T> orderedSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull(orderedSetIterator6);
        orderedSetIterator6.reset();
        OrderedSetIterator<T> orderedSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull(orderedSetIterator7);
        orderedSetIterator7.setValid(true);
        OrderedSetIterator<T> orderedSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull(orderedSetIterator8);
        orderedSetIterator8.setValid(false);
        OrderedSetIterator<T> orderedSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull(orderedSetIterator9);
        return orderedSetIterator9;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        ArrayList<T> arrayList = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(arrayList.get(0));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(arrayList.get(i));
        }
        stringBuilder.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String toString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return CollectionsKt.joinToString$default((Iterable)this.items, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0012\b\u0001\u0010\t*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\t0\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\f\"\u0002H\t\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ldorkbox/collections/OrderedSet$Companion;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "with", "Ldorkbox/collections/OrderedSet;", "T", "", "array", "", "([Ljava/lang/Object;)Ldorkbox/collections/OrderedSet;", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final String getVersion() {
            return version;
        }

        public final <T> OrderedSet<T> with(T ... TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            OrderedSet<T> orderedSet = new OrderedSet<T>();
            orderedSet.addAll(Arrays.copyOf(TArray, TArray.length));
            return orderedSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000*\u0012\b\u0001\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00010\tj\b\u0012\u0004\u0012\u00028\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldorkbox/collections/OrderedSet$OrderedSetIterator;", "T", "", "", "Ldorkbox/collections/ObjectSet$ObjectSetIterator;", "set", "Ldorkbox/collections/OrderedSet;", "(Ldorkbox/collections/OrderedSet;)V", "items", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "next", "()Ljava/lang/Object;", "remove", "", "reset", "toArray", "", "()[Ljava/lang/Object;", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    public static final class OrderedSetIterator<T>
    extends ObjectSet.ObjectSetIterator<T> {
        private final ArrayList<T> items;

        public OrderedSetIterator(OrderedSet<T> orderedSet) {
            Intrinsics.checkNotNullParameter(orderedSet, (String)"");
            super((ObjectSet)orderedSet);
            this.items = ((OrderedSet)orderedSet).items;
        }

        @Override
        public void reset() {
            this.setNextIndex(0);
            this.setHasNext(this.getSet().size() > 0);
        }

        @Override
        public T next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            T t = this.items.get(this.getNextIndex());
            Intrinsics.checkNotNullExpressionValue(t, (String)"");
            T t2 = t;
            int n = this.getNextIndex();
            this.setNextIndex(n + 1);
            this.setHasNext(this.getNextIndex() < this.getSet().size());
            return t2;
        }

        @Override
        public void remove() {
            if (!(this.getNextIndex() >= 0)) {
                boolean bl = false;
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            int n = this.getNextIndex();
            this.setNextIndex(n + -1);
            ObjectSet objectSet = this.getSet();
            Intrinsics.checkNotNull(objectSet);
            ((OrderedSet)objectSet).removeIndex(this.getNextIndex());
        }

        @Override
        public T[] toArray() {
            int n = 0;
            int n2 = this.getSet().size() - this.getNextIndex();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            int n = this.getNextIndex();
            while (this.getHasNext()) {
                TArray[n++] = this.next();
            }
            this.setNextIndex(this.items.size());
            this.setHasNext(false);
            return TArray;
        }
    }
}

