/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.u;
import kotlinx.b.w;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljava/security/SecureRandom;", "", "generateClientSeed", "(Ljava/security/SecureRandom;)[B", "Lio/ktor/network/tls/extensions/NamedCurve;", "curve", "Ljava/security/spec/ECPoint;", "serverPoint", "Lio/ktor/network/tls/EncryptionInfo;", "generateECKeys", "(Lio/ktor/network/tls/extensions/NamedCurve;Ljava/security/spec/ECPoint;)Lio/ktor/network/tls/EncryptionInfo;", "Lkotlinx/io/Source;", "packet", "Lio/ktor/network/tls/CertificateInfo;", "readClientCertificateRequest", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/CertificateInfo;", "ktor-network-tls"})
public final class TLSClientHandshakeKt {
    private static final byte[] generateClientSeed(SecureRandom secureRandom) {
        byte[] byArray;
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = byArray = byArray2;
        boolean bl = false;
        long l = System.currentTimeMillis() / 1000L;
        byArray3[0] = (byte)(l >> 24);
        byArray3[1] = (byte)(l >> 16);
        byArray3[2] = (byte)(l >> 8);
        byArray3[3] = (byte)(l >> 0);
        return byArray;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve namedCurve, ECPoint eCPoint) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        Object object = keyPairGenerator;
        boolean bl = false;
        ((KeyPairGenerator)object).initialize(new ECGenParameterSpec(namedCurve.name()));
        KeyPair keyPair = ((KeyPairGenerator)object).generateKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        KeyPair keyPair2 = keyPair;
        PublicKey publicKey = keyPair2.getPublic();
        Intrinsics.checkNotNull((Object)publicKey);
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        Intrinsics.checkNotNull((Object)keyFactory);
        object = keyFactory;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        Intrinsics.checkNotNull((Object)eCParameterSpec);
        PublicKey publicKey2 = ((KeyFactory)object).generatePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
        Intrinsics.checkNotNull((Object)publicKey2);
        PublicKey publicKey3 = publicKey2;
        PublicKey publicKey4 = keyPair2.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey4, (String)"");
        PrivateKey privateKey = keyPair2.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"");
        return new EncryptionInfo(publicKey3, publicKey4, privateKey);
    }

    public static final CertificateInfo readClientCertificateRequest(u u2) {
        Collection collection;
        int n2;
        int n3;
        int n4;
        Intrinsics.checkNotNullParameter((Object)u2, (String)"");
        int n5 = u2.g() & 0xFF;
        byte[] byArray = w.a((u)u2, (int)n5);
        int n6 = u2.h() & 0xFFFF;
        List list = new ArrayList();
        int n7 = n6 / 2;
        for (int j = 0; j < n7; ++j) {
            n4 = j;
            n3 = 0;
            n2 = u2.g();
            byte by = u2.g();
            collection = list;
            HashAndSign hashAndSign = SignatureAlgorithmKt.byCode(HashAndSign.Companion, (byte)n2, by);
            if (hashAndSign == null) continue;
            collection.add(hashAndSign);
        }
        n7 = u2.h() & 0xFFFF;
        Set set = new LinkedHashSet();
        for (n4 = 0; n4 < n7; n4 += n3 + n2) {
            n3 = u2.h() & 0xFFFF;
            n2 = 2;
            byte[] byArray2 = w.a((u)u2, (int)n3);
            ((Collection)set).add(new X500Principal(byArray2));
        }
        Collection collection2 = list;
        boolean bl = false;
        collection = collection2;
        CertificateInfo certificateInfo = new CertificateInfo(byArray, collection.toArray(new HashAndSign[0]), set);
        if (!u2.f()) {
            throw new IllegalStateException("Check failed.");
        }
        return certificateInfo;
    }

    public static final /* synthetic */ byte[] access$generateClientSeed(SecureRandom secureRandom) {
        return TLSClientHandshakeKt.generateClientSeed(secureRandom);
    }

    public static final /* synthetic */ EncryptionInfo access$generateECKeys(NamedCurve namedCurve, ECPoint eCPoint) {
        return TLSClientHandshakeKt.generateECKeys(namedCurve, eCPoint);
    }
}

