/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.util.CryptoKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.b.a;
import kotlinx.b.r;
import kotlinx.b.u;
import kotlinx.b.w;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u001fR\u0014\u0010'\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\"R\u0014\u0010(\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010%R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010+\u00a8\u0006-"}, d2={"Lio/ktor/network/tls/cipher/CBCCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "(Lio/ktor/network/tls/TLSRecord;)Lio/ktor/network/tls/TLSRecord;", "decrypt", "content", "prepareMac", "(Lio/ktor/network/tls/TLSRecord;[B)[B", "Lkotlinx/io/Sink;", "", "writePadding", "(Lkotlinx/io/Sink;)V", "", "paddingStart", "validatePadding", "([BI)V", "macOffset", "validateMac", "(Lio/ktor/network/tls/TLSRecord;[BI)V", "Lio/ktor/network/tls/CipherSuite;", "[B", "Ljavax/crypto/Cipher;", "sendCipher", "Ljavax/crypto/Cipher;", "Ljavax/crypto/spec/SecretKeySpec;", "sendKey", "Ljavax/crypto/spec/SecretKeySpec;", "Ljavax/crypto/Mac;", "sendMac", "Ljavax/crypto/Mac;", "receiveCipher", "receiveKey", "receiveMac", "", "inputCounter", "J", "outputCounter", "ktor-network-tls"})
public final class CBCCipher
implements TLSCipher {
    private final CipherSuite suite;
    private final byte[] keyMaterial;
    private final Cipher sendCipher;
    private final SecretKeySpec sendKey;
    private final Mac sendMac;
    private final Cipher receiveCipher;
    private final SecretKeySpec receiveKey;
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;

    public CBCCipher(CipherSuite cipherSuite, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        this.suite = cipherSuite;
        this.keyMaterial = byArray;
        Cipher cipher = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        this.sendCipher = cipher;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac);
        this.sendMac = mac;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher2);
        this.receiveCipher = cipher2;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac2);
        this.receiveMac = mac2;
    }

    @Override
    public TLSRecord encrypt(TLSRecord tLSRecord) {
        Intrinsics.checkNotNullParameter((Object)tLSRecord, (String)"");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce((int)this.suite.getFixedIvLength())));
        byte[] byArray = w.b((u)tLSRecord.getPacket());
        byte[] byArray2 = this.prepareMac(tLSRecord, byArray);
        boolean bl = false;
        a a2 = new a();
        r r2 = (r)a2;
        boolean bl2 = false;
        BytePacketBuilderKt.writeFully$default((r)r2, (byte[])byArray, (int)0, (int)0, (int)6, null);
        BytePacketBuilderKt.writeFully$default((r)r2, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        this.writePadding(r2);
        u u2 = (u)a2;
        u u3 = CipherUtilsKt.cipherLoop(u2, this.sendCipher, (Function1<? super r, Unit>)((Function1)arg_0 -> CBCCipher.encrypt$lambda$1(this, arg_0)));
        return new TLSRecord(tLSRecord.getType(), null, u3, 2, null);
    }

    @Override
    public TLSRecord decrypt(TLSRecord tLSRecord) {
        Intrinsics.checkNotNullParameter((Object)tLSRecord, (String)"");
        u u2 = tLSRecord.getPacket();
        byte[] byArray = w.a((u)u2, (int)this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(byArray));
        byte[] byArray2 = w.b((u)CipherUtilsKt.cipherLoop$default(u2, this.receiveCipher, null, 2, null));
        int n2 = byArray2[byArray2.length - 1] & 0xFF;
        int n3 = byArray2.length - n2 - 1;
        int n4 = n3 - this.suite.getMacStrengthInBytes();
        this.validatePadding(byArray2, n3);
        this.validateMac(tLSRecord, byArray2, n4);
        boolean bl = false;
        a a2 = new a();
        r r2 = (r)a2;
        boolean bl2 = false;
        BytePacketBuilderKt.writeFully((r)r2, (byte[])byArray2, (int)0, (int)n4);
        u u3 = (u)a2;
        return new TLSRecord(tLSRecord.getType(), tLSRecord.getVersion(), u3);
    }

    private final byte[] prepareMac(TLSRecord tLSRecord, byte[] byArray) {
        byte[] byArray2;
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        byte[] byArray3 = byArray2 = new byte[13];
        boolean bl = false;
        CipherKt.set(byArray3, 0, this.outputCounter);
        byArray3[8] = (byte)tLSRecord.getType().getCode();
        byArray3[9] = 3;
        byArray3[10] = 3;
        CipherKt.set(byArray3, 11, (short)byArray.length);
        byte[] byArray4 = byArray2;
        ++this.outputCounter;
        this.sendMac.update(byArray4);
        byte[] byArray5 = this.sendMac.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"");
        return byArray5;
    }

    private final void writePadding(r r2) {
        int n2 = (BytePacketBuilderKt.getSize((r)r2) + 1) % this.sendCipher.getBlockSize();
        byte by = (byte)(this.sendCipher.getBlockSize() - n2);
        int n3 = by + 1;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            boolean bl = false;
            r2.a(by);
        }
    }

    private final void validatePadding(byte[] byArray, int n2) {
        int n3 = byArray[byArray.length - 1] & 0xFF;
        int n4 = byArray.length;
        for (int j = n2; j < n4; ++j) {
            int n5 = byArray[j] & 0xFF;
            if (n3 == n5) continue;
            throw new TLSException("Padding invalid: expected " + n3 + ", actual " + n5, null, 2, null);
        }
    }

    private final void validateMac(TLSRecord tLSRecord, byte[] byArray, int n2) {
        byte[] byArray2;
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        byte[] byArray3 = byArray2 = new byte[13];
        boolean bl = false;
        CipherKt.set(byArray3, 0, this.inputCounter);
        byArray3[8] = (byte)tLSRecord.getType().getCode();
        byArray3[9] = 3;
        byArray3[10] = 3;
        CipherKt.set(byArray3, 11, (short)n2);
        byte[] byArray4 = byArray2;
        long l2 = this.inputCounter;
        this.inputCounter = l2 + 1L;
        this.receiveMac.update(byArray4);
        this.receiveMac.update(byArray, 0, n2);
        byte[] byArray5 = this.receiveMac.doFinal();
        Intrinsics.checkNotNull((Object)byArray5);
        byte[] byArray6 = byArray5;
        byArray3 = ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)n2, (int)(n2 + this.suite.getMacStrengthInBytes())));
        if (!MessageDigest.isEqual(byArray6, byArray3)) {
            throw new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    private static final Unit encrypt$lambda$1(CBCCipher cBCCipher, r r2) {
        Intrinsics.checkNotNullParameter((Object)r2, (String)"");
        byte[] byArray = cBCCipher.sendCipher.getIV();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        BytePacketBuilderKt.writeFully$default((r)r2, (byte[])byArray, (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }
}

